/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.presentations.IPresentablePart;

public abstract class LayoutPart
implements ISizeProvider {
    protected ILayoutContainer container;
    protected String id;
    private ListenerList propertyListeners = new ListenerList(1);
    public static final String PROP_VISIBILITY = "PROP_VISIBILITY";
    private int deferCount = 0;

    public LayoutPart(String string) {
        this.id = string;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyListeners.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyListeners.remove((Object)iPropertyChangeListener);
    }

    public abstract void createControl(Composite var1);

    public void dispose() {
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, 0, 0);
    }

    public ILayoutContainer getContainer() {
        return this.container;
    }

    public abstract Control getControl();

    public String getID() {
        return this.id;
    }

    public String getCompoundId() {
        return this.getID();
    }

    public boolean isCompressible() {
        return false;
    }

    private IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public Point getSize() {
        Rectangle rectangle = this.getBounds();
        Point point = new Point(rectangle.width, rectangle.height);
        return point;
    }

    public int getSizeFlags(boolean bl) {
        return 128;
    }

    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        return n3;
    }

    public boolean isDocked() {
        Shell shell = this.getShell();
        if (shell == null) {
            return false;
        }
        return shell.getData() instanceof IWorkbenchWindow;
    }

    public Shell getShell() {
        Control control = this.getControl();
        if (!SwtUtil.isDisposed(control)) {
            return control.getShell();
        }
        return null;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        Shell shell = this.getShell();
        Object object = shell.getData();
        if (object instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)object;
        }
        return null;
    }

    public void moveAbove(Control control) {
    }

    public void reparent(Composite composite) {
        Control control = this.getControl();
        if (control == null || control.getParent() == composite) {
            return;
        }
        if (control.isReparentable()) {
            control.setBounds(0, 0, 0, 0);
            boolean bl = control.getEnabled();
            control.setEnabled(false);
            control.setParent(composite);
            control.setEnabled(bl);
        }
    }

    public boolean getVisible() {
        Control control = this.getControl();
        if (!SwtUtil.isDisposed(control)) {
            return control.getVisible();
        }
        return false;
    }

    public boolean isVisible() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            return control.isVisible();
        }
        return false;
    }

    public void setVisible(boolean bl) {
        Control control = this.getControl();
        if (!SwtUtil.isDisposed(control)) {
            if (bl == control.getVisible()) {
                return;
            }
            if (!bl && this.isFocusAncestor(control)) {
                control.getShell().forceFocus();
            }
            control.setVisible(bl);
            Object[] objectArray = this.propertyListeners.getListeners();
            if (objectArray.length > 0) {
                Boolean bl2 = bl ? Boolean.FALSE : Boolean.TRUE;
                Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, PROP_VISIBILITY, (Object)bl2, (Object)bl3);
                int n = 0;
                while (n < objectArray.length) {
                    ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
                    ++n;
                }
            }
        }
    }

    private boolean isFocusAncestor(Control control) {
        Control control2 = control.getDisplay().getFocusControl();
        while (control2 != null && control2 != control) {
            control2 = control2.getParent();
        }
        return control2 == control;
    }

    public void setBounds(Rectangle rectangle) {
        Control control = this.getControl();
        if (!SwtUtil.isDisposed(control)) {
            control.setBounds(rectangle);
        }
    }

    public void setContainer(ILayoutContainer iLayoutContainer) {
        this.container = iLayoutContainer;
        if (iLayoutContainer != null) {
            this.setZoomed(iLayoutContainer.childIsZoomed(this));
        }
    }

    public void setFocus() {
    }

    public void setID(String string) {
        this.id = string;
    }

    public LayoutPart getPart() {
        return this;
    }

    public IPresentablePart getPresentablePart() {
        return null;
    }

    public void childRequestZoomIn(LayoutPart layoutPart) {
    }

    public void childRequestZoomOut() {
    }

    public final void requestZoomOut() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            iLayoutContainer.childRequestZoomOut();
        }
    }

    public final void requestZoomIn() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            iLayoutContainer.childRequestZoomIn(this);
        }
    }

    public final boolean isObscuredByZoom() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            return iLayoutContainer.childObscuredByZoom(this);
        }
        return false;
    }

    public boolean childObscuredByZoom(LayoutPart layoutPart) {
        return false;
    }

    public boolean childIsZoomed(LayoutPart layoutPart) {
        return false;
    }

    public void setZoomed(boolean bl) {
    }

    public final void deferUpdates(boolean bl) {
        if (bl) {
            if (this.deferCount == 0) {
                this.startDeferringEvents();
            }
            ++this.deferCount;
        } else if (this.deferCount > 0) {
            --this.deferCount;
            if (this.deferCount == 0) {
                this.handleDeferredEvents();
            }
        }
    }

    protected void startDeferringEvents() {
    }

    protected void handleDeferredEvents() {
    }

    protected final boolean isDeferred() {
        return this.deferCount > 0;
    }

    protected ListenerList getPropertyListeners() {
        return this.propertyListeners;
    }

    public void describeLayout(StringBuffer stringBuffer) {
    }

    public String getPlaceHolderId() {
        return this.getID();
    }

    public void resizeChild(LayoutPart layoutPart) {
    }

    public void flushLayout() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (this.getContainer() != null) {
            iLayoutContainer.resizeChild(this);
        }
    }

    public boolean allowsAdd(LayoutPart layoutPart) {
        return false;
    }

    public void testInvariants() {
    }
}

