/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ExtensionEventHandlerMessages;
import org.eclipse.ui.internal.misc.ShowMessage;
import org.eclipse.ui.internal.registry.RegistryElement;

public abstract class RegistryManager
implements IRegistryChangeListener {
    private String elementId;
    private String extPtId;
    private Map cache;
    public static final int REGISTRY_CACHE_STATE_UNKNOWN = 0;
    public static final int REGISTRY_CACHE_STATE_ACTIVE = 1;
    public static final int REGISTRY_CACHE_STATE_DELETED = 2;
    public static final int REGISTRY_CACHE_STATE_MAX = 2;
    public static final String INTERNAL_REGISTRY_ADDITION = "InternalRegistryAddition";
    protected List changeList = new ArrayList(10);

    public RegistryManager(String string, String string2) {
        this.elementId = string;
        this.extPtId = string2;
        this.cache = new HashMap();
    }

    public void addResetMessage(String string) {
        this.changeList.add(string);
    }

    public Object[] getRegistryObjects() {
        Object[] objectArray = this.cache.values().toArray();
        if (objectArray.length == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < objectArray.length) {
            List list = ((RegistryElement)objectArray[n]).getRealObjects();
            if (list != null) {
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    arrayList.add(listIterator.next());
                }
            }
            ++n;
        }
        arrayList.trimToSize();
        Object[] objectArray2 = arrayList.toArray();
        return objectArray2;
    }

    /*
     * Exception decompiling
     */
    public void registryChanged(IRegistryChangeEvent var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 153->157)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doAdd(Display display, final IExtensionDelta iExtensionDelta) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                RegistryManager.this.add(iExtensionDelta);
            }
        };
        display.syncExec(runnable);
    }

    public void add(IExtensionDelta iExtensionDelta) {
        IExtension iExtension = iExtensionDelta.getExtension();
        String string = iExtension.getNamespace();
        this.add(this.buildNewCacheObject(iExtensionDelta), string);
    }

    public void add(Object object, String string) {
        RegistryElement registryElement;
        if (object == null) {
            return;
        }
        String string2 = string;
        if (string == null || string.length() == 0) {
            string2 = INTERNAL_REGISTRY_ADDITION;
        }
        if ((registryElement = (RegistryElement)this.cache.get(string2)) == null) {
            registryElement = new RegistryElement(object);
            this.cache.put(string2, registryElement);
        } else {
            registryElement.addNewObject(object);
        }
    }

    public void add(Object[] objectArray, String string) {
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.add(objectArray[n], string);
                ++n;
            }
        }
    }

    public abstract Object[] buildNewCacheObject(IExtensionDelta var1);

    private void doRemove(Display display, final IExtensionDelta iExtensionDelta) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                RegistryManager.this.remove(iExtensionDelta);
            }
        };
        display.syncExec(runnable);
    }

    public void remove(IExtensionDelta iExtensionDelta) {
        IExtension iExtension = iExtensionDelta.getExtension();
        String string = iExtension.getNamespace();
        this.removeBundle(string);
    }

    protected void handleBundleRemoved(String string, Object object) {
    }

    public void postChangeProcessing() {
        this.resetCurrentPerspective(PlatformUI.getWorkbench().getDisplay());
    }

    private void resetCurrentPerspective(Display display) {
        if (display == null || this.changeList.isEmpty()) {
            return;
        }
        final StringBuffer stringBuffer = new StringBuffer(ExtensionEventHandlerMessages.ExtensionEventHandler_following_changes);
        Iterator iterator = this.changeList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        stringBuffer.append(ExtensionEventHandlerMessages.ExtensionEventHandler_need_to_reset);
        display.asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage iWorkbenchPage;
                Shell shell = null;
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    if (iWorkbench.getWorkbenchWindowCount() == 0) {
                        return;
                    }
                    iWorkbenchWindow = iWorkbench.getWorkbenchWindows()[0];
                }
                if (ShowMessage.openQuestion(shell = iWorkbenchWindow.getShell(), ExtensionEventHandlerMessages.ExtensionEventHandler_reset_perspective, stringBuffer.toString()) && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                    iWorkbenchPage.resetPerspective();
                }
                RegistryManager.this.changeList.clear();
            }
        });
    }

    public void remove(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.remove(stringArray[n]);
            ++n;
        }
    }

    public void remove(String string) {
        RegistryElement registryElement = (RegistryElement)this.cache.get(string);
        if (registryElement != null) {
            registryElement.changeState(2);
        }
    }

    public void removeBundle(String string) {
        RegistryElement registryElement;
        if (string == null) {
            string = INTERNAL_REGISTRY_ADDITION;
        }
        if ((registryElement = (RegistryElement)this.cache.get(string)) == null) {
            return;
        }
        this.cache.remove(string);
        Iterator iterator = registryElement.getRealObjects().iterator();
        while (iterator.hasNext()) {
            this.handleBundleRemoved(string, iterator.next());
        }
    }

    public void remove(String string, Object object) {
        RegistryElement registryElement;
        if (string == null) {
            string = INTERNAL_REGISTRY_ADDITION;
        }
        if ((registryElement = (RegistryElement)this.cache.get(string)) != null) {
            List list = registryElement.getRealObjects();
            list.remove(object);
        }
    }

    public void cleanRegistry() {
        Iterator<Object> iterator;
        Set set = this.cache.keySet();
        HashSet<Iterator<Object>> hashSet = new HashSet<Iterator<Object>>();
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            iterator = iterator2.next();
            RegistryElement registryElement = (RegistryElement)this.cache.get(iterator);
            if (registryElement == null || registryElement.getState() != 2) continue;
            hashSet.add(iterator);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.cache.remove(iterator.next());
        }
    }
}

