/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.UGLErrorHandler;
import com.ibm.ugl.eswt.OS;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.InternalGCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    Shell activeShell;
    boolean systemColorsCreated = false;
    static Display Default;
    static Display[] Displays;
    static final String PACKAGE_NAME;
    static final int[][] KeyCodeMap;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] timers;
    Runnable[] disposeList;
    Tray tray;
    Event[] eventQueue;
    EventTable eventTable;
    EventTable filterTable;
    Object data;
    String[] keys;
    Object[] values;
    int defaultPalette;
    int borderTrimWidth = 4;
    int borderTrimHeight = 4;
    int titleTrimWidth = 4;
    int titleTrimHeight = 24;
    Color COLOR_INFO_FOREGROUND;
    Color COLOR_INFO_BACKGROUND;
    Color COLOR_TITLE_FOREGROUND;
    Color COLOR_TITLE_BACKGROUND;
    Color COLOR_TITLE_BACKGROUND_GRADIENT;
    Color COLOR_TITLE_INACTIVE_FOREGROUND;
    Color COLOR_TITLE_INACTIVE_BACKGROUND;
    Color COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
    Color COLOR_WIDGET_DARK_SHADOW;
    Color COLOR_WIDGET_NORMAL_SHADOW;
    Color COLOR_WIDGET_LIGHT_SHADOW;
    Color COLOR_WIDGET_HIGHLIGHT_SHADOW;
    Color COLOR_WIDGET_BACKGROUND;
    Color COLOR_WIDGET_FOREGROUND;
    Color COLOR_WIDGET_BORDER;
    Color COLOR_LIST_FOREGROUND;
    Color COLOR_LIST_BACKGROUND;
    Color COLOR_LIST_SELECTION;
    Color COLOR_LIST_SELECTION_TEXT;
    private Control focusControl = null;
    private Hashtable shells = null;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Display;

    static void setDevice(Device device) {
        Internal_CurrentDevice = device;
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        this.checkDevice();
        OS.Display_Beep(this.internal_handle);
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            SWT.error(43);
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void internal_create() {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
        this.internal_handle = OS.Display_New();
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        super.destroy();
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        for (int i = 0; i < this.disposeList.length; ++i) {
            if (this.disposeList[i] != null) continue;
            this.disposeList[i] = runnable;
            return;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    static synchronized void checkDisplay(Thread thread) {
        for (int i = 0; i < Displays.length; ++i) {
            if (Displays[i] == null || Display.Displays[i].thread != thread) continue;
            SWT.error(22);
        }
    }

    static int convertToUglKeyCode(int swtKeyCode) {
        for (int i = 0; i < KeyCodeMap.length; ++i) {
            if (KeyCodeMap[i][1] != swtKeyCode) continue;
            return KeyCodeMap[i][0];
        }
        return swtKeyCode;
    }

    static int convertToSwtKeyCode(int uglKeyCode) {
        if (uglKeyCode >= 65 && uglKeyCode <= 90) {
            return uglKeyCode + 32;
        }
        for (int i = 0; i < KeyCodeMap.length; ++i) {
            if (KeyCodeMap[i][0] != uglKeyCode) continue;
            return KeyCodeMap[i][1];
        }
        return 0;
    }

    static synchronized void deregister(Display display) {
        for (int i = 0; i < Displays.length; ++i) {
            if (display != Displays[i]) continue;
            Display.Displays[i] = null;
        }
    }

    public static synchronized Display findDisplay(Thread thread) {
        for (int i = 0; i < Displays.length; ++i) {
            Display display = Displays[i];
            if (display == null || display.thread != thread) continue;
            return display;
        }
        return null;
    }

    static synchronized boolean noDisplaysExist() {
        for (int i = 0; i < Displays.length; ++i) {
            if (Displays[i] == null) continue;
            return false;
        }
        return true;
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        Rectangle bounds = this.getBounds();
        int[] insetArray = OS.Display_GetInsets(this.internal_handle);
        return new Rectangle(bounds.x + insetArray[0], bounds.y + insetArray[1], bounds.width - (insetArray[2] + insetArray[0]), bounds.height - (insetArray[1] + insetArray[3]));
    }

    public static synchronized Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            SWT.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return this.values[i];
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    static synchronized void register(Display display) {
        for (int i = 0; i < Displays.length; ++i) {
            if (Displays[i] != null) continue;
            Display.Displays[i] = display;
            return;
        }
        Display[] newDisplays = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
        newDisplays[Display.Displays.length] = display;
        Displays = newDisplays;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.Display_GetDoubleClickTime(this.internal_handle);
    }

    public Control getFocusControl() {
        this.checkDevice();
        return this.focusControl;
    }

    void setFocusControl(Control control) {
        this.focusControl = control;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public Shell[] getShells() {
        this.checkDevice();
        if (this.shells == null || this.shells.size() == 0) {
            return new Shell[0];
        }
        int count = 0;
        Enumeration elementEnum = this.shells.elements();
        while (elementEnum.hasMoreElements()) {
            Shell shell = (Shell)elementEnum.nextElement();
            if (shell.isDisposed() || this != shell.getDisplay()) continue;
            ++count;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        elementEnum = this.shells.elements();
        while (elementEnum.hasMoreElements()) {
            Shell shell = (Shell)elementEnum.nextElement();
            if (shell.isDisposed() || this != shell.getDisplay()) continue;
            result[index++] = shell;
        }
        return result;
    }

    void addShell(Shell shell) {
        if (this.shells == null) {
            this.shells = new Hashtable();
        }
        this.shells.put(shell, shell);
    }

    void removeShell(Shell shell) {
        this.shells.remove(shell);
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        if (!this.systemColorsCreated) {
            this.initSystemColors();
        }
        switch (id) {
            case 30: {
                return this.COLOR_TITLE_FOREGROUND;
            }
            case 31: {
                return this.COLOR_TITLE_BACKGROUND;
            }
            case 32: {
                return this.COLOR_TITLE_BACKGROUND_GRADIENT;
            }
            case 33: {
                return this.COLOR_TITLE_INACTIVE_FOREGROUND;
            }
            case 34: {
                return this.COLOR_TITLE_INACTIVE_BACKGROUND;
            }
            case 35: {
                return this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
            }
            case 17: {
                return this.COLOR_WIDGET_DARK_SHADOW;
            }
            case 18: {
                return this.COLOR_WIDGET_NORMAL_SHADOW;
            }
            case 19: {
                return this.COLOR_WIDGET_LIGHT_SHADOW;
            }
            case 20: {
                return this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
            }
            case 22: {
                return this.COLOR_WIDGET_BACKGROUND;
            }
            case 21: {
                return this.COLOR_WIDGET_FOREGROUND;
            }
            case 23: {
                return this.COLOR_WIDGET_BORDER;
            }
            case 24: {
                return this.COLOR_LIST_FOREGROUND;
            }
            case 25: {
                return this.COLOR_LIST_BACKGROUND;
            }
            case 26: {
                return this.COLOR_LIST_SELECTION;
            }
            case 27: {
                return this.COLOR_LIST_SELECTION_TEXT;
            }
        }
        return super.getSystemColor(id);
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        return this.thread;
    }

    protected void init() {
        super.init();
        this.initCallbacks();
    }

    void initCallbacks() {
        OS.Display_InitCallbacks(this.internal_handle, this);
        OS.Display_RegisterCallback(this.internal_handle, 0, "org/eclipse/swt/widgets/Button", "buttonCallback");
        OS.Display_RegisterCallback(this.internal_handle, 1, "org/eclipse/swt/widgets/List", "listCallback");
        OS.Display_RegisterCallback(this.internal_handle, 2, "org/eclipse/swt/widgets/Shell", "shellCallback");
        OS.Display_RegisterCallback(this.internal_handle, 3, "org/eclipse/swt/widgets/Widget", "scrollbarCallback");
        OS.Display_RegisterCallback(this.internal_handle, 4, "org/eclipse/swt/widgets/Combo", "choiceCallback");
        OS.Display_RegisterCallback(this.internal_handle, 14, "org/eclipse/swt/widgets/Combo", "comboCallback");
        OS.Display_RegisterCallback(this.internal_handle, 5, "org/eclipse/swt/widgets/Control", "keyCallback");
        OS.Display_RegisterCallback(this.internal_handle, 6, "org/eclipse/swt/widgets/Text", "textModifyCallback");
        OS.Display_RegisterCallback(this.internal_handle, 1458260670, "org/eclipse/swt/widgets/Control", "hasMenuCallback");
        OS.Display_RegisterCallback(this.internal_handle, 7, "org/eclipse/swt/widgets/Control", "pointerCallback");
        OS.Display_RegisterCallback(this.internal_handle, 8, "org/eclipse/swt/widgets/MenuItem", "selectionCallback");
        OS.Display_RegisterCallback(this.internal_handle, 9, "org/eclipse/swt/widgets/Control", "focusCallback");
        OS.Display_RegisterCallback(this.internal_handle, 10, "org/eclipse/swt/widgets/Control", "paintCallback");
        OS.Display_RegisterCallback(this.internal_handle, 11, "org/eclipse/swt/widgets/Shell", "resizeCallback");
        OS.Display_RegisterCallback(this.internal_handle, 12, "org/eclipse/swt/widgets/Shell", "moveCallback");
        OS.Display_RegisterCallback(this.internal_handle, 13, "org/eclipse/swt/widgets/Display", "timerCallback");
        OS.Display_RegisterCallback(this.internal_handle, 15, "org/eclipse/swt/widgets/Control", "textVerifyCallback");
        OS.Display_RegisterCallback(this.internal_handle, 16, "org/eclipse/swt/widgets/Menu", "menuCallback");
        OS.Display_RegisterCallback(this.internal_handle, 50, "org/eclipse/swt/widgets/TrayItem", "TrayItemCallback");
    }

    void initSystemColors() {
        this.COLOR_INFO_FOREGROUND = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 25));
        this.COLOR_INFO_BACKGROUND = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 24));
        this.COLOR_TITLE_FOREGROUND = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 27));
        this.COLOR_TITLE_BACKGROUND_GRADIENT = this.COLOR_TITLE_BACKGROUND = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 26));
        this.COLOR_TITLE_INACTIVE_FOREGROUND = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 5));
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = this.COLOR_TITLE_INACTIVE_BACKGROUND = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 4));
        this.COLOR_WIDGET_DARK_SHADOW = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 22));
        this.COLOR_WIDGET_LIGHT_SHADOW = this.COLOR_WIDGET_NORMAL_SHADOW = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 21));
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 19));
        this.COLOR_WIDGET_BACKGROUND = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 17));
        this.COLOR_WIDGET_BORDER = this.COLOR_WIDGET_FOREGROUND = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 18));
        this.COLOR_LIST_FOREGROUND = this.COLOR_WIDGET_FOREGROUND;
        this.COLOR_LIST_BACKGROUND = this.COLOR_WIDGET_BACKGROUND;
        this.COLOR_LIST_SELECTION = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 14));
        this.COLOR_LIST_SELECTION_TEXT = Color.internal_newFromHandle(this, OS.Display_GetSystemColor(this.internal_handle, 15));
        this.systemColorsCreated = true;
    }

    public void internal_copyArea(int imageHandle, int x, int y, int width, int height) {
        OS.Device_CopyArea(this.internal_handle, imageHandle, x, y, width, height);
    }

    public void internal_dispose_GC(int gc, InternalGCData data) {
    }

    public Rectangle internal_getBounds() {
        return this.getBounds();
    }

    public int internal_getDepth() {
        return OS.Device_GetDepth(this.internal_handle);
    }

    public int internal_new_GC(InternalGCData data) {
        this.checkDevice();
        int graphics = OS.Device_NewGraphics(this.internal_handle);
        data.device = this;
        data.font = this.getSystemFont();
        return graphics;
    }

    static boolean isValidClass(Class clazz) {
        int index;
        String name = clazz.getName();
        if (name.substring(0, (index = name.lastIndexOf(46)) + 1).equals(PACKAGE_NAME)) {
            return true;
        }
        return name.substring(0, index + 1).equals("org.eclipse.ercp.swt.mobile.");
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            SWT.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            SWT.error(5);
        }
        if (to != null && to.isDisposed()) {
            SWT.error(5);
        }
        Point point = new Point(x, y);
        if (to != null && from != null) {
            point = from.toDisplay(point);
            point = to.toControl(point);
        } else if (to != null) {
            point = to.toControl(point);
        } else if (from != null) {
            point = from.toDisplay(point);
        }
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            SWT.error(5);
        }
        if (to != null && to.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = new Rectangle(x, y, width, height);
        if (to != null && from != null) {
            Point topLeft = from.toDisplay(x, y);
            topLeft = to.toControl(topLeft);
            rectangle.x = topLeft.x;
            rectangle.y = topLeft.y;
        } else if (to != null) {
            Point topLeft = to.toControl(x, y);
            rectangle.x = topLeft.x;
            rectangle.y = topLeft.y;
        } else if (from != null) {
            Point topLeft = from.toDisplay(x, y);
            rectangle.x = topLeft.x;
            rectangle.y = topLeft.y;
        }
        return rectangle;
    }

    public boolean post(Event event) {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if (event == null) {
            SWT.error(4);
        }
        int type = event.type;
        switch (type) {
            case 1: 
            case 2: {
                char character = event.character;
                int uglKeyCode = Display.convertToUglKeyCode(event.keyCode);
                if (character > '\u0000' && uglKeyCode == event.keyCode) {
                    uglKeyCode = character;
                }
                switch (character) {
                    case '\u007f': {
                        uglKeyCode = 1012;
                        character = '\u0000';
                        break;
                    }
                    case '\b': {
                        uglKeyCode = 1000;
                        character = '\u0000';
                        break;
                    }
                    case '\r': {
                        uglKeyCode = 1002;
                        character = '\u0000';
                        break;
                    }
                    case '\u001b': {
                        uglKeyCode = 1003;
                        character = '\u0000';
                        break;
                    }
                    case '\t': {
                        uglKeyCode = 1001;
                        character = '\u0000';
                        break;
                    }
                    case '\n': {
                        uglKeyCode = 1002;
                        character = '\u0000';
                    }
                }
                if (uglKeyCode < 0) {
                    return false;
                }
                int keyEventType = type == 2 ? 2 : 1;
                return OS.Display_PostKeyEvent(this.internal_handle, keyEventType, uglKeyCode, character);
            }
            case 3: 
            case 4: {
                int button;
                switch (event.button) {
                    case 1: {
                        button = 8;
                        break;
                    }
                    case 2: {
                        button = 16;
                        break;
                    }
                    case 3: {
                        button = 32;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                int mouseEventType = type == 3 ? 1 : 2;
                return OS.Display_PostPointerEvent(this.internal_handle, mouseEventType, button);
            }
            case 5: {
                int x = event.x;
                int y = event.y;
                return OS.Display_PostPointerMoveEvent(this.internal_handle, x, y);
            }
        }
        return false;
    }

    void postEvent(Event event) {
        int index;
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int length = this.eventQueue.length;
        for (index = 0; index < length && this.eventQueue[index] != null; ++index) {
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        if (OS.Display_ReadAndDispatch(this.internal_handle)) {
            this.runDeferredEvents();
            return true;
        }
        return this.runAsyncMessages();
    }

    protected void release() {
        this.sendEvent(12, new Event());
        if (this.shells != null && this.shells.size() > 0) {
            Enumeration elementEnum = this.shells.elements();
            while (elementEnum.hasMoreElements()) {
                Shell shell = (Shell)elementEnum.nextElement();
                if (shell.isDisposed() || this != shell.getDisplay()) continue;
                shell.dispose();
            }
        }
        while (this.readAndDispatch()) {
        }
        this.runDeferredEvents();
        this.runAsyncMessages();
        if (this.disposeList != null) {
            for (int i = 0; i < this.disposeList.length; ++i) {
                if (this.disposeList[i] == null) continue;
                this.disposeList[i].run();
            }
        }
        this.disposeList = null;
        if (this.systemColorsCreated) {
            this.releaseSystemColors();
        }
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        this.thread = null;
        this.data = null;
        this.keys = null;
        this.values = null;
    }

    void releaseSystemColors() {
        this.COLOR_INFO_FOREGROUND.dispose();
        this.COLOR_INFO_BACKGROUND.dispose();
        this.COLOR_TITLE_FOREGROUND.dispose();
        this.COLOR_TITLE_BACKGROUND.dispose();
        this.COLOR_TITLE_BACKGROUND_GRADIENT.dispose();
        this.COLOR_TITLE_INACTIVE_FOREGROUND.dispose();
        this.COLOR_TITLE_INACTIVE_BACKGROUND.dispose();
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT.dispose();
        this.COLOR_WIDGET_DARK_SHADOW.dispose();
        this.COLOR_WIDGET_NORMAL_SHADOW.dispose();
        this.COLOR_WIDGET_LIGHT_SHADOW.dispose();
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW.dispose();
        this.COLOR_WIDGET_BACKGROUND.dispose();
        this.COLOR_WIDGET_FOREGROUND.dispose();
        this.COLOR_WIDGET_BORDER.dispose();
        this.COLOR_LIST_FOREGROUND.dispose();
        this.COLOR_LIST_BACKGROUND.dispose();
        this.COLOR_LIST_SELECTION.dispose();
        this.COLOR_LIST_SELECTION_TEXT.dispose();
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    boolean runAsyncMessages() {
        return this.synchronizer.runAsyncMessages();
    }

    boolean runDeferredEvents() {
        Event event;
        while (this.eventQueue != null && (event = this.eventQueue[0]) != null) {
            Widget item;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            widget.notifyListeners(event.type, event);
        }
        this.eventQueue = null;
        return true;
    }

    int getLastEventTime() {
        return (int)System.currentTimeMillis() & Integer.MAX_VALUE;
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    public static void setAppName(String name) {
        OS.Display_SetAppName(name);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            SWT.error(4);
        }
        if (value == null) {
            int index;
            if (this.keys == null) {
                return;
            }
            for (index = 0; index < this.keys.length && !this.keys[index].equals(key); ++index) {
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            this.values[i] = value;
            return;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            SWT.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages();
        }
        this.synchronizer = synchronizer;
    }

    public boolean sleep() {
        this.checkDevice();
        OS.Display_Sleep(this.internal_handle);
        this.runDeferredEvents();
        return true;
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        int index;
        this.checkDevice();
        if (runnable == null) {
            SWT.error(4);
        }
        if (milliseconds < 0) {
            return;
        }
        if (this.timers == null) {
            this.timers = new Runnable[4];
        }
        for (index = 0; index < this.timers.length && this.timers[index] != null; ++index) {
        }
        if (index == this.timers.length) {
            Runnable[] newTimers = new Runnable[this.timers.length + 4];
            System.arraycopy(this.timers, 0, newTimers, 0, this.timers.length);
            this.timers = newTimers;
        }
        this.timers[index] = runnable;
        OS.Display_StartTimer(this.internal_handle, milliseconds, index);
    }

    void timerCallback(int id) {
        if (id < 0 || id >= this.timers.length) {
            return;
        }
        Runnable r = this.timers[id];
        if (r != null) {
            this.syncExec(r);
        }
        this.timers[id] = null;
    }

    public void update() {
        this.checkDevice();
        if (this.shells != null) {
            Enumeration elementEnum = this.shells.elements();
            while (elementEnum.hasMoreElements()) {
                Shell shell = (Shell)elementEnum.nextElement();
                if (shell.isDisposed() || this != shell.getDisplay()) continue;
                shell.update(true);
            }
        }
    }

    public void wake() {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        this.wakeThread();
    }

    void wakeThread() {
        OS.Display_Wake(this.internal_handle);
    }

    public Rectangle internal_getDefaultClipping() {
        return this.getBounds();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Displays = new Display[4];
        String name = (class$org$eclipse$swt$widgets$Display == null ? (class$org$eclipse$swt$widgets$Display = Display.class$("org.eclipse.swt.widgets.Display")) : class$org$eclipse$swt$widgets$Display).getName();
        int index = name.lastIndexOf(46);
        PACKAGE_NAME = name.substring(0, index + 1);
        OS.uglErrorHandler = new ESWTErrorHandler();
        KeyCodeMap = new int[][]{{1000, 8}, {1001, 9}, {1002, 13}, {1003, 27}, {1006, 0x1000055}, {1007, 0x1000007}, {1008, 0x1000008}, {1009, 0x1000005}, {1010, 0x1000006}, {1011, 0x1000009}, {1012, 127}, {1013, 0x1000003}, {1014, 0x1000004}, {1015, 0x1000001}, {1016, 0x1000002}, {1017, 131072}, {1018, 65536}, {1019, 262144}, {1020, 16777298}, {1021, 16777299}, {1022, 16777300}, {1023, 0x100000A}, {1024, 0x100000B}, {1025, 0x100000C}, {1026, 0x100000D}, {1027, 0x100000E}, {1028, 0x100000F}, {1029, 0x1000010}, {1030, 0x1000011}, {1031, 0x1000012}, {1032, 0x1000013}, {1033, 0x1000014}, {1034, 0x1000015}, {1035, 0x1000016}, {1036, 0x1000017}, {1037, 0x1000018}, {1067, 16777258}, {1068, 16777259}, {1069, 16777261}, {1070, 16777262}, {1071, 16777263}, {1072, 0x1000030}, {1073, 0x1000031}, {1074, 16777266}, {1075, 0x1000033}, {1076, 16777268}, {1077, 16777269}, {1078, 16777270}, {1079, 16777271}, {1080, 16777272}, {1081, 16777273}, {1082, 0x1000050}, {1082, 16777277}};
        Internal_DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static class ESWTErrorHandler
    implements UGLErrorHandler {
        ESWTErrorHandler() {
        }

        public void respond(String uglFunction, int errorCode, String errorMessage) {
            if (uglFunction.startsWith("Image_")) {
                if (errorCode == -7) {
                    SWT.error(39);
                } else if (errorCode == -4) {
                    SWT.error(2);
                } else if (errorCode == -5) {
                    SWT.error(38);
                } else if (errorCode == -8) {
                    SWT.error(40);
                } else if (errorCode == -6) {
                    SWT.error(42);
                }
            } else if (uglFunction.startsWith("Font_")) {
                if (errorCode == -4) {
                    SWT.error(2);
                }
            } else if (uglFunction.startsWith("Graphics_")) {
                if (errorCode == -4) {
                    SWT.error(2);
                }
            } else if ((uglFunction.equals("MenuBar_New") || uglFunction.equals("PopupMenu_New") || uglFunction.equals("DropDownMenu_New")) && errorCode == -4) {
                SWT.error(2);
            }
            if (errorCode == -4) {
                throw new OutOfMemoryError();
            }
            if (errorCode == -1) {
                SWT.error(20);
            }
            if (errorCode == -3) {
                throw new RuntimeException("Unexpected native exception: " + errorMessage);
            }
        }
    }
}

