/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.scheduler;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.SiteManager;

public class ScheduledSiteInitialize
implements IStartup {
    private static boolean isThereEarlierFeature = false;

    public void earlyStartup() {
        ScheduledSiteInitialize.createTargetSite();
    }

    public static synchronized IConfiguredSite createTargetSite() {
        try {
            File workspaceSiteFile = new File(Platform.getLocation() + "\\applications\\eclipse");
            IInstallConfiguration currentConfig = SiteManager.getLocalSite().getCurrentConfiguration();
            IConfiguredSite workspaceSite = null;
            boolean wasWorkspaceSiteLoaded = false;
            IConfiguredSite[] allSites = currentConfig.getConfiguredSites();
            int i = 0;
            while (i < allSites.length) {
                if (allSites[i].getSite().getURL().sameFile(workspaceSiteFile.toURL())) {
                    wasWorkspaceSiteLoaded = true;
                    return allSites[i];
                }
                ++i;
            }
            if (!wasWorkspaceSiteLoaded) {
                if (!workspaceSiteFile.exists()) {
                    workspaceSiteFile.mkdirs();
                }
                workspaceSite = currentConfig.createConfiguredSite(workspaceSiteFile);
                currentConfig.addConfiguredSite(workspaceSite);
                workspaceSite.verifyUpdatableStatus();
                SiteManager.getLocalSite().save();
                if (workspaceSite.getConfiguredFeatures().length > 0) {
                    isThereEarlierFeature = true;
                }
                return workspaceSite;
            }
        }
        catch (IllegalStateException ise) {
            ise.printStackTrace();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        return null;
    }

    public static boolean isRestartNeeded() {
        return isThereEarlierFeature;
    }
}

