/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.service.datalocation.Location;

public class InstancePreferences
extends EclipsePreferences {
    private String qualifier;
    private int segmentCount;
    private IEclipsePreferences loadLevel;
    private IPath location;
    private static Set loadedNodes = new HashSet();
    private static boolean initialized = false;
    private static IPath baseLocation;

    private static IPath getBaseLocation() {
        Location location;
        if (baseLocation == null && (location = PreferencesOSGiUtils.getDefault().getInstanceLocation()) != null && (location.isSet() || location.allowsDefault())) {
            baseLocation = MetaDataKeeper.getMetaArea().getStateLocation("org.eclipse.core.runtime");
        }
        return baseLocation;
    }

    public InstancePreferences() {
        this(null, null);
    }

    private InstancePreferences(EclipsePreferences eclipsePreferences, String string) {
        super(eclipsePreferences, string);
        this.initializeChildren();
        String string2 = this.absolutePath();
        this.segmentCount = InstancePreferences.getSegmentCount(string2);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = InstancePreferences.getSegment(string2, 1);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return loadedNodes.contains(iEclipsePreferences.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadLegacy() {
        block19: {
            var1_1 = new Path(this.absolutePath());
            if (var1_1.segmentCount() != 2) {
                return;
            }
            if (PreferencesOSGiUtils.getDefault().getInstanceLocation() == null) {
                if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL == false) return;
                PrefsMessages.message("Cannot load Legacy plug-in preferences since instance location is not set.");
                return;
            }
            var2_2 = var1_1.segment(1);
            var3_3 = null;
            var4_4 = PreferencesOSGiUtils.getDefault().getInstanceLocation();
            if (var4_4 != null && var4_4.isSet()) {
                var3_3 = MetaDataKeeper.getMetaArea().getPreferenceLocation(var2_2, false).toFile();
            }
            if (var3_3 == null) {
                if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL == false) return;
                PrefsMessages.message("Cannot load legacy values because instance location is not set.");
                return;
            }
            if (!var3_3.exists()) {
                if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL == false) return;
                PrefsMessages.message("Legacy plug-in preference file not found: " + var3_3);
                return;
            }
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Loading legacy preferences from " + var3_3);
            }
            var5_5 = null;
            var6_6 = new Properties();
            try {
                try {
                    var5_5 = new BufferedInputStream(new FileInputStream(var3_3));
                    var6_6.load(var5_5);
                }
                catch (IOException v0) {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                        PrefsMessages.message("IOException encountered loading legacy preference file " + var3_3);
                    }
                    var7_7 = null;
                    if (var5_5 == null) return;
                    try {
                        var5_5.close();
                        return;
                    }
                    catch (IOException var9_10) {
                        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL == false) return;
                        PrefsMessages.message("IOException encountered closing legacy preference file " + var3_3);
                        var9_10.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable var8_13) {
                var7_8 = null;
                if (var5_5 == null) throw var8_13;
                ** try [egrp 2[TRYBLOCK] [3 : 249->257)] { 
lbl49:
                // 1 sources

                var5_5.close();
                throw var8_13;
lbl51:
                // 1 sources

                catch (IOException var9_11) {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL == false) throw var8_13;
                    PrefsMessages.message("IOException encountered closing legacy preference file " + var3_3);
                    var9_11.printStackTrace();
                }
                throw var8_13;
            }
            {
                var7_9 = null;
                if (var5_5 == null) break block19;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 249->257)] { 
lbl59:
            // 1 sources

            var5_5.close();
            break block19;
lbl61:
            // 1 sources

            catch (IOException var9_12) {
                if (!EclipsePreferences.DEBUG_PREFERENCE_GENERAL) break block19;
                PrefsMessages.message("IOException encountered closing legacy preference file " + var3_3);
                var9_12.printStackTrace();
            }
        }
        var7_9 = var6_6.keySet().iterator();
        while (true) {
            if (!var7_9.hasNext()) {
                if (var3_3.delete() != false) return;
                if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL == false) return;
                PrefsMessages.message("Unable to delete legacy preferences file: " + var3_3);
                return;
            }
            var8_14 = (String)var7_9.next();
            var9_12 = var6_6.getProperty(var8_14);
            if (var9_12 == null) continue;
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Loaded legacy preference: " + var8_14 + " -> " + (String)var9_12);
            }
            if (var9_12.equals(var10_15 = this.internalPut(var8_14, (String)var9_12))) continue;
            this.makeDirty();
        }
    }

    protected IPath getLocation() {
        if (this.location == null) {
            this.location = this.computeLocation(InstancePreferences.getBaseLocation(), this.qualifier);
        }
        return this.location;
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences iEclipsePreferences = this;
            int n = 2;
            while (n < this.segmentCount) {
                iEclipsePreferences = (IEclipsePreferences)iEclipsePreferences.parent();
                ++n;
            }
            this.loadLevel = iEclipsePreferences;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeChildren() {
        if (initialized) return;
        if (this.parent == null) {
            return;
        }
        try {
            InstancePreferences instancePreferences = this;
            synchronized (instancePreferences) {
                String[] stringArray = this.computeChildren(InstancePreferences.getBaseLocation());
                int n = 0;
                while (true) {
                    block8: {
                        if (n < stringArray.length) break block8;
                        break;
                    }
                    this.addChild(stringArray[n], null);
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            initialized = true;
            throw throwable;
        }
        {
            Object var4_6 = null;
            initialized = true;
            return;
        }
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new InstancePreferences(eclipsePreferences, string);
    }
}

