/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.IObjectContributor;

public abstract class ObjectContributorManager
implements IExtensionChangeHandler {
    protected Map contributors = new Hashtable(5);
    protected Map objectLookup = null;
    protected Map resourceAdapterLookup = null;
    protected Map adaptableLookup = null;
    protected Set contributorRecordSet = new HashSet(5);
    static /* synthetic */ Class class$0;

    public ObjectContributorManager() {
        PlatformUI.getWorkbench().getExtensionTracker();
    }

    private void addContributorsFor(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            List list3 = (List)this.contributors.get(clazz.getName());
            if (list3 == null) continue;
            list2.addAll(list3);
        }
    }

    protected final List computeClassOrder(Class clazz) {
        ArrayList arrayList = new ArrayList(4);
        Class clazz2 = clazz;
        while (clazz2 != null) {
            arrayList.add(clazz2);
            clazz2 = clazz2.getSuperclass();
        }
        return arrayList;
    }

    protected final List computeInterfaceOrder(List list) {
        ArrayList arrayList = new ArrayList(4);
        HashMap hashMap = new HashMap(4);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Class[] classArray = ((Class)iterator.next()).getInterfaces();
            this.internalComputeInterfaceOrder(classArray, arrayList, hashMap);
        }
        return arrayList;
    }

    public void flushLookup() {
        this.objectLookup = null;
        this.resourceAdapterLookup = null;
        this.adaptableLookup = null;
    }

    private void cacheResourceAdapterLookup(Class clazz, List list) {
        if (this.resourceAdapterLookup == null) {
            this.resourceAdapterLookup = new HashMap();
        }
        this.resourceAdapterLookup.put(clazz, list);
    }

    private void cacheAdaptableLookup(String string, List list) {
        if (this.adaptableLookup == null) {
            this.adaptableLookup = new HashMap();
        }
        this.adaptableLookup.put(string, list);
    }

    private void cacheObjectLookup(Class clazz, List list) {
        if (this.objectLookup == null) {
            this.objectLookup = new HashMap();
        }
        this.objectLookup.put(clazz, list);
    }

    public Collection getContributors() {
        return Collections.unmodifiableCollection(this.contributors.values());
    }

    protected List addContributorsFor(Class clazz) {
        List list = this.computeClassOrder(clazz);
        ArrayList arrayList = new ArrayList();
        this.addContributorsFor(list, arrayList);
        list = this.computeInterfaceOrder(list);
        this.addContributorsFor(list, arrayList);
        return arrayList;
    }

    public boolean hasContributorsFor(Object object) {
        List list = this.getContributors(object);
        return list.size() > 0;
    }

    private void internalComputeInterfaceOrder(Class[] classArray, List list, Map map) {
        ArrayList<Class> arrayList = new ArrayList<Class>(map.size());
        int n = 0;
        while (n < classArray.length) {
            Class clazz = classArray[n];
            if (map.get(clazz) == null) {
                list.add(clazz);
                map.put(clazz, clazz);
                arrayList.add(clazz);
            }
            ++n;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.internalComputeInterfaceOrder(((Class)iterator.next()).getInterfaces(), list, map);
        }
    }

    public boolean isApplicableTo(IStructuredSelection iStructuredSelection, IObjectContributor iObjectContributor) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            if (iObjectContributor.isApplicableTo(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isApplicableTo(List list, IObjectContributor iObjectContributor) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iObjectContributor.isApplicableTo(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void registerContributor(IObjectContributor iObjectContributor, String string) {
        ArrayList<IObjectContributor> arrayList = (ArrayList<IObjectContributor>)this.contributors.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<IObjectContributor>(5);
            this.contributors.put(string, arrayList);
        }
        arrayList.add(iObjectContributor);
        this.flushLookup();
        if (iObjectContributor instanceof IAdaptable) {
            IConfigurationElement iConfigurationElement;
            IAdaptable iAdaptable = (IAdaptable)iObjectContributor;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.IConfigurationElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iConfigurationElement = (IConfigurationElement)iAdaptable.getAdapter((Class)clazz)) == null) {
                return;
            }
            ContributorRecord contributorRecord = new ContributorRecord(iObjectContributor, string);
            this.contributorRecordSet.add(contributorRecord);
            PlatformUI.getWorkbench().getExtensionTracker().registerObject(iConfigurationElement.getDeclaringExtension(), (Object)contributorRecord, 2);
        }
    }

    public void unregisterAllContributors() {
        this.contributors = new Hashtable(5);
        this.flushLookup();
    }

    public void unregisterContributor(IObjectContributor iObjectContributor, String string) {
        List list = (List)this.contributors.get(string);
        if (list == null) {
            return;
        }
        list.remove(iObjectContributor);
        if (list.isEmpty()) {
            this.contributors.remove(string);
        }
        this.flushLookup();
    }

    public void unregisterContributors(String string) {
        this.contributors.remove(string);
        this.flushLookup();
    }

    protected List getContributors(Object object) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(Platform.getAdapterManager().computeAdapterTypes(object.getClass())));
        this.removeCommonAdapters(arrayList, Arrays.asList(object.getClass()));
        List list = this.getObjectContributors(object.getClass());
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                list.addAll(this.getAdaptableContributors(string));
            }
        }
        return list;
    }

    protected List getObjectContributors(Class clazz) {
        List list = null;
        if (this.objectLookup != null) {
            list = (List)this.objectLookup.get(clazz);
        }
        if (list == null) {
            list = this.addContributorsFor(clazz);
            if (list.size() == 0) {
                list = Collections.EMPTY_LIST;
            }
            this.cacheObjectLookup(clazz, list);
        }
        return new ArrayList(list);
    }

    protected List getResourceContributors(Class clazz) {
        List list = null;
        if (this.resourceAdapterLookup != null) {
            list = (List)this.resourceAdapterLookup.get(clazz);
        }
        if (list == null) {
            list = this.addContributorsFor(clazz);
            list = list.size() == 0 ? Collections.EMPTY_LIST : this.filterOnlyAdaptableContributors(list);
            this.cacheResourceAdapterLookup(clazz, list);
        }
        return new ArrayList(list);
    }

    protected List getAdaptableContributors(String string) {
        List list = null;
        if (this.adaptableLookup != null) {
            list = (ArrayList)this.adaptableLookup.get(string);
        }
        if (list == null) {
            list = new ArrayList(this.contributors.size());
            list = (List)this.contributors.get(string);
            list = list == null || list.size() == 0 ? Collections.EMPTY_LIST : this.filterOnlyAdaptableContributors(list);
            this.cacheAdaptableLookup(string, list);
        }
        return new ArrayList(list);
    }

    protected void removeCommonAdapters(List list, List list2) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            List list3 = this.computeCombinedOrder(clazz);
            Iterator iterator2 = list3.iterator();
            while (iterator2.hasNext()) {
                Class clazz2 = (Class)iterator2.next();
                list.remove(clazz2.getName());
            }
        }
    }

    protected List computeCombinedOrder(Class clazz) {
        ArrayList arrayList = new ArrayList(4);
        Class clazz2 = clazz;
        while (clazz2 != null) {
            arrayList.add(clazz2);
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                arrayList.add(classArray[n]);
                ++n;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return arrayList;
    }

    private List filterOnlyAdaptableContributors(List list) {
        ArrayList<IObjectContributor> arrayList = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IObjectContributor iObjectContributor = (IObjectContributor)iterator.next();
            if (!iObjectContributor.canAdapt()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<IObjectContributor>();
            }
            arrayList.add(iObjectContributor);
        }
        return arrayList == null ? Collections.EMPTY_LIST : arrayList;
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof ContributorRecord) {
                ContributorRecord contributorRecord = (ContributorRecord)objectArray[n];
                this.unregisterContributor(contributorRecord.contributor, contributorRecord.objectClassName);
                this.contributorRecordSet.remove(contributorRecord);
            }
            ++n;
        }
    }

    public void dispose() {
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    private class ContributorRecord {
        String objectClassName;
        IObjectContributor contributor;

        public ContributorRecord(IObjectContributor iObjectContributor, String string) {
            this.contributor = iObjectContributor;
            this.objectClassName = string;
        }
    }
}

