/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReferenceCounter {
    private Map mapIdToRec = new HashMap(11);

    public int addRef(Object object) {
        RefRec refRec = (RefRec)this.mapIdToRec.get(object);
        if (refRec == null) {
            return 0;
        }
        return refRec.addRef();
    }

    public Object get(Object object) {
        RefRec refRec = (RefRec)this.mapIdToRec.get(object);
        if (refRec == null) {
            return null;
        }
        return refRec.getValue();
    }

    public Set keySet() {
        return this.mapIdToRec.keySet();
    }

    public void put(Object object, Object object2) {
        RefRec refRec = new RefRec(object, object2);
        this.mapIdToRec.put(object, refRec);
    }

    public int removeRef(Object object) {
        RefRec refRec = (RefRec)this.mapIdToRec.get(object);
        if (refRec == null) {
            return 0;
        }
        int n = refRec.removeRef();
        if (n <= 0) {
            this.mapIdToRec.remove(object);
        }
        return n;
    }

    public List values() {
        int n = this.mapIdToRec.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        Iterator iterator = this.mapIdToRec.values().iterator();
        while (iterator.hasNext()) {
            RefRec refRec = (RefRec)iterator.next();
            arrayList.add(refRec.getValue());
        }
        return arrayList;
    }

    public class RefRec {
        public Object id;
        public Object value;
        private int refCount;

        public RefRec(Object object, Object object2) {
            this.id = object;
            this.value = object2;
            this.addRef();
        }

        public Object getId() {
            return this.id;
        }

        public Object getValue() {
            return this.value;
        }

        public int addRef() {
            ++this.refCount;
            return this.refCount;
        }

        public int removeRef() {
            --this.refCount;
            return this.refCount;
        }

        public int getRef() {
            return this.refCount;
        }

        public boolean isNotReferenced() {
            return this.refCount <= 0;
        }
    }
}

