/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.misc.Assert;

public class WorkbenchPreferenceDialog
extends PreferenceDialog {
    private static WorkbenchPreferenceDialog instance = null;
    private String rootNodeToDisplayId;

    public static final WorkbenchPreferenceDialog createDialogOn(Shell shell, String string) {
        WorkbenchPreferenceDialog workbenchPreferenceDialog;
        if (instance == null) {
            Object object;
            IWorkbenchWindow iWorkbenchWindow;
            Shell shell2 = shell;
            if (shell2 == null && (iWorkbenchWindow = (object = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()) != null) {
                shell2 = iWorkbenchWindow.getShell();
            }
            object = (WorkbenchPreferenceManager)PlatformUI.getWorkbench().getPreferenceManager();
            workbenchPreferenceDialog = new WorkbenchPreferenceDialog(shell2, (PreferenceManager)object);
            workbenchPreferenceDialog.setRootNodeToDisplay(string);
        } else {
            workbenchPreferenceDialog = instance;
        }
        return workbenchPreferenceDialog;
    }

    public WorkbenchPreferenceDialog(Shell shell, PreferenceManager preferenceManager) {
        super(shell, preferenceManager);
        Assert.isTrue(instance == null, "There cannot be two preference dialogs at once in the workbench.");
        instance = this;
    }

    protected Control createContents(PreferenceDialog preferenceDialog) {
        Composite composite = null;
        Iterator iterator = this.preferenceManager.getRootElements().iterator();
        while (iterator.hasNext()) {
            PreferenceNode preferenceNode = (PreferenceNode)iterator.next();
            if (this.rootNodeToDisplayId != null && !preferenceNode.getId().equals(this.rootNodeToDisplayId)) continue;
            composite = this.createSubPages((IPreferenceNode)preferenceNode);
        }
        return composite;
    }

    public void close() {
        instance = null;
        super.close();
    }

    public void setRootNodeToDisplay(String string) {
        this.rootNodeToDisplayId = string;
    }
}

