/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.swt.mobile.TaskTip;
import org.eclipse.ercp.update.UIImage;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.ScrolledText;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.util.CategoryWrap;
import org.eclipse.update.util.FeatureWrap;
import org.eclipse.update.util.INode;
import org.eclipse.update.util.SiteWrap;

public class SelectFeaturesScreen
extends AbsScreen
implements TreeListener {
    private Tree featureList;
    private ScrolledText description;
    private Label requiredSpace;
    private Label freeSpace;
    private int checkedCount;
    private Vector taggedFeatures = new Vector();
    private UpdateMonitor downloadFeatureJarMonitor;
    private DownloadFeatureJarThread downloadFeatureJarThread;
    private boolean enableEnvFilter = true;

    public SelectFeaturesScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(UIMessages.SelectFeaturesToInstall);
        if (this.view.parent.getClientArea().height * 2 < this.view.parent.getClientArea().width) {
            Composite composite = new Composite(this.screen, 0);
            composite.setLayout((Layout)new FormLayout());
            composite.setLayoutData((Object)new GridData(1808));
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(70, -2);
            FormData formData2 = new FormData();
            formData2.top = new FormAttachment(0, 0);
            formData2.bottom = new FormAttachment(100, 0);
            formData2.left = new FormAttachment(70, 2);
            formData2.right = new FormAttachment(100, 0);
            this.featureList = new Tree(composite, 2080);
            this.featureList.addSelectionListener((SelectionListener)this);
            this.featureList.addTreeListener((TreeListener)this);
            this.featureList.setLayoutData((Object)formData);
            this.description = new ScrolledText(composite, 0, 2048, 3);
            this.description.setLayoutData(formData2);
            Composite composite2 = new Composite(this.screen, 0);
            composite2.setLayoutData((Object)new GridData(768));
            composite2.setLayout((Layout)new FillLayout(256));
            this.requiredSpace = new Label(composite2, 0);
            this.freeSpace = new Label(composite2, 0);
            composite2.layout();
        } else {
            this.featureList = new Tree(this.screen, 32);
            this.featureList.addSelectionListener((SelectionListener)this);
            this.featureList.addTreeListener((TreeListener)this);
            this.featureList.setLayoutData((Object)new GridData(1808));
            this.separator();
            this.description = new ScrolledText(this.screen, 0, 0, 2);
            this.description.setLayoutData(new GridData(768));
            Composite composite = new Composite(this.screen, 0);
            composite.setLayoutData((Object)new GridData(768));
            composite.setLayout((Layout)new FillLayout(256));
            this.requiredSpace = new Label(composite, 0);
            this.freeSpace = new Label(composite, 0);
            composite.layout();
        }
        this.setButtons(1, 2, 3);
        this.screen.layout();
        if (Boolean.valueOf(System.getProperty("org.eclipse.ercp.update.disableEnvFilter")).booleanValue()) {
            this.enableEnvFilter = false;
        }
    }

    protected void refresh() {
        this.checkedCount = 0;
        this.featureList.removeAll();
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.description.setText("");
        int n = 0;
        while (n < this.view.viewedTree.size()) {
            SiteWrap siteWrap = (SiteWrap)this.view.viewedTree.elementAt(n);
            if (siteWrap.getUiObject() != null) break;
            TreeItem treeItem = new TreeItem(this.featureList, 0);
            treeItem.setText(siteWrap.getName());
            treeItem.setImage(UIImage.ICON_SITE.createImage());
            siteWrap.setUiObject(treeItem);
            CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
            int n2 = 0;
            while (n2 < categoryWrapArray.length) {
                CategoryWrap categoryWrap = categoryWrapArray[n2];
                TreeItem treeItem2 = new TreeItem((TreeItem)siteWrap.getUiObject(), 0);
                treeItem2.setText(categoryWrap.getLabel());
                treeItem2.setImage(UIImage.ICON_CATEGORY.createImage());
                categoryWrap.setUiObject(treeItem2);
                FeatureWrap[] featureWrapArray = categoryWrap.getChildren();
                int n3 = 0;
                while (n3 < featureWrapArray.length) {
                    FeatureWrap featureWrap = featureWrapArray[n3];
                    TreeItem treeItem3 = new TreeItem((TreeItem)categoryWrap.getUiObject(), 0);
                    treeItem3.setText(featureWrap.getShowedName());
                    treeItem3.setImage(UIImage.ICON_FEATURE.createImage());
                    featureWrap.addUiObject(treeItem3);
                    ++n3;
                }
                ++n2;
            }
            if (categoryWrapArray.length == 0) {
                treeItem.setGrayed(true);
            }
            ++n;
        }
        this.updateSpaceIndicators();
    }

    protected void action() {
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        this.featureList.setFocus();
    }

    private void updateSpaceIndicators() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new Object[2];
        long l = 0L;
        this.checkedCount = 0;
        this.nextButton.setEnabled(false);
        int n = 0;
        while (n < this.view.availableFeatures.size()) {
            FeatureWrap featureWrap = (FeatureWrap)this.view.availableFeatures.elementAt(n);
            if (featureWrap.isSelected()) {
                ++this.checkedCount;
                l += featureWrap.getFeatureSize();
                this.nextButton.setEnabled(true);
            }
            ++n;
        }
        if (l > 1024L) {
            objectArray[0] = new Long(l >> 10).toString();
            objectArray[1] = UIMessages.MegaBytes;
            this.requiredSpace.setText(NLS.bind((String)UIMessages.RequiredSpace, (Object[])objectArray));
        } else {
            objectArray[0] = new Long(l).toString();
            objectArray[1] = UIMessages.KiloBytes;
            this.requiredSpace.setText(NLS.bind((String)UIMessages.RequiredSpace, (Object[])objectArray));
        }
        long l2 = -1L;
        try {
            l2 = Long.valueOf(System.getProperty("wed.eUpdate.availableSpace")) >> 10;
            if (l2 <= l) {
                this.nextButton.setEnabled(false);
            }
            if (l2 > 1024L) {
                objectArray2[0] = new Long(l2 >> 10).toString();
                objectArray2[1] = UIMessages.MegaBytes;
                this.freeSpace.setText(NLS.bind((String)UIMessages.FreeSpace, (Object[])objectArray2));
            } else {
                objectArray2[0] = new Long(l2).toString();
                objectArray2[1] = UIMessages.KiloBytes;
                this.freeSpace.setText(NLS.bind((String)UIMessages.FreeSpace, (Object[])objectArray2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.freeSpace.setText("");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.featureList) {
            if (this.downloadFeatureJarThread != null && this.downloadFeatureJarThread.getStatus() == 1) {
                return;
            }
            TreeItem treeItem = (TreeItem)selectionEvent.item;
            if (treeItem == null) {
                this.description.setText("");
                return;
            }
            INode iNode = null;
            int n = 0;
            while (n < this.view.viewedTree.size()) {
                iNode = ((INode)this.view.viewedTree.elementAt(n)).findByUiObject(treeItem);
                if (iNode != null) break;
                ++n;
            }
            if (selectionEvent.detail == 32) {
                this.description.setText("");
                this.taggedFeatures.removeAllElements();
                if (treeItem.getChecked()) {
                    this.rememberCurrentChecks();
                }
                if (iNode instanceof SiteWrap) {
                    this.checkSiteNode((SiteWrap)iNode, treeItem.getChecked());
                } else if (iNode instanceof CategoryWrap) {
                    this.checkCategoryNode((CategoryWrap)iNode, treeItem.getChecked());
                } else if (iNode instanceof FeatureWrap) {
                    if (treeItem.getGrayed()) {
                        this.description.setText(UIMessages.FeatureIsIncompatible);
                        treeItem.setChecked(false);
                        return;
                    }
                    this.checkFeatureNode((FeatureWrap)iNode, treeItem.getChecked());
                }
                this.downloadNeededFeatureInfo();
            } else {
                this.description.setText(iNode.getDescription());
                this.screen.layout();
            }
            return;
        }
        if (selectionEvent.widget == this.backButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, false);
        } else if (selectionEvent.widget == this.cancelButton) {
            if (this.downloadFeatureJarMonitor != null) {
                this.downloadFeatureJarMonitor.setCanceled(true);
            }
        } else if (selectionEvent.widget == this.nextButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(3, true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.featureList) {
            this.widgetSelected(selectionEvent);
        }
    }

    private boolean isIncompatibleFeature(FeatureWrap featureWrap) {
        if (this.enableEnvFilter) {
            IFeature iFeature = featureWrap.getFeature();
            if (iFeature.getOS() != null && this.isNotInSupportedList(iFeature.getOS(), Platform.getOS())) {
                return true;
            }
            if (iFeature.getWS() != null && this.isNotInSupportedList(iFeature.getWS(), Platform.getWS())) {
                return true;
            }
            if (iFeature.getOSArch() != null && this.isNotInSupportedList(iFeature.getOSArch(), Platform.getOSArch())) {
                return true;
            }
            if (iFeature.getNL() != null && this.isNotInSupportedLanguageList(iFeature.getNL(), Platform.getNL())) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isNotInSupportedList(String var1_1, String var2_2) {
        var3_3 = new StringTokenizer(var1_1.trim(), ",");
        if (var3_3.countTokens() != 0) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (!var2_2.equalsIgnoreCase(var3_3.nextToken().trim())) continue;
            return false;
lbl6:
            // 2 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl7:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isNotInSupportedLanguageList(String var1_1, String var2_2) {
        var3_3 = new StringTokenizer(var1_1.trim(), ",");
        if (var3_3.countTokens() != 0) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            var4_4 = var3_3.nextToken().trim();
            if (!(var4_4.indexOf(95) > -1 ? var2_2.equals(var4_4) != false : var2_2.startsWith(var4_4) != false)) continue;
            return false;
lbl7:
            // 2 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl8:
        // 1 sources

        return true;
    }

    private void checkSiteNode(SiteWrap siteWrap, boolean bl) {
        TreeItem treeItem = (TreeItem)siteWrap.getUiObject();
        treeItem.setChecked(bl);
        if (bl) {
            treeItem.setExpanded(true);
        }
        siteWrap.setSelected(bl);
        CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
        int n = 0;
        while (n < categoryWrapArray.length) {
            this.checkCategoryNode(categoryWrapArray[n], bl);
            ++n;
        }
    }

    private void checkCategoryNode(CategoryWrap categoryWrap, boolean bl) {
        TreeItem treeItem = (TreeItem)categoryWrap.getUiObject();
        treeItem.setChecked(bl);
        if (bl) {
            treeItem.setExpanded(true);
        }
        categoryWrap.setSelected(bl);
        FeatureWrap[] featureWrapArray = categoryWrap.getChildren();
        int n = 0;
        while (n < featureWrapArray.length) {
            this.checkFeatureNode(featureWrapArray[n], bl);
            ++n;
        }
    }

    private void checkFeatureNode(FeatureWrap featureWrap, boolean bl) {
        if (bl && !featureWrap.isFeatureReady()) {
            this.taggedFeatures.add(featureWrap);
        }
        if (featureWrap.isFeatureReady() && this.isIncompatibleFeature(featureWrap)) {
            return;
        }
        featureWrap.setSelected(bl);
        Vector vector = featureWrap.getUiObjects();
        int n = 0;
        while (n < vector.size()) {
            ((TreeItem)vector.elementAt(n)).setChecked(bl);
            ++n;
        }
    }

    private void finalizeAllCheckeds() {
        int n = 0;
        while (n < this.view.viewedTree.size()) {
            SiteWrap siteWrap = (SiteWrap)this.view.viewedTree.elementAt(n);
            boolean bl = false;
            CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
            int n2 = 0;
            while (n2 < categoryWrapArray.length) {
                boolean bl2 = false;
                FeatureWrap[] featureWrapArray = categoryWrapArray[n2].getChildren();
                int n3 = 0;
                while (n3 < featureWrapArray.length) {
                    if (featureWrapArray[n3].isSelected()) {
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                categoryWrapArray[n2].setSelected(bl2);
                ((TreeItem)categoryWrapArray[n2].getUiObject()).setChecked(bl2);
                ++n2;
            }
            siteWrap.setSelected(bl);
            ((TreeItem)siteWrap.getUiObject()).setChecked(bl);
            ++n;
        }
    }

    private boolean isRequiredFeatureInstalled(VersionedIdentifier versionedIdentifier) {
        int n = 0;
        while (n < this.view.installedFeatures.size()) {
            block4: {
                VersionedIdentifier versionedIdentifier2;
                try {
                    versionedIdentifier2 = ((IFeatureReference)this.view.installedFeatures.get(n)).getVersionedIdentifier();
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    break block4;
                }
                if (versionedIdentifier2.getIdentifier().equals(versionedIdentifier.getIdentifier()) && versionedIdentifier2.getVersion().isGreaterOrEqualTo(versionedIdentifier.getVersion())) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private boolean addRequiredFeatureInto(VersionedIdentifier versionedIdentifier) {
        int n = 0;
        while (n < this.view.availableFeatures.size()) {
            FeatureWrap featureWrap = (FeatureWrap)this.view.availableFeatures.elementAt(n);
            VersionedIdentifier versionedIdentifier2 = featureWrap.getVID();
            if (versionedIdentifier2.getIdentifier().equals(versionedIdentifier.getIdentifier()) && versionedIdentifier2.getVersion().isGreaterOrEqualTo(versionedIdentifier.getVersion())) {
                if (!featureWrap.isSelected()) {
                    if (!this.isIncompatibleFeature(featureWrap)) {
                        featureWrap.setSelected(true);
                        Vector vector = featureWrap.getUiObjects();
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            ((TreeItem)vector.elementAt(n2)).setChecked(true);
                            ((TreeItem)vector.elementAt(n2)).setText(featureWrap.getShowedName());
                            ++n2;
                        }
                    }
                } else {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private void resolveDependency() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.view.availableFeatures.size()) {
            block10: {
                FeatureWrap featureWrap = (FeatureWrap)this.view.availableFeatures.elementAt(n);
                if (featureWrap.isSelected()) {
                    IIncludedFeatureReference[] iIncludedFeatureReferenceArray;
                    try {
                        iIncludedFeatureReferenceArray = featureWrap.getFeature().getIncludedFeatureReferences();
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                        break block10;
                    }
                    int n2 = 0;
                    while (n2 < iIncludedFeatureReferenceArray.length) {
                        try {
                            if (!this.isRequiredFeatureInstalled(iIncludedFeatureReferenceArray[n2].getVersionedIdentifier()) && !this.addRequiredFeatureInto(iIncludedFeatureReferenceArray[n2].getVersionedIdentifier())) {
                                Vector vector = featureWrap.getUiObjects();
                                int n3 = 0;
                                while (n3 < vector.size()) {
                                    ((TreeItem)vector.elementAt(n3)).setImage(UIImage.ICON_BROKEN_FEATURE.createImage());
                                    ++n3;
                                }
                                stringBuffer.append(NLS.bind((String)UIMessages.NestedFeatureUnavailable, (Object[])new String[]{iIncludedFeatureReferenceArray[n2].getName()})).append("\n");
                            }
                        }
                        catch (CoreException coreException) {
                            coreException.printStackTrace();
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            this.description.setText(stringBuffer.toString());
        }
    }

    private void rememberCurrentChecks() {
        int n = 0;
        while (n < this.view.viewedTree.size()) {
            SiteWrap siteWrap = (SiteWrap)this.view.viewedTree.elementAt(n);
            siteWrap.setPreviousSelected(siteWrap.isSelected());
            CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
            int n2 = 0;
            while (n2 < categoryWrapArray.length) {
                CategoryWrap categoryWrap = categoryWrapArray[n2];
                categoryWrap.setPreviousSelected(categoryWrap.isSelected());
                FeatureWrap[] featureWrapArray = categoryWrap.getChildren();
                int n3 = 0;
                while (n3 < featureWrapArray.length) {
                    FeatureWrap featureWrap = featureWrapArray[n3];
                    featureWrap.setPreviousSelected(featureWrap.isSelected());
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void recoverPreviousChecks() {
        int n = 0;
        while (n < this.view.viewedTree.size()) {
            SiteWrap siteWrap = (SiteWrap)this.view.viewedTree.elementAt(n);
            siteWrap.setSelected(siteWrap.isPreviousSelected());
            ((TreeItem)siteWrap.getUiObject()).setChecked(siteWrap.isPreviousSelected());
            CategoryWrap[] categoryWrapArray = siteWrap.getChildren();
            int n2 = 0;
            while (n2 < categoryWrapArray.length) {
                CategoryWrap categoryWrap = categoryWrapArray[n2];
                categoryWrap.setSelected(categoryWrap.isPreviousSelected());
                ((TreeItem)categoryWrap.getUiObject()).setChecked(categoryWrap.isPreviousSelected());
                ((TreeItem)categoryWrap.getUiObject()).setExpanded(false);
                FeatureWrap[] featureWrapArray = categoryWrap.getChildren();
                int n3 = 0;
                while (n3 < featureWrapArray.length) {
                    FeatureWrap featureWrap = featureWrapArray[n3];
                    featureWrap.setSelected(featureWrap.isPreviousSelected());
                    Vector vector = featureWrap.getUiObjects();
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        ((TreeItem)vector.elementAt(n4)).setChecked(featureWrap.isPreviousSelected());
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void downloadNeededFeatureInfo() {
        if (this.taggedFeatures.size() < 1) {
            this.resolveDependency();
            this.finalizeAllCheckeds();
            this.updateSpaceIndicators();
            return;
        }
        this.featureList.setEnabled(false);
        this.backButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        final boolean bl = this.nextButton.getEnabled();
        this.nextButton.setEnabled(false);
        final TaskTip taskTip = new TaskTip(this.screen.getShell(), 2);
        taskTip.setText(UIMessages.DownloadFeatureInfo);
        taskTip.setVisible(true);
        this.cancelButton.setFocus();
        this.downloadFeatureJarMonitor = new UpdateMonitor();
        this.downloadFeatureJarThread = new DownloadFeatureJarThread("", this.taggedFeatures, this.downloadFeatureJarMonitor);
        this.downloadFeatureJarThread.start();
        Display.getCurrent().timerExec(400, new Runnable(){

            public void run() {
                if (SelectFeaturesScreen.this.downloadFeatureJarThread.isAlive()) {
                    Display.getCurrent().timerExec(400, (Runnable)this);
                } else {
                    taskTip.setVisible(false);
                    taskTip.dispose();
                    if (SelectFeaturesScreen.this.downloadFeatureJarThread.getStatus() == 2) {
                        SelectFeaturesScreen.this.resolveDependency();
                        SelectFeaturesScreen.this.finalizeAllCheckeds();
                        SelectFeaturesScreen.this.updateSpaceIndicators();
                    } else {
                        SelectFeaturesScreen.this.recoverPreviousChecks();
                        SelectFeaturesScreen.this.nextButton.setEnabled(bl);
                    }
                    SelectFeaturesScreen.this.featureList.setEnabled(true);
                    SelectFeaturesScreen.this.backButton.setEnabled(true);
                    SelectFeaturesScreen.this.cancelButton.setEnabled(false);
                    SelectFeaturesScreen.this.downloadFeatureJarThread = null;
                    SelectFeaturesScreen.this.downloadFeatureJarMonitor = null;
                    int n = 0;
                    while (n < SelectFeaturesScreen.this.taggedFeatures.size()) {
                        FeatureWrap featureWrap = (FeatureWrap)SelectFeaturesScreen.this.taggedFeatures.elementAt(n);
                        if (featureWrap.isFeatureReady()) {
                            boolean bl2 = true;
                            if (SelectFeaturesScreen.this.isIncompatibleFeature(featureWrap)) {
                                bl2 = false;
                                featureWrap.setSelected(false);
                            }
                            Vector vector = featureWrap.getUiObjects();
                            int n2 = 0;
                            while (n2 < vector.size()) {
                                TreeItem treeItem = (TreeItem)vector.elementAt(n2);
                                treeItem.setText(featureWrap.getShowedName());
                                if (!bl2) {
                                    treeItem.setChecked(false);
                                    treeItem.setGrayed(true);
                                    treeItem.setImage(UIImage.ICON_INCOMPATIBLE_FEATURE.createImage());
                                }
                                ++n2;
                            }
                        }
                        ++n;
                    }
                    SelectFeaturesScreen.this.featureList.setFocus();
                }
            }
        });
    }

    public void treeCollapsed(TreeEvent treeEvent) {
    }

    public void treeExpanded(TreeEvent treeEvent) {
        final TreeItem treeItem = (TreeItem)treeEvent.item;
        if (treeItem == null) {
            return;
        }
        INode iNode = null;
        int n = 0;
        while (n < this.view.viewedTree.size()) {
            iNode = ((INode)this.view.viewedTree.elementAt(n)).findByUiObject(treeItem);
            if (iNode != null) break;
            ++n;
        }
        if (iNode instanceof CategoryWrap) {
            this.taggedFeatures.removeAllElements();
            FeatureWrap[] featureWrapArray = ((CategoryWrap)iNode).getChildren();
            final boolean bl = false;
            while (bl < featureWrapArray.length) {
                if (!featureWrapArray[bl].isFeatureReady()) {
                    this.taggedFeatures.add(featureWrapArray[bl]);
                }
                bl += 1;
            }
            if (this.taggedFeatures.size() < 1) {
                return;
            }
            if ("win32".equals(Platform.getOS()) && "x86".equals(Platform.getOSArch())) {
                this.featureList.setEnabled(false);
            } else {
                this.featureList.setVisible(false);
            }
            this.backButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            bl = this.nextButton.getEnabled();
            this.nextButton.setEnabled(false);
            final TaskTip taskTip = new TaskTip(this.screen.getShell(), 2);
            taskTip.setText(UIMessages.DownloadFeatureInfo);
            taskTip.setVisible(true);
            this.cancelButton.setFocus();
            this.downloadFeatureJarMonitor = new UpdateMonitor();
            this.downloadFeatureJarThread = new DownloadFeatureJarThread("", this.taggedFeatures, this.downloadFeatureJarMonitor);
            this.downloadFeatureJarThread.start();
            Display.getCurrent().timerExec(400, new Runnable(){

                public void run() {
                    if (SelectFeaturesScreen.this.downloadFeatureJarThread.isAlive()) {
                        Display.getCurrent().timerExec(400, (Runnable)this);
                    } else {
                        taskTip.setVisible(false);
                        taskTip.dispose();
                        if (SelectFeaturesScreen.this.downloadFeatureJarThread.getStatus() != 2) {
                            treeItem.setExpanded(false);
                        }
                        if ("win32".equals(Platform.getOS()) && "x86".equals(Platform.getOSArch())) {
                            SelectFeaturesScreen.this.featureList.setEnabled(true);
                        } else {
                            SelectFeaturesScreen.this.featureList.setVisible(true);
                        }
                        SelectFeaturesScreen.this.backButton.setEnabled(true);
                        SelectFeaturesScreen.this.cancelButton.setEnabled(false);
                        SelectFeaturesScreen.this.nextButton.setEnabled(bl);
                        SelectFeaturesScreen.this.downloadFeatureJarThread = null;
                        SelectFeaturesScreen.this.downloadFeatureJarMonitor = null;
                        boolean bl2 = true;
                        int n = 0;
                        while (n < SelectFeaturesScreen.this.taggedFeatures.size()) {
                            FeatureWrap featureWrap = (FeatureWrap)SelectFeaturesScreen.this.taggedFeatures.elementAt(n);
                            if (featureWrap.isFeatureReady()) {
                                bl2 = true;
                                if (SelectFeaturesScreen.this.isIncompatibleFeature(featureWrap)) {
                                    bl2 = false;
                                    featureWrap.setSelected(false);
                                }
                                Vector vector = featureWrap.getUiObjects();
                                int n2 = 0;
                                while (n2 < vector.size()) {
                                    TreeItem treeItem2 = (TreeItem)vector.elementAt(n2);
                                    treeItem2.setText(featureWrap.getShowedName());
                                    if (!bl2) {
                                        treeItem2.setGrayed(true);
                                        treeItem2.setImage(UIImage.ICON_INCOMPATIBLE_FEATURE.createImage());
                                        treeItem2.setChecked(false);
                                    }
                                    ++n2;
                                }
                            }
                            ++n;
                        }
                        SelectFeaturesScreen.this.featureList.setFocus();
                    }
                }
            });
        }
    }

    private class DownloadFeatureJarThread
    extends Thread {
        public static final int NONE = 0;
        public static final int RUNNING = 1;
        public static final int SUCCESS = 2;
        public static final int ENDED = 3;
        private Vector tags;
        private IProgressMonitor monitor;
        private int currentStatus;

        public DownloadFeatureJarThread(String string, Vector vector, IProgressMonitor iProgressMonitor) {
            super(string);
            this.tags = vector;
            this.monitor = iProgressMonitor;
            this.currentStatus = 0;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 119->123)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public int getStatus() {
            return this.currentStatus;
        }
    }
}

