/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.presentations.IPresentablePart;

public class PresentablePart
implements IPresentablePart {
    private PartPane part;
    private List listeners = new ArrayList();
    private IPropertyListener lazyPropertyListenerProxy;

    public PresentablePart(PartPane partPane) {
        this.part = partPane;
    }

    private IPropertyListener getPropertyListenerProxy() {
        if (this.lazyPropertyListenerProxy == null) {
            this.lazyPropertyListenerProxy = new IPropertyListener(){

                public void propertyChanged(Object object, int n) {
                    PresentablePart.this.firePropertyChange(n);
                }
            };
        }
        return this.lazyPropertyListenerProxy;
    }

    private WorkbenchPartReference getPartReference() {
        return (WorkbenchPartReference)this.part.getPartReference();
    }

    public void dispose() {
        this.getPartReference().removePropertyListener(this.getPropertyListenerProxy());
        this.part = null;
        this.listeners.clear();
        this.listeners = null;
    }

    public void firePropertyChange(int n) {
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ((IPropertyListener)this.listeners.get(n2)).propertyChanged(this, n);
            ++n2;
        }
    }

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        if (this.listeners.isEmpty()) {
            this.getPartReference().addPropertyListener(this.getPropertyListenerProxy());
        }
        this.listeners.add(iPropertyListener);
    }

    public void removePropertyListener(IPropertyListener iPropertyListener) {
        this.listeners.remove(iPropertyListener);
        if (this.listeners.isEmpty()) {
            this.getPartReference().removePropertyListener(this.getPropertyListenerProxy());
        }
    }

    public void setBounds(Rectangle rectangle) {
        if (!SwtUtil.isDisposed(this.part.getControl())) {
            this.part.setBounds(rectangle);
        }
    }

    public void setVisible(boolean bl) {
        this.part.setVisible(bl);
    }

    public void setFocus() {
        if (!SwtUtil.isDisposed(this.part.getControl())) {
            this.part.setFocus();
        }
    }

    public String getName() {
        return this.getPartReference().getPartName();
    }

    public String getTitle() {
        return this.getPartReference().getTitle();
    }

    public String getTitleStatus() {
        return this.getPartReference().getContentDescription();
    }

    public Image getTitleImage() {
        return this.getPartReference().getTitleImage();
    }

    public String getTitleToolTip() {
        return this.getPartReference().getTitleToolTip();
    }

    public boolean isDirty() {
        return this.getPartReference().isDirty();
    }

    public boolean isBusy() {
        return this.part.isBusy();
    }

    public Control getToolBar() {
        return this.part.getToolBar();
    }

    public boolean isCloseable() {
        return this.part.isCloseable();
    }

    public Control getControl() {
        return this.part.getControl();
    }
}

