/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.search.BaseFilter;

public class VersionedIdentifiersFilter
extends BaseFilter {
    private ArrayList vids;

    public VersionedIdentifiersFilter() {
        this(new VersionedIdentifier[0]);
    }

    public VersionedIdentifiersFilter(VersionedIdentifier[] versionedIdentifierArray) {
        this.vids = new ArrayList(versionedIdentifierArray.length);
        int n = 0;
        while (n < versionedIdentifierArray.length) {
            this.vids.add(versionedIdentifierArray[n]);
            ++n;
        }
    }

    public void add(VersionedIdentifier versionedIdentifier) {
        this.vids.add(versionedIdentifier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accept(IFeatureReference iFeatureReference) {
        try {
            int n = 0;
            while (true) {
                if (n >= this.vids.size()) {
                    return false;
                }
                VersionedIdentifier versionedIdentifier = (VersionedIdentifier)this.vids.get(n);
                if (versionedIdentifier.equals(iFeatureReference.getVersionedIdentifier())) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

