/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.util.jar.JarEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IContentConsumer;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Messages;

public class DefaultInstallHandler
extends BaseInstallHandler {
    public void nonPluginDataDownloaded(INonPluginEntry[] iNonPluginEntryArray, IVerificationListener iVerificationListener) throws CoreException {
        if (iNonPluginEntryArray == null || iNonPluginEntryArray.length == 0) {
            return;
        }
        this.nonPluginEntries = iNonPluginEntryArray;
        IFeatureContentProvider iFeatureContentProvider = this.feature.getFeatureContentProvider();
        IVerifier iVerifier = iFeatureContentProvider.getVerifier();
        if (iVerifier == null) {
            return;
        }
        int n = 0;
        while (n < this.nonPluginEntries.length) {
            ContentReference[] contentReferenceArray = iFeatureContentProvider.getNonPluginEntryArchiveReferences(this.nonPluginEntries[n], this.monitor);
            int n2 = 0;
            while (n2 < contentReferenceArray.length) {
                IVerificationResult iVerificationResult;
                ContentReference contentReference = contentReferenceArray[n2];
                if (!(contentReferenceArray[n2] instanceof JarContentReference) && contentReferenceArray[n2].getIdentifier().endsWith(".jar")) {
                    try {
                        contentReference = new JarContentReference(contentReferenceArray[n2].getIdentifier(), contentReferenceArray[n2].asFile());
                    }
                    catch (IOException iOException) {}
                }
                if ((iVerificationResult = iVerifier.verify(this.feature, contentReference, false, this.monitor)) != null) {
                    this.promptForVerification(iVerificationResult, iVerificationListener);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void completeInstall(IFeatureContentConsumer iFeatureContentConsumer) throws CoreException {
        if (this.nonPluginEntries == null || this.nonPluginEntries.length == 0) {
            return;
        }
        IFeatureContentProvider iFeatureContentProvider = this.feature.getFeatureContentProvider();
        int n = 0;
        while (n < this.nonPluginEntries.length) {
            ContentReference[] contentReferenceArray = iFeatureContentProvider.getNonPluginEntryArchiveReferences(this.nonPluginEntries[n], this.monitor);
            IContentConsumer iContentConsumer = iFeatureContentConsumer.open(this.nonPluginEntries[n]);
            int n2 = 0;
            while (n2 < contentReferenceArray.length) {
                String string = contentReferenceArray[n2].getIdentifier();
                if (string.endsWith(".jar")) {
                    try {
                        final String string2 = String.valueOf(string.substring(0, string.length() - 4)) + "/";
                        JarContentReference jarContentReference = new JarContentReference("", contentReferenceArray[n2].asFile());
                        JarContentReference.ContentSelector contentSelector = new JarContentReference.ContentSelector(){

                            public String defineIdentifier(JarEntry jarEntry) {
                                if (jarEntry == null) {
                                    return null;
                                }
                                return String.valueOf(string2) + jarEntry.getName();
                            }
                        };
                        ContentReference[] contentReferenceArray2 = jarContentReference.peek(contentSelector, this.monitor);
                        int n3 = 0;
                        while (n3 < contentReferenceArray2.length) {
                            iContentConsumer.store(contentReferenceArray2[n3], this.monitor);
                            ++n3;
                        }
                    }
                    catch (IOException iOException) {
                        throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerificationService_CancelInstall, (Object[])new String[]{string}), iOException);
                    }
                } else {
                    iContentConsumer.store(contentReferenceArray[n2], this.monitor);
                }
                ++n2;
            }
            iContentConsumer.close();
            ++n;
        }
    }

    private void promptForVerification(IVerificationResult iVerificationResult, IVerificationListener iVerificationListener) throws CoreException {
        if (iVerificationListener == null) {
            return;
        }
        int n = iVerificationListener.prompt(iVerificationResult);
        if (n == 0) {
            Exception exception = iVerificationResult.getVerificationException();
            throw new InstallAbortedException(Messages.JarVerificationService_CancelInstall, exception);
        }
        if (n == 1) {
            throw Utilities.newCoreException(Messages.JarVerificationService_UnsucessfulVerification, iVerificationResult.getVerificationException());
        }
    }
}

