/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.dom;

import org.eclipse.ercp.xml.dom.DocumentImpl;
import org.eclipse.ercp.xml.dom.NodeImpl;
import org.w3c.dom.DOMException;

public abstract class NSNodeImpl
extends NodeImpl {
    protected String prefix;
    protected String localName;
    protected String namespaceURI;
    protected String qualifiedName;

    public NSNodeImpl(DocumentImpl ownerDocument) {
        this(ownerDocument, null, null);
    }

    public NSNodeImpl(DocumentImpl ownerDocument, String qualifiedName) {
        this(ownerDocument, null, qualifiedName);
    }

    public NSNodeImpl(DocumentImpl ownerDocument, String namespaceURI, String qualifiedName) {
        super(ownerDocument);
        if (namespaceURI != null) {
            int index = qualifiedName.indexOf(58);
            if (index == -1) {
                this.prefix = null;
                this.localName = qualifiedName;
            } else {
                this.prefix = qualifiedName.substring(0, index);
                this.localName = qualifiedName.substring(index + 1);
            }
        } else {
            this.prefix = null;
            this.localName = null;
        }
        this.namespaceURI = namespaceURI;
        this.qualifiedName = qualifiedName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.namespaceURI == null || "xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(this.namespaceURI) || this.getNodeType() == 2 && "xmlns".equals(prefix) && "http://www.w3.org/2000/xmlns/".equals(this.namespaceURI) || this.getNodeType() == 2 && "xmlns".equals(this.qualifiedName)) {
            throw new DOMException(14, prefix);
        }
        this.prefix = prefix;
    }

    public String getNodeName() {
        return this.qualifiedName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }
}

