/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

abstract class TableEditorImpl {
    private CellEditor cellEditor;
    private CellEditor[] cellEditors;
    private ICellModifier cellModifier;
    private String[] columnProperties;
    private Item tableItem;
    private int columnNumber;
    private ICellEditorListener cellEditorListener;
    private FocusListener focusListener;
    private MouseListener mouseListener;
    private int doubleClickExpirationTime;
    private StructuredViewer viewer;

    TableEditorImpl(StructuredViewer structuredViewer) {
        this.viewer = structuredViewer;
        this.initCellEditorListener();
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    private void activateCellEditor() {
        String string;
        Object object;
        if (this.cellEditors != null && this.cellEditors[this.columnNumber] != null && this.cellModifier != null && this.cellModifier.canModify(object = this.tableItem.getData(), string = this.columnProperties[this.columnNumber])) {
            this.cellEditor = this.cellEditors[this.columnNumber];
            this.cellEditor.addListener(this.cellEditorListener);
            Object object2 = this.cellModifier.getValue(object, string);
            this.cellEditor.setValue(object2);
            final Control control = this.cellEditor.getControl();
            this.cellEditor.activate();
            if (control == null) {
                return;
            }
            this.setLayoutData(this.cellEditor.getLayoutData());
            this.setEditor(control, this.tableItem, this.columnNumber);
            this.cellEditor.setFocus();
            if (this.focusListener == null) {
                this.focusListener = new FocusListener(){

                    public void focusLost(FocusEvent focusEvent) {
                        TableEditorImpl.this.applyEditorValue();
                    }

                    public void focusGained(FocusEvent focusEvent) {
                    }
                };
            }
            control.addFocusListener(this.focusListener);
            this.mouseListener = new MouseListener(){

                public void mouseDown(MouseEvent mouseEvent) {
                    if (mouseEvent.time <= TableEditorImpl.this.doubleClickExpirationTime) {
                        control.removeMouseListener(TableEditorImpl.this.mouseListener);
                        TableEditorImpl.this.cancelEditing();
                        TableEditorImpl.this.handleDoubleClickEvent();
                    } else if (TableEditorImpl.this.mouseListener != null) {
                        control.removeMouseListener(TableEditorImpl.this.mouseListener);
                    }
                }

                public void mouseDoubleClick(MouseEvent mouseEvent) {
                }

                public void mouseUp(MouseEvent mouseEvent) {
                }
            };
            control.addMouseListener(this.mouseListener);
        }
    }

    private void activateCellEditor(MouseEvent mouseEvent) {
        int n;
        if (this.tableItem == null || this.tableItem.isDisposed()) {
            return;
        }
        int n2 = this.getColumnCount();
        if (n2 == 0) {
            n = 0;
        } else {
            n = -1;
            int n3 = 0;
            while (n3 < n2) {
                Rectangle rectangle = this.getBounds(this.tableItem, n3);
                if (rectangle.contains(mouseEvent.x, mouseEvent.y)) {
                    n = n3;
                    break;
                }
                ++n3;
            }
            if (n == -1) {
                return;
            }
        }
        this.columnNumber = n;
        this.activateCellEditor();
    }

    public void applyEditorValue() {
        CellEditor cellEditor = this.cellEditor;
        if (cellEditor != null) {
            this.cellEditor = null;
            Item item = this.tableItem;
            if (item != null && !item.isDisposed()) {
                this.saveEditorValue(cellEditor, item);
            }
            this.setEditor(null, null, 0);
            cellEditor.removeListener(this.cellEditorListener);
            Control control = cellEditor.getControl();
            if (control != null) {
                if (this.mouseListener != null) {
                    control.removeMouseListener(this.mouseListener);
                }
                if (this.focusListener != null) {
                    control.removeFocusListener(this.focusListener);
                }
            }
            cellEditor.deactivate();
        }
    }

    public void cancelEditing() {
        if (this.cellEditor != null) {
            this.setEditor(null, null, 0);
            this.cellEditor.removeListener(this.cellEditorListener);
            CellEditor cellEditor = this.cellEditor;
            this.cellEditor = null;
            cellEditor.deactivate();
        }
    }

    public void editElement(Object object, int n) {
        if (this.cellEditor != null) {
            this.applyEditorValue();
        }
        this.setSelection(new StructuredSelection(object), true);
        Item[] itemArray = this.getSelection();
        if (itemArray.length != 1) {
            return;
        }
        this.tableItem = itemArray[0];
        this.showSelection();
        this.columnNumber = n;
        this.activateCellEditor();
    }

    abstract Rectangle getBounds(Item var1, int var2);

    public CellEditor[] getCellEditors() {
        return this.cellEditors;
    }

    public ICellModifier getCellModifier() {
        return this.cellModifier;
    }

    abstract int getColumnCount();

    public Object[] getColumnProperties() {
        return this.columnProperties;
    }

    abstract Item[] getSelection();

    public void handleMouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            return;
        }
        if (this.cellEditor != null) {
            this.applyEditorValue();
        }
        this.doubleClickExpirationTime = mouseEvent.time + Display.getCurrent().getDoubleClickTime();
        Item[] itemArray = this.getSelection();
        if (itemArray.length != 1) {
            this.tableItem = null;
            return;
        }
        this.tableItem = itemArray[0];
        this.activateCellEditor(mouseEvent);
    }

    private void initCellEditorListener() {
        this.cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean bl, boolean bl2) {
            }

            public void cancelEditor() {
                TableEditorImpl.this.cancelEditing();
            }

            public void applyEditorValue() {
                TableEditorImpl.this.applyEditorValue();
            }
        };
    }

    public boolean isCellEditorActive() {
        return this.cellEditor != null;
    }

    private void saveEditorValue(CellEditor cellEditor, Item item) {
        if (this.cellModifier != null) {
            cellEditor.isValueValid();
            String string = null;
            if (this.columnProperties != null && this.columnNumber < this.columnProperties.length) {
                string = this.columnProperties[this.columnNumber];
            }
            this.cellModifier.modify(item, string, cellEditor.getValue());
        }
    }

    public void setCellEditors(CellEditor[] cellEditorArray) {
        this.cellEditors = cellEditorArray;
    }

    public void setCellModifier(ICellModifier iCellModifier) {
        this.cellModifier = iCellModifier;
    }

    public void setColumnProperties(String[] stringArray) {
        this.columnProperties = stringArray;
    }

    abstract void setEditor(Control var1, Item var2, int var3);

    abstract void setLayoutData(CellEditor.LayoutData var1);

    abstract void setSelection(StructuredSelection var1, boolean var2);

    abstract void showSelection();

    abstract void handleDoubleClickEvent();
}

