/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.ILocalSiteChangedListener;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.ListenersList;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteStatusAnalyzer;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.InstallConfigurationModel;
import org.eclipse.update.internal.model.SiteLocalModel;
import org.eclipse.update.internal.model.SiteLocalParser;

public class LocalSite
extends SiteLocalModel
implements ILocalSite {
    private ListenersList listeners = new ListenersList();
    private SiteStatusAnalyzer siteStatusAnalyzer;
    private boolean isTransient = false;
    public static boolean newFeaturesFound = false;

    public static ILocalSite getLocalSite() throws CoreException {
        return LocalSite.internalGetLocalSite();
    }

    public static ILocalSite internalGetLocalSite() throws CoreException {
        LocalSite localSite = new LocalSite();
        IPlatformConfiguration iPlatformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        localSite.isTransient(iPlatformConfiguration.isTransient());
        try {
            URL uRL = iPlatformConfiguration.getConfigurationLocation();
            localSite.setLocationURLString(uRL.toExternalForm());
            localSite.resolve(uRL, null);
            LocalSite.parseLocalSiteFile(iPlatformConfiguration, localSite);
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteLocal_UnableToCreateURLFor, (Object[])new String[]{String.valueOf(localSite.getLocationURLString()) + " & " + "platform.xml"}), malformedURLException);
        }
        return localSite;
    }

    private static boolean parseLocalSiteFile(IPlatformConfiguration iPlatformConfiguration, LocalSite localSite) throws CoreException, MalformedURLException {
        try {
            new SiteLocalParser(iPlatformConfiguration, localSite);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected LocalSite() {
    }

    public void addConfiguration(IInstallConfiguration iInstallConfiguration) {
        if (iInstallConfiguration != null) {
            this.addConfigurationModel((InstallConfigurationModel)((Object)iInstallConfiguration));
            this.trimHistoryToCapacity();
            if (this.getCurrentConfigurationModel() != null) {
                this.getCurrentConfigurationModel().setCurrent(false);
            }
            if (iInstallConfiguration instanceof InstallConfiguration) {
                ((InstallConfiguration)iInstallConfiguration).setCurrent(true);
            }
            this.setCurrentConfigurationModel((InstallConfigurationModel)((Object)iInstallConfiguration));
            ((InstallConfigurationModel)((Object)iInstallConfiguration)).markReadOnly();
            Object[] objectArray = this.listeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((ILocalSiteChangedListener)objectArray[n]).currentInstallConfigurationChanged(iInstallConfiguration);
                ++n;
            }
        }
    }

    private void trimHistoryToCapacity() {
        while (this.getConfigurationHistory().length > this.getMaximumHistoryCount() && this.getConfigurationHistory().length > 1) {
            InstallConfigurationModel installConfigurationModel = this.getConfigurationHistoryModel()[1];
            if (!this.removeConfigurationModel(installConfigurationModel)) continue;
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Removed configuration :" + installConfigurationModel.getLabel());
            }
            Object[] objectArray = this.listeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((ILocalSiteChangedListener)objectArray[n]).installConfigurationRemoved((IInstallConfiguration)((Object)installConfigurationModel));
                ++n;
            }
            URL uRL = installConfigurationModel.getURL();
            UpdateManagerUtils.removeFromFileSystem(new File(uRL.getFile()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalSiteChangedListener(ILocalSiteChangedListener iLocalSiteChangedListener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(iLocalSiteChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalSiteChangedListener(ILocalSiteChangedListener iLocalSiteChangedListener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(iLocalSiteChangedListener);
        }
    }

    public boolean save() throws CoreException {
        return ((InstallConfiguration)this.getCurrentConfiguration()).save();
    }

    public IInstallConfiguration cloneCurrentConfiguration() throws CoreException {
        try {
            return new InstallConfiguration(this.getCurrentConfiguration());
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException(Messages.SiteLocal_cloneConfig, malformedURLException);
        }
    }

    /*
     * Exception decompiling
     */
    public void revertTo(IInstallConfiguration var1_1, IProgressMonitor var2_2, IProblemHandler var3_3) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 124->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IInstallConfiguration addToPreservedConfigurations(IInstallConfiguration iInstallConfiguration) throws CoreException {
        return null;
    }

    public IInstallConfiguration findPreservedConfigurationFor(IInstallConfiguration iInstallConfiguration) {
        InstallConfigurationModel[] installConfigurationModelArray;
        InstallConfigurationModel installConfigurationModel = null;
        if (iInstallConfiguration != null && (installConfigurationModelArray = this.getPreservedConfigurationsModel()) != null) {
            int n = 0;
            while (n < installConfigurationModelArray.length) {
                if (iInstallConfiguration.getCreationDate().equals(installConfigurationModelArray[n].getCreationDate())) {
                    installConfigurationModel = installConfigurationModelArray[n];
                    break;
                }
                ++n;
            }
        }
        return (IInstallConfiguration)((Object)installConfigurationModel);
    }

    public IInstallConfiguration getCurrentConfiguration() {
        if (this.getCurrentConfigurationModel() == null) {
            int n = 0;
            n = this.getConfigurationHistoryModel().length;
            if (n == 0) {
                return null;
            }
            InstallConfigurationModel installConfigurationModel = this.getConfigurationHistoryModel()[n - 1];
            installConfigurationModel.setCurrent(true);
            this.setCurrentConfigurationModel(installConfigurationModel);
        }
        return (IInstallConfiguration)((Object)this.getCurrentConfigurationModel());
    }

    public IInstallConfiguration[] getPreservedConfigurations() {
        if (this.getPreservedConfigurationsModel().length == 0) {
            return new IInstallConfiguration[0];
        }
        return (IInstallConfiguration[])this.getPreservedConfigurationsModel();
    }

    public void removeFromPreservedConfigurations(IInstallConfiguration iInstallConfiguration) {
        if (this.removePreservedConfigurationModel((InstallConfigurationModel)((Object)iInstallConfiguration))) {
            ((InstallConfiguration)iInstallConfiguration).remove();
        }
    }

    public IInstallConfiguration[] getConfigurationHistory() {
        if (this.getConfigurationHistoryModel().length == 0) {
            return new IInstallConfiguration[0];
        }
        return (IInstallConfiguration[])this.getConfigurationHistoryModel();
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    private void isTransient(boolean bl) {
        this.isTransient = bl;
    }

    private SiteStatusAnalyzer getSiteStatusAnalyzer() {
        if (this.siteStatusAnalyzer == null) {
            this.siteStatusAnalyzer = new SiteStatusAnalyzer(this);
        }
        return this.siteStatusAnalyzer;
    }

    public IStatus getFeatureStatus(IFeature iFeature) throws CoreException {
        return this.getSiteStatusAnalyzer().getFeatureStatus(iFeature);
    }

    public void setMaximumHistoryCount(int n) {
        super.setMaximumHistoryCount(n);
        this.trimHistoryToCapacity();
    }
}

