/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.search.IUpdateSiteAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdatePolicy {
    private static final String TAG_POLICY = "update-policy";
    private static final String TAG_URL_MAP = "url-map";
    private static final String ATT_URL = "url";
    private static final String ATT_PATTERN = "pattern";
    private static final String ATT_TYPE = "url-type";
    private static final String ATT_TYPE_VALUE_UPDATE = "update";
    private static final String ATT_TYPE_VALUE_DISCOVERY = "discovery";
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private ArrayList entries = new ArrayList();
    private ArrayList discoveryEntries = new ArrayList();
    private IUpdateSiteAdapter defaultSite;
    private IUpdateSiteAdapter defaultDiscoverySite;
    private boolean loaded = false;
    private boolean fallbackAllowed = true;

    /*
     * Exception decompiling
     */
    public void load(URL var1_1, IProgressMonitor var2_2) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [8 : 159->163)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public IUpdateSiteAdapter getMappedSite(String string) {
        UpdateMapEntry updateMapEntry = null;
        int n = 0;
        while (n < this.entries.size()) {
            UpdateMapEntry updateMapEntry2 = (UpdateMapEntry)this.entries.get(n);
            if (updateMapEntry2.matches(string)) {
                if (updateMapEntry == null) {
                    updateMapEntry = updateMapEntry2;
                } else {
                    String string2 = updateMapEntry2.getPattern();
                    String string3 = updateMapEntry.getPattern();
                    if (string2.length() > string3.length()) {
                        updateMapEntry = updateMapEntry2;
                    }
                }
            }
            ++n;
        }
        if (updateMapEntry != null) {
            return updateMapEntry.getSite();
        }
        return this.defaultSite;
    }

    public IUpdateSiteAdapter getMappedDiscoverySite(String string) {
        UpdateMapEntry updateMapEntry = null;
        int n = 0;
        while (n < this.discoveryEntries.size()) {
            UpdateMapEntry updateMapEntry2 = (UpdateMapEntry)this.discoveryEntries.get(n);
            if (updateMapEntry2.matches(string)) {
                if (updateMapEntry == null) {
                    updateMapEntry = updateMapEntry2;
                } else {
                    String string2 = updateMapEntry2.getPattern();
                    String string3 = updateMapEntry.getPattern();
                    if (string2.length() > string3.length()) {
                        updateMapEntry = updateMapEntry2;
                    }
                }
            }
            ++n;
        }
        if (updateMapEntry != null) {
            return updateMapEntry.getSite();
        }
        return this.defaultDiscoverySite;
    }

    public boolean isFallbackAllowed() {
        return this.fallbackAllowed;
    }

    private void reset() {
        if (!this.entries.isEmpty()) {
            this.entries.clear();
        }
        if (!this.discoveryEntries.isEmpty()) {
            this.discoveryEntries.clear();
        }
    }

    private void processUpdatePolicy(Document document) throws CoreException {
        Element element = document.getDocumentElement();
        this.reset();
        if (!element.getNodeName().equals(TAG_POLICY)) {
            this.throwCoreException(NLS.bind((String)Messages.UpdatePolicy_policyExpected, (Object[])new String[]{TAG_POLICY}), null);
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && (string = node.getNodeName()).equals(TAG_URL_MAP)) {
                this.processMapNode(node);
            }
            ++n;
        }
    }

    private void processMapNode(Node node) throws CoreException {
        String string = this.getAttribute(node, ATT_PATTERN);
        String string2 = this.getAttribute(node, ATT_URL);
        String string3 = this.getAttribute(node, ATT_TYPE);
        this.assertNotNull(ATT_PATTERN, string);
        this.assertNotNull(ATT_URL, string2);
        if (string2.trim().length() == 0) {
            this.addUpdateEntry(string, null, string3);
            return;
        }
        try {
            String string4 = UpdateURLDecoder.decode((String)string2, (String)"UTF-8");
            URL uRL = new URL(string4);
            this.addUpdateEntry(string, uRL, string3);
        }
        catch (MalformedURLException malformedURLException) {
            this.throwCoreException(NLS.bind((String)Messages.UpdatePolicy_invalidURL, (Object[])new String[]{string2}), null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private void assertNotNull(String string, String string2) throws CoreException {
        if (string2 == null) {
            this.throwCoreException(NLS.bind((String)Messages.UpdatePolicy_nameNoNull, (Object[])new String[]{string}), null);
        }
    }

    private String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    private void addUpdateEntry(String string, URL uRL, String string2) {
        if (string.equalsIgnoreCase("*")) {
            if (string2 == null) {
                this.defaultSite = new MapSite(uRL);
            } else if (string2.equals(ATT_TYPE_VALUE_UPDATE)) {
                this.defaultSite = new MapSite(uRL);
            } else if (string2.equals(ATT_TYPE_VALUE_DISCOVERY)) {
                this.defaultDiscoverySite = new MapSite(uRL);
            } else {
                this.defaultSite = new MapSite(uRL);
                this.defaultDiscoverySite = new MapSite(uRL);
            }
        } else if (string2 == null) {
            this.entries.add(new UpdateMapEntry(string, uRL));
        } else if (string2.equals(ATT_TYPE_VALUE_UPDATE)) {
            this.entries.add(new UpdateMapEntry(string, uRL));
        } else if (string2.equals(ATT_TYPE_VALUE_DISCOVERY)) {
            this.discoveryEntries.add(new UpdateMapEntry(string, uRL));
        } else {
            this.entries.add(new UpdateMapEntry(string, uRL));
            this.discoveryEntries.add(new UpdateMapEntry(string, uRL));
        }
    }

    private void throwCoreException(String string, Throwable throwable) throws CoreException {
        String string2 = String.valueOf(Messages.UpdatePolicy_UpdatePolicy) + string;
        throw Utilities.newCoreException(string2, 0, throwable);
    }

    private static class MapSite
    implements IUpdateSiteAdapter {
        private URL url;

        public MapSite(URL uRL) {
            this.url = uRL;
        }

        public String getLabel() {
            return this.url.toString();
        }

        public URL getURL() {
            return this.url;
        }
    }

    private static class UpdateMapEntry {
        private IUpdateSiteAdapter site;
        private String pattern;

        public UpdateMapEntry(String string, URL uRL) {
            this.pattern = string;
            this.site = new MapSite(uRL);
        }

        public IUpdateSiteAdapter getSite() {
            return this.site;
        }

        public boolean matches(String string) {
            return string.startsWith(this.pattern);
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

