/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import com.ibm.ugl.p3ml.OS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Browser
extends Composite {
    private List locationListeners;
    private List progressListeners;
    private List statusListeners;
    private List titleListeners;
    private static boolean eventsRegistered;
    private Listener disposeListener;

    public Browser(Composite parent, int style) {
        super(parent, style);
        if (!eventsRegistered) {
            OS.Display_RegisterCallback(this.getDisplay().internal_handle, 1748788638, "org/eclipse/swt/browser/Browser", "titleChanged");
            OS.Display_RegisterCallback(this.getDisplay().internal_handle, 1617659889, "org/eclipse/swt/browser/Browser", "statusTextChanged");
            OS.Display_RegisterCallback(this.getDisplay().internal_handle, 2129896520, "org/eclipse/swt/browser/Browser", "progressCallback");
            OS.Display_RegisterCallback(this.getDisplay().internal_handle, 874900120, "org/eclipse/swt/browser/Browser", "locationChanging");
            OS.Display_RegisterCallback(this.getDisplay().internal_handle, 1275148711, "org/eclipse/swt/browser/Browser", "locationChanged");
            eventsRegistered = true;
        }
        final Browser browserTemp = this;
        this.disposeListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == browserTemp) {
                    Browser.this.internal_sendEvent(16);
                }
            }
        };
        this.getDisplay().addFilter(12, this.disposeListener);
    }

    protected void internal_createHandle(int index) {
        this.internal_handle = com.ibm.ugl.eswt.expanded.OS.Browser_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
        if (this.internal_handle == 0) {
            SWT.error(2);
        }
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.locationListeners == null) {
            this.locationListeners = new ArrayList();
        }
        this.locationListeners.add(listener);
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList();
        }
        this.progressListeners.add(listener);
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.statusListeners == null) {
            this.statusListeners = new ArrayList();
        }
        this.statusListeners.add(listener);
    }

    public void addTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.titleListeners == null) {
            this.titleListeners = new ArrayList();
        }
        this.titleListeners.add(listener);
    }

    private boolean locationChanging(String location) {
        if (this.locationListeners == null) {
            return true;
        }
        LocationEvent event = new LocationEvent(this);
        event.doit = true;
        event.location = location;
        event.widget = this;
        event.display = this.getDisplay();
        event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
        int listenerCount = this.locationListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            LocationListener listener = (LocationListener)this.locationListeners.get(i);
            listener.changing(event);
        }
        return event.doit;
    }

    private void locationChanged(String location, boolean isTop) {
        if (this.locationListeners != null) {
            LocationEvent event = new LocationEvent(this);
            event.location = location;
            event.top = isTop;
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
            int listenerCount = this.locationListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                LocationListener listener = (LocationListener)this.locationListeners.get(i);
                listener.changed(event);
            }
        }
    }

    private void titleChanged(String title) {
        if (this.titleListeners != null) {
            TitleEvent event = new TitleEvent(this);
            event.title = title;
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
            int listenerCount = this.titleListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                TitleListener listener = (TitleListener)this.titleListeners.get(i);
                listener.changed(event);
            }
        }
    }

    private void statusTextChanged(String statusText) {
        if (this.statusListeners != null) {
            StatusTextEvent event = new StatusTextEvent(this);
            event.text = statusText;
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
            int listenerCount = this.statusListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                StatusTextListener listener = (StatusTextListener)this.statusListeners.get(i);
                listener.changed(event);
            }
        }
    }

    private void progressCallback(int value, int max) {
        if (this.progressListeners != null) {
            ProgressEvent event = new ProgressEvent(this);
            if (value != max) {
                event.current = value;
                event.total = max;
            }
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
            int listenerCount = this.progressListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                ProgressListener listener = (ProgressListener)this.progressListeners.get(i);
                if (value != max) {
                    listener.changed(event);
                    continue;
                }
                listener.completed(event);
            }
        }
    }

    public boolean back() {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Browser_Back(this.internal_handle);
    }

    public boolean execute(String script) {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Browser_Execute(this.internal_handle, script);
    }

    public boolean forward() {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Browser_Forward(this.internal_handle);
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Browser_IsBackEnabled(this.internal_handle);
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Browser_IsForwardEnabled(this.internal_handle);
    }

    public String getUrl() {
        this.checkWidget();
        String result = com.ibm.ugl.eswt.expanded.OS.Browser_GetURL(this.internal_handle);
        return result == null ? "" : result;
    }

    public void refresh() {
        this.checkWidget();
        com.ibm.ugl.eswt.expanded.OS.Browser_Refresh(this.internal_handle);
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.locationListeners != null) {
            this.locationListeners.remove(listener);
        }
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.progressListeners != null) {
            this.progressListeners.remove(listener);
        }
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.statusListeners != null) {
            this.statusListeners.remove(listener);
        }
    }

    public void removeTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.titleListeners != null) {
            this.titleListeners.remove(listener);
        }
    }

    public boolean setText(String html) {
        int idx3;
        String comp;
        int idx;
        this.checkWidget();
        if (html == null) {
            SWT.error(4);
        }
        if ((idx = (comp = html.toLowerCase()).indexOf("<html>")) == -1) {
            return false;
        }
        int idx2 = comp.indexOf("<", (idx = comp.indexOf("<body", idx + 6)) + 5);
        if (idx2 < (idx3 = comp.indexOf(">", idx + 5))) {
            return false;
        }
        if (idx == -1) {
            return false;
        }
        idx = idx3;
        if ((idx = comp.indexOf("</body>", idx + 1)) == -1) {
            return false;
        }
        if ((idx = comp.indexOf("</html>", idx + 7)) == -1) {
            return false;
        }
        comp = null;
        return com.ibm.ugl.eswt.expanded.OS.Browser_SetText(this.internal_handle, html);
    }

    public boolean setUrl(String url) {
        this.checkWidget();
        if (url == null) {
            SWT.error(4);
        }
        return com.ibm.ugl.eswt.expanded.OS.Browser_SetURL(this.internal_handle, url);
    }

    public void stop() {
        this.checkWidget();
        com.ibm.ugl.eswt.expanded.OS.Browser_Stop(this.internal_handle);
    }

    protected void removeInternalFilter() {
        this.getDisplay().removeFilter(12, this.disposeListener);
    }
}

