/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import com.ibm.ugl.eswt.expanded.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    private boolean disposed;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$Clipboard;

    public Clipboard(Display display) {
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        this.display = display;
        if (!Thread.currentThread().equals(display.getThread())) {
            SWT.error(22);
        }
        this.checkSubclass();
        this.disposed = false;
    }

    protected void checkSubclass() {
        if (!this.getClass().equals(class$org$eclipse$swt$dnd$Clipboard == null ? (class$org$eclipse$swt$dnd$Clipboard = Clipboard.class$("org.eclipse.swt.dnd.Clipboard")) : class$org$eclipse$swt$dnd$Clipboard)) {
            SWT.error(43);
        }
    }

    protected void checkWidget() {
        if (this.disposed) {
            SWT.error(24);
        }
        if (!Thread.currentThread().equals(this.display.getThread())) {
            SWT.error(22);
        }
    }

    public void dispose() {
        this.checkWidget();
        this.disposed = true;
    }

    public Object getContents(Transfer transfer) {
        this.checkWidget();
        if (transfer == null) {
            throw new IllegalArgumentException("transfer should not be null");
        }
        TransferData[] datas = transfer.getSupportedTypes();
        for (int i = 0; i < datas.length; ++i) {
            if (!transfer.getNativeData(datas[i])) continue;
            return transfer.nativeToJava(datas[i]);
        }
        return null;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.checkWidget();
        if (data == null) {
            throw new IllegalArgumentException("Null data parameter");
        }
        if (dataTypes == null) {
            throw new IllegalArgumentException("Null dataTypes parameter");
        }
        if (data.length != dataTypes.length) {
            throw new IllegalArgumentException("parameter lengths don't match");
        }
        OS.Clipboard_Clear();
        for (int i = 0; i < dataTypes.length; ++i) {
            TransferData[] tData = dataTypes[i].getSupportedTypes();
            for (int a = 0; a < tData.length; ++a) {
                tData[a].result = 0;
                dataTypes[i].javaToNative(data[i], tData[a]);
                if (tData[a].result == 0) continue;
                dataTypes[i].setNativeData(tData[a]);
                if (!(dataTypes[i] instanceof ByteArrayTransfer) || dataTypes[i] instanceof TextTransfer) continue;
                ((ByteArrayTransfer)dataTypes[i]).size = ((byte[])data[i]).length;
            }
        }
    }

    public TransferData[] getAvailableTypes() {
        this.checkWidget();
        int[] available = OS.Clipboard_GetAvailableIds();
        TransferData[] datas = new TransferData[available.length];
        for (int i = 0; i < available.length; ++i) {
            datas[i] = new TransferData();
            datas[i].type = available[i];
        }
        return datas;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        TransferData[] datas = this.getAvailableTypes();
        String[] names = new String[datas.length];
        for (int i = 0; i < datas.length; ++i) {
            names[i] = OS.Clipboard_GetTypeName(datas[i].type);
        }
        return names;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

