/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.search;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteWithMirrors;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.internal.search.UpdatePolicy;
import org.eclipse.update.internal.search.UpdateSiteAdapter;
import org.eclipse.update.internal.search.UpdatesSearchCategory;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchCategory;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.IUpdateSearchResultCollectorFromMirror;
import org.eclipse.update.search.IUpdateSearchSite;
import org.eclipse.update.search.IUpdateSiteAdapter;
import org.eclipse.update.search.UpdateSearchScope;

public class UpdateSearchRequest {
    private IUpdateSearchCategory category;
    private UpdateSearchScope scope;
    private boolean searchInProgress = false;
    private AggregateFilter aggregateFilter = new AggregateFilter();

    public static IUpdateSearchCategory createDefaultUpdatesSearchCategory() {
        return new UpdatesSearchCategory();
    }

    public static IUpdateSearchCategory createDefaultSiteSearchCategory() {
        return new SiteSearchCategory();
    }

    public UpdateSearchRequest(IUpdateSearchCategory iUpdateSearchCategory, UpdateSearchScope updateSearchScope) {
        this.category = iUpdateSearchCategory;
        this.scope = updateSearchScope;
    }

    public IUpdateSearchCategory getCategory() {
        return this.category;
    }

    public UpdateSearchScope getScope() {
        return this.scope;
    }

    public void addFilter(IUpdateSearchFilter iUpdateSearchFilter) {
        if (this.searchInProgress) {
            return;
        }
        this.aggregateFilter.addFilter(iUpdateSearchFilter);
    }

    public void removeFilter(IUpdateSearchFilter iUpdateSearchFilter) {
        if (this.searchInProgress) {
            return;
        }
        this.aggregateFilter.removeFilter(iUpdateSearchFilter);
    }

    public void setScope(UpdateSearchScope updateSearchScope) {
        this.scope = updateSearchScope;
    }

    public boolean isSearchInProgress() {
        return this.searchInProgress;
    }

    public void performSearch(IUpdateSearchResultCollector iUpdateSearchResultCollector, IProgressMonitor iProgressMonitor) throws CoreException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.searchInProgress = true;
        IUpdateSearchQuery[] iUpdateSearchQueryArray = this.category.getQueries();
        IUpdateSearchSite[] iUpdateSearchSiteArray = this.scope.getSearchSites();
        URL uRL = this.scope.getUpdateMapURL();
        boolean bl = this.scope.isFeatureProvidedSitesEnabled();
        if (!iProgressMonitor.isCanceled()) {
            int n = 0;
            int n2 = 0;
            while (n2 < iUpdateSearchQueryArray.length) {
                if (iUpdateSearchQueryArray[n2].getQuerySearchSite() != null) {
                    ++n;
                }
                ++n2;
            }
            n2 = n + iUpdateSearchQueryArray.length * iUpdateSearchSiteArray.length;
            if (uRL != null) {
                ++n2;
            }
            iProgressMonitor.beginTask(Messages.UpdateSearchRequest_searching, n2);
            try {
                IStatus iStatus;
                UpdatePolicy updatePolicy = null;
                if (uRL != null && (iStatus = UpdateUtils.loadUpdatePolicy(updatePolicy = new UpdatePolicy(), uRL, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1))) != null) {
                    arrayList.add(iStatus);
                }
                int n3 = 0;
                while (n3 < iUpdateSearchQueryArray.length) {
                    SubProgressMonitor subProgressMonitor;
                    IUpdateSearchSite iUpdateSearchSite;
                    IUpdateSearchQuery iUpdateSearchQuery = iUpdateSearchQueryArray[n3];
                    IQueryUpdateSiteAdapter iQueryUpdateSiteAdapter = iUpdateSearchQuery.getQuerySearchSite();
                    if (iQueryUpdateSiteAdapter != null && bl) {
                        IUpdateSiteAdapter iUpdateSiteAdapter = this.getMappedSite(updatePolicy, iQueryUpdateSiteAdapter);
                        if (iUpdateSiteAdapter != null && iUpdateSiteAdapter.getURL() != null) {
                            iUpdateSearchSite = new SubProgressMonitor(iProgressMonitor, 1);
                            subProgressMonitor = this.searchOneSite(iUpdateSiteAdapter, null, iUpdateSearchQuery, iUpdateSearchResultCollector, (SubProgressMonitor)iUpdateSearchSite, true);
                            if (subProgressMonitor != null) {
                                arrayList.add(subProgressMonitor);
                            }
                            if (iProgressMonitor.isCanceled()) break;
                        }
                    } else {
                        int n4 = 0;
                        while (n4 < iUpdateSearchSiteArray.length) {
                            if (iProgressMonitor.isCanceled()) break;
                            iUpdateSearchSite = iUpdateSearchSiteArray[n4];
                            subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                            IStatus iStatus2 = this.searchOneSite(iUpdateSearchSite, iUpdateSearchSite.getCategoriesToSkip(), iUpdateSearchQuery, iUpdateSearchResultCollector, subProgressMonitor, true);
                            if (iStatus2 != null) {
                                arrayList.add(iStatus2);
                            }
                            ++n4;
                        }
                        if (iProgressMonitor.isCanceled()) break;
                    }
                    ++n3;
                }
            }
            catch (CoreException coreException) {
                this.searchInProgress = false;
                iProgressMonitor.done();
                throw coreException;
            }
        }
        this.searchInProgress = false;
        iProgressMonitor.done();
        if (arrayList.size() > 0) {
            IStatus[] iStatusArray = arrayList.toArray(new IStatus[arrayList.size()]);
            MultiStatus multiStatus = new MultiStatus("org.eclipse.update.core", 42, iStatusArray, Messages.Search_networkProblems, null);
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private IUpdateSiteAdapter getMappedSite(UpdatePolicy updatePolicy, IQueryUpdateSiteAdapter iQueryUpdateSiteAdapter) {
        if (updatePolicy != null && updatePolicy.isLoaded()) {
            IUpdateSiteAdapter iUpdateSiteAdapter = updatePolicy.getMappedSite(iQueryUpdateSiteAdapter.getMappingId());
            if (iUpdateSiteAdapter != null) {
                return iUpdateSiteAdapter;
            }
            return updatePolicy.isFallbackAllowed() ? iQueryUpdateSiteAdapter : null;
        }
        return iQueryUpdateSiteAdapter;
    }

    private IStatus searchOneSite(IUpdateSiteAdapter iUpdateSiteAdapter, String[] stringArray, IUpdateSearchQuery iUpdateSearchQuery, IUpdateSearchResultCollector iUpdateSearchResultCollector, SubProgressMonitor subProgressMonitor, boolean bl) throws CoreException {
        IURLEntry iURLEntry;
        ISite iSite;
        String string;
        block5: {
            string = NLS.bind((String)Messages.UpdateSearchRequest_contacting, (Object)iUpdateSiteAdapter.getLabel());
            subProgressMonitor.subTask(string);
            subProgressMonitor.beginTask("", 10);
            URL uRL = iUpdateSiteAdapter.getURL();
            try {
                iSite = SiteManager.getSite(uRL, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                if (iSite != null) break block5;
                subProgressMonitor.worked(9);
                return null;
            }
            catch (CoreException coreException) {
                IStatus iStatus = coreException.getStatus();
                if (iStatus == null) {
                    throw coreException;
                }
                subProgressMonitor.worked(10);
                return iStatus;
            }
        }
        if (iUpdateSearchResultCollector instanceof IUpdateSearchResultCollectorFromMirror && iSite instanceof ISiteWithMirrors && !(iUpdateSiteAdapter instanceof MirroredUpdateSiteAdapter) && (iURLEntry = ((IUpdateSearchResultCollectorFromMirror)iUpdateSearchResultCollector).getMirror((ISiteWithMirrors)iSite, iUpdateSiteAdapter.getLabel())) != null) {
            return this.searchOneSite(new MirroredUpdateSiteAdapter(iURLEntry), stringArray, iUpdateSearchQuery, iUpdateSearchResultCollector, new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1), false);
        }
        string = NLS.bind((String)Messages.UpdateSearchRequest_checking, (Object)iUpdateSiteAdapter.getLabel());
        subProgressMonitor.getWrappedProgressMonitor().subTask(string);
        iUpdateSearchQuery.run(iSite, stringArray, this.aggregateFilter, iUpdateSearchResultCollector, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 9));
        return null;
    }

    class MirroredUpdateSiteAdapter
    extends UpdateSiteAdapter {
        public MirroredUpdateSiteAdapter(IURLEntry iURLEntry) {
            super(iURLEntry.getAnnotation(), iURLEntry.getURL());
        }
    }

    class AggregateFilter
    implements IUpdateSearchFilter {
        private ArrayList filters;

        AggregateFilter() {
        }

        public void addFilter(IUpdateSearchFilter iUpdateSearchFilter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            if (!this.filters.contains(iUpdateSearchFilter)) {
                this.filters.add(iUpdateSearchFilter);
            }
        }

        public void removeFilter(IUpdateSearchFilter iUpdateSearchFilter) {
            if (this.filters == null) {
                return;
            }
            this.filters.remove(iUpdateSearchFilter);
        }

        public boolean accept(IFeature iFeature) {
            if (this.filters == null) {
                return true;
            }
            int n = 0;
            while (n < this.filters.size()) {
                IUpdateSearchFilter iUpdateSearchFilter = (IUpdateSearchFilter)this.filters.get(n);
                if (!iUpdateSearchFilter.accept(iFeature)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public boolean accept(IFeatureReference iFeatureReference) {
            if (this.filters == null) {
                return true;
            }
            int n = 0;
            while (n < this.filters.size()) {
                IUpdateSearchFilter iUpdateSearchFilter = (IUpdateSearchFilter)this.filters.get(n);
                if (!iUpdateSearchFilter.accept(iFeatureReference)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

