/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;

public class DefinitionRegistry
implements IRegistryChangeListener {
    private Map cache = null;

    private Map getCache() {
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        return this.cache;
    }

    public DefinitionRegistry() {
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.core.expressions");
    }

    public Expression getExpression(String string) throws CoreException {
        Expression expression = (Expression)this.getCache().get(string);
        if (expression != null) {
            return expression;
        }
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.core.expressions", "definitions");
        Expression expression2 = null;
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string2 = iConfigurationElementArray[n].getAttribute("id");
            if (string2 != null && string2.equals(string)) {
                try {
                    expression2 = this.getExpression(string, iConfigurationElementArray[n]);
                    break;
                }
                catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    throw new CoreException((IStatus)new ExpressionStatus(52, Messages.format(ExpressionMessages.Missing_Expression, string)));
                }
            }
            ++n;
        }
        if (expression2 == null) {
            throw new CoreException((IStatus)new ExpressionStatus(52, Messages.format(ExpressionMessages.Missing_Expression, string)));
        }
        return expression2;
    }

    private Expression getExpression(String string, IConfigurationElement iConfigurationElement) throws InvalidRegistryObjectException, CoreException {
        Expression expression = ExpressionConverter.getDefault().perform(iConfigurationElement.getChildren()[0]);
        if (expression != null) {
            this.getCache().put(string, expression);
        }
        return expression;
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.core.expressions", "definitions");
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            if (iExtensionDeltaArray[n].getKind() == 2) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionDeltaArray[n].getExtension().getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    String string = iConfigurationElementArray[n2].getAttribute("id");
                    if (string != null) {
                        this.getCache().remove(string);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }
}

