/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class DocumentBuilder {
    protected DocumentBuilder() {
    }

    public Document parse(InputStream inputStream) throws SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(EXmlMsg.getDefault().getString(45, "InputStream"));
        }
        return this.parse(new InputSource(inputStream));
    }

    public Document parse(InputStream inputStream, String string) throws SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(EXmlMsg.getDefault().getString(45, "InputStream"));
        }
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.parse(inputSource);
    }

    public Document parse(String string) throws SAXException, IOException {
        if (string == null) {
            throw new IllegalArgumentException(EXmlMsg.getDefault().getString(45, "URI"));
        }
        InputSource inputSource = new InputSource(string);
        return this.parse(inputSource);
    }

    public Document parse(File file) throws SAXException, IOException {
        if (file == null) {
            throw new IllegalArgumentException(EXmlMsg.getDefault().getString(45, "File"));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(fileInputStream);
        Document document = this.parse(inputSource);
        ((InputStream)fileInputStream).close();
        return document;
    }

    public abstract Document parse(InputSource var1) throws SAXException, IOException;

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public abstract void setEntityResolver(EntityResolver var1);

    public abstract void setErrorHandler(ErrorHandler var1);

    public abstract Document newDocument();

    public abstract DOMImplementation getDOMImplementation();
}

