/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.internal.content.Activator;
import org.eclipse.core.internal.content.BasicDescription;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeBuilder;
import org.eclipse.core.internal.content.ContentTypeCatalog;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.ContentTypeMatcher;
import org.eclipse.core.internal.content.ILazySource;
import org.eclipse.core.internal.content.LazyInputStream;
import org.eclipse.core.internal.content.LazyReader;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class ContentTypeManager
extends ContentTypeMatcher
implements IContentTypeManager,
IRegistryChangeListener {
    private static ContentTypeManager instance;
    public static final int BLOCK_SIZE = 1024;
    public static final String CONTENT_TYPE_PREF_NODE = "org.eclipse.core.runtime/content-types";
    private static final String OPTION_DEBUG_CONTENT_TYPES = "org.eclipse.core.contenttype/debug";
    static final boolean DEBUGGING;
    private ContentTypeCatalog catalog;
    private int catalogGeneration;
    protected ListenerList contentTypeListeners = new ListenerList();

    static {
        DEBUGGING = Activator.getDefault().getBooleanDebugOption(OPTION_DEBUG_CONTENT_TYPES, false);
    }

    public static void startup() {
        ContentTypeManager.getInstance();
    }

    public static void addRegistryChangeListener(IExtensionRegistry iExtensionRegistry) {
        if (iExtensionRegistry == null) {
            return;
        }
        iExtensionRegistry.addRegistryChangeListener((IRegistryChangeListener)ContentTypeManager.getInstance(), "org.eclipse.core.runtime");
        iExtensionRegistry.addRegistryChangeListener((IRegistryChangeListener)ContentTypeManager.getInstance(), "org.eclipse.core.contenttype");
    }

    public static void shutdown() {
        instance = null;
    }

    public static void removeRegistryChangeListener(IExtensionRegistry iExtensionRegistry) {
        if (iExtensionRegistry == null) {
            return;
        }
        ContentTypeManager.getInstance().invalidate();
        iExtensionRegistry.removeRegistryChangeListener((IRegistryChangeListener)ContentTypeManager.getInstance());
    }

    public static ContentTypeManager getInstance() {
        if (instance == null) {
            instance = new ContentTypeManager();
        }
        return instance;
    }

    static String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 || n == string.length() - 1 ? "" : string.substring(n + 1);
    }

    protected static ILazySource readBuffer(InputStream inputStream) {
        return new LazyInputStream(inputStream, 1024);
    }

    protected static ILazySource readBuffer(Reader reader) {
        return new LazyReader(reader, 1024);
    }

    public ContentTypeManager() {
        super(null, (IScopeContext)new InstanceScope());
    }

    protected ContentTypeBuilder createBuilder(ContentTypeCatalog contentTypeCatalog) {
        return new ContentTypeBuilder(contentTypeCatalog);
    }

    public IContentType[] getAllContentTypes() {
        ContentTypeCatalog contentTypeCatalog = this.getCatalog();
        IContentType[] iContentTypeArray = contentTypeCatalog.getAllContentTypes();
        IContentType[] iContentTypeArray2 = new IContentType[iContentTypeArray.length];
        int n = contentTypeCatalog.getGeneration();
        int n2 = 0;
        while (n2 < iContentTypeArray2.length) {
            iContentTypeArray2[n2] = new ContentTypeHandler((ContentType)iContentTypeArray[n2], n);
            ++n2;
        }
        return iContentTypeArray2;
    }

    protected synchronized ContentTypeCatalog getCatalog() {
        if (this.catalog != null) {
            return this.catalog;
        }
        ContentTypeCatalog contentTypeCatalog = new ContentTypeCatalog(this, this.catalogGeneration++);
        ContentTypeBuilder contentTypeBuilder = this.createBuilder(contentTypeCatalog);
        try {
            contentTypeBuilder.buildCatalog();
            this.catalog = contentTypeCatalog;
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
        contentTypeCatalog.organize();
        return contentTypeCatalog;
    }

    public IContentType getContentType(String string) {
        ContentTypeCatalog contentTypeCatalog = this.getCatalog();
        ContentType contentType = contentTypeCatalog.getContentType(string);
        return contentType == null ? null : new ContentTypeHandler(contentType, contentTypeCatalog.getGeneration());
    }

    public IContentTypeMatcher getMatcher(IContentTypeManager.ISelectionPolicy iSelectionPolicy, IScopeContext iScopeContext) {
        return new ContentTypeMatcher(iSelectionPolicy, iScopeContext == null ? this.getContext() : iScopeContext);
    }

    IEclipsePreferences getPreferences() {
        return this.getPreferences(this.getContext());
    }

    IEclipsePreferences getPreferences(IScopeContext iScopeContext) {
        return iScopeContext.getNode(CONTENT_TYPE_PREF_NODE);
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        if (iRegistryChangeEvent.getExtensionDeltas("org.eclipse.core.runtime", "contentTypes").length == 0 && iRegistryChangeEvent.getExtensionDeltas("org.eclipse.core.contenttype", "contentTypes").length == 0) {
            return;
        }
        this.invalidate();
    }

    synchronized void invalidate() {
        if (DEBUGGING && this.catalog != null) {
            ContentMessages.message("Registry discarded");
        }
        this.catalog = null;
    }

    public void addContentTypeChangeListener(IContentTypeManager.IContentTypeChangeListener iContentTypeChangeListener) {
        this.contentTypeListeners.add((Object)iContentTypeChangeListener);
    }

    public void removeContentTypeChangeListener(IContentTypeManager.IContentTypeChangeListener iContentTypeChangeListener) {
        this.contentTypeListeners.remove((Object)iContentTypeChangeListener);
    }

    public void fireContentTypeChangeEvent(ContentType contentType) {
        Object[] objectArray = this.contentTypeListeners.getListeners();
        ContentTypeHandler contentTypeHandler = new ContentTypeHandler(contentType, contentType.getCatalog().getGeneration());
        int n = 0;
        while (n < objectArray.length) {
            final IContentTypeManager.ContentTypeChangeEvent contentTypeChangeEvent = new IContentTypeManager.ContentTypeChangeEvent(contentTypeHandler);
            final IContentTypeManager.IContentTypeChangeListener iContentTypeChangeListener = (IContentTypeManager.IContentTypeChangeListener)objectArray[n];
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                }

                public void run() throws Exception {
                    iContentTypeChangeListener.contentTypeChanged(contentTypeChangeEvent);
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
            ++n;
        }
    }

    public IContentDescription getSpecificDescription(BasicDescription basicDescription) {
        return basicDescription;
    }
}

