/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.NativeScrollbar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    private boolean enabled = true;
    private boolean visible = true;
    private NativeScrollbar scrollbar;

    ScrollBar(Scrollable parent, int style, int handle) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.internal_handle = handle;
        this.createWidget(0);
    }

    static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    protected void internal_createHandle(int index) {
        this.scrollbar = new NativeScrollbar(this, this.parent.internal_handle, this.internal_handle);
        this.internal_handle = this.scrollbar.getHandle();
    }

    void releaseHandle() {
        this.scrollbar.releaseNativeWidget();
        this.internal_handle = 0;
        this.display = null;
        this.scrollbar = null;
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            ScrollBar.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.scrollbar.getIncrement();
    }

    public int getMaximum() {
        this.checkWidget();
        return this.scrollbar.getMaximum();
    }

    public int getMinimum() {
        this.checkWidget();
        return this.scrollbar.getMinimum();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.scrollbar.getPageIncrement();
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        return this.scrollbar.getSelection();
    }

    public Point getSize() {
        this.checkWidget();
        int[] bounds = OS.Scrollable_GetAdjustableBounds(this.parent.internal_handle, this.internal_handle);
        return new Point(bounds[2], bounds[3]);
    }

    public int getThumb() {
        this.checkWidget();
        return this.scrollbar.getThumb();
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    public boolean isEnabled() {
        this.checkWidget();
        boolean parentEnabled = true;
        if (this.parent != null) {
            parentEnabled = this.parent.isEnabled();
        }
        return this.enabled && parentEnabled;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            ScrollBar.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.enabled = enabled;
        OS.Scrollable_SetAdjustableEnabled(this.parent.internal_handle, this.internal_handle, enabled);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.scrollbar.setIncrement(value);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        this.scrollbar.setMaximum(value);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        this.scrollbar.setMinimum(value);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.scrollbar.setPageIncrement(value);
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.scrollbar.setSelection(value);
    }

    public void setThumb(int value) {
        this.checkWidget();
        this.scrollbar.setThumb(value);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        this.scrollbar.setValues(selection, minimum, maximum, thumb, increment, pageIncrement);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.visible = visible;
        Rectangle before = this.parent.getClientArea();
        OS.Scrollable_SetAdjustableVisible(this.parent.internal_handle, this.internal_handle, visible);
        if (visible) {
            this.internal_sendEvent(22);
        } else {
            this.internal_sendEvent(23);
        }
        Rectangle after = this.parent.getClientArea();
        if (!before.equals(after)) {
            this.parent.clientAreaResized();
        }
    }
}

