/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.service.resolver.BundleSpecification;

public class GroupingChecker {
    final PackageRoots nullPackageRoots = new PackageRoots(null, null);
    private HashMap bundles = new HashMap();

    public void populateRoots(ResolverBundle resolverBundle) {
        this.bundles.remove(resolverBundle);
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            ResolverBundle resolverBundle2 = (ResolverBundle)bundleConstraintArray[n].getSelectedSupplier();
            if (resolverBundle2 != null) {
                this.isConsistentInternal(resolverBundle, resolverBundle2, new ArrayList(1), true, null);
            }
            ++n;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            ResolverExport resolverExport = (ResolverExport)resolverImportArray[n2].getSelectedSupplier();
            if (resolverExport != null) {
                this.isConsistentInternal(resolverBundle, resolverExport, true, null);
            }
            ++n2;
        }
    }

    public PackageRoots[][] isConsistent(ResolverBundle resolverBundle, ResolverBundle resolverBundle2) {
        ArrayList arrayList = this.isConsistentInternal(resolverBundle, resolverBundle2, new ArrayList(1), false, null);
        return arrayList == null ? null : (PackageRoots[][])arrayList.toArray((T[])new PackageRoots[arrayList.size()][]);
    }

    private ArrayList isConsistentInternal(ResolverBundle resolverBundle, ResolverBundle resolverBundle2, ArrayList arrayList, boolean bl, ArrayList arrayList2) {
        if (arrayList.contains(resolverBundle2)) {
            return arrayList2;
        }
        arrayList.add(resolverBundle2);
        ResolverExport[] resolverExportArray = resolverBundle2.getExportPackages();
        int n = 0;
        while (n < resolverExportArray.length) {
            ResolverExport resolverExport = resolverExportArray[n];
            if (resolverExportArray[n].getSubstitute() != null) {
                resolverExport = (ResolverExport)resolverExportArray[n].getSubstitute();
            }
            arrayList2 = this.isConsistentInternal(resolverBundle, resolverExport, bl, arrayList2);
            ++n;
        }
        BundleConstraint[] bundleConstraintArray = resolverBundle2.getRequires();
        int n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            ResolverBundle resolverBundle3 = (ResolverBundle)bundleConstraintArray[n2].getSelectedSupplier();
            if (resolverBundle3 != null && ((BundleSpecification)bundleConstraintArray[n2].getVersionConstraint()).isExported()) {
                arrayList2 = this.isConsistentInternal(resolverBundle, resolverBundle3, arrayList, bl, arrayList2);
            }
            ++n2;
        }
        return arrayList2;
    }

    public PackageRoots[][] isConsistent(ResolverBundle resolverBundle, ResolverExport resolverExport) {
        ArrayList arrayList = this.isConsistentInternal(resolverBundle, resolverExport, false, null);
        return arrayList == null ? null : (PackageRoots[][])arrayList.toArray((T[])new PackageRoots[arrayList.size()][]);
    }

    public PackageRoots[][] isDynamicConsistent(ResolverBundle resolverBundle, ResolverExport resolverExport) {
        ArrayList arrayList = this.isConsistentInternal(resolverBundle, resolverExport, true, null);
        return arrayList == null ? null : (PackageRoots[][])arrayList.toArray((T[])new PackageRoots[arrayList.size()][]);
    }

    private ArrayList isConsistentInternal(ResolverBundle resolverBundle, ResolverExport resolverExport, boolean bl, ArrayList arrayList) {
        PackageRoots packageRoots = this.getPackageRoots(resolverExport.getExporter(), resolverExport.getName(), null);
        arrayList = packageRoots.isConsistentClassSpace(resolverBundle, null, arrayList);
        if (!bl) {
            return arrayList;
        }
        PackageRoots packageRoots2 = this.getPackageRoots(resolverBundle, resolverExport.getName(), null);
        HashMap hashMap = (HashMap)this.bundles.get(resolverBundle);
        if (hashMap != null) {
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                PackageRoots packageRoots3 = (PackageRoots)iterator.next();
                if (packageRoots3 == packageRoots2) continue;
                arrayList = packageRoots3.isConsistentClassSpace(packageRoots, null, arrayList);
            }
        }
        return arrayList;
    }

    PackageRoots getPackageRoots(ResolverBundle resolverBundle, String string, ArrayList arrayList) {
        PackageRoots packageRoots;
        HashMap<String, PackageRoots> hashMap = (HashMap<String, PackageRoots>)this.bundles.get(resolverBundle);
        if (hashMap == null) {
            hashMap = new HashMap<String, PackageRoots>(5);
            this.bundles.put(resolverBundle, hashMap);
        }
        if ((packageRoots = (PackageRoots)hashMap.get(string)) == null) {
            packageRoots = this.createPackageRoots(resolverBundle, string, arrayList == null ? new ArrayList(1) : arrayList);
            hashMap.put(string, packageRoots);
        }
        return packageRoots != null ? packageRoots : this.nullPackageRoots;
    }

    private PackageRoots createPackageRoots(ResolverBundle resolverBundle, String string, ArrayList arrayList) {
        Object object;
        Object object2;
        if (arrayList.contains(resolverBundle)) {
            return null;
        }
        arrayList.add(resolverBundle);
        ResolverImport resolverImport = resolverBundle.getImport(string);
        if (resolverImport != null && resolverImport.getSelectedSupplier() != null && ((ResolverExport)(object2 = (ResolverExport)resolverImport.getSelectedSupplier())).getExporter() != resolverBundle) {
            return this.getPackageRoots(((ResolverExport)object2).getExporter(), string, arrayList);
        }
        object2 = resolverBundle.getExports(string);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(0);
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            object = (ResolverBundle)bundleConstraintArray[n].getSelectedSupplier();
            if (object != null) {
                Object object3;
                if (((ResolverBundle)object).getExport(string) != null) {
                    object3 = this.getPackageRoots((ResolverBundle)object, string, arrayList);
                    if (object3 != null) {
                        arrayList2.add(object3);
                    }
                } else {
                    object3 = ((ResolverBundle)object).getRequires();
                    int n2 = 0;
                    while (n2 < ((BundleConstraint[])object3).length) {
                        ResolverBundle resolverBundle2 = (ResolverBundle)object3[n2].getSelectedSupplier();
                        if (resolverBundle2 != null && ((BundleSpecification)object3[n2].getVersionConstraint()).isExported() && resolverBundle2.getExport(string) != null) {
                            PackageRoots packageRoots = this.getPackageRoots(resolverBundle2, string, arrayList);
                            if (resolverBundle2 != null) {
                                arrayList2.add(packageRoots);
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        if (((Object)object2).length > 0 || arrayList2.size() > 1) {
            PackageRoots[] packageRootsArray = arrayList2.toArray(new PackageRoots[arrayList2.size()]);
            if (((Object)object2).length == 0) {
                object = packageRootsArray[0];
                int n3 = 1;
                while (n3 < packageRootsArray.length) {
                    if (packageRootsArray[n3].superSet((PackageRoots)object)) {
                        object = packageRootsArray[n3];
                    } else if (!((PackageRoots)object).superSet(packageRootsArray[n3])) {
                        object = null;
                        break;
                    }
                    ++n3;
                }
                if (object != null) {
                    return object;
                }
            }
            object = new PackageRoots(string, resolverBundle);
            int n4 = 0;
            while (n4 < packageRootsArray.length) {
                ((PackageRoots)object).merge(packageRootsArray[n4]);
                ++n4;
            }
            n4 = 0;
            while (n4 < ((Object)object2).length) {
                ((PackageRoots)object).addRoot((ResolverExport)object2[n4]);
                ++n4;
            }
            return object;
        }
        return arrayList2.size() == 0 ? this.nullPackageRoots : arrayList2.get(0);
    }

    public void clear() {
        this.bundles.clear();
    }

    public void clear(ResolverBundle resolverBundle) {
        this.bundles.remove(resolverBundle);
    }

    class PackageRoots {
        private String name;
        private ResolverBundle bundle;
        private ResolverExport[] roots;

        PackageRoots(String string, ResolverBundle resolverBundle) {
            this.name = string;
            this.bundle = resolverBundle;
        }

        public boolean hasRoots() {
            return this.roots != null && this.roots.length > 0;
        }

        public void addRoot(ResolverExport resolverExport) {
            if (this.roots == null) {
                this.roots = new ResolverExport[]{resolverExport};
                return;
            }
            String string = resolverExport.getExporter().getName();
            if (string != null) {
                int n = 0;
                while (n < this.roots.length) {
                    if (resolverExport.getExporter() != this.roots[n].getExporter() && string.equals(this.roots[n].getExporter().getName())) {
                        return;
                    }
                    ++n;
                }
            }
            if (!this.contains(resolverExport, this.roots)) {
                ResolverExport[] resolverExportArray = new ResolverExport[this.roots.length + 1];
                System.arraycopy(this.roots, 0, resolverExportArray, 0, this.roots.length);
                resolverExportArray[this.roots.length] = resolverExport;
                this.roots = resolverExportArray;
            }
        }

        private boolean contains(ResolverExport resolverExport, ResolverExport[] resolverExportArray) {
            int n = 0;
            while (n < resolverExportArray.length) {
                if (resolverExportArray[n] == resolverExport) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public void merge(PackageRoots packageRoots) {
            if (packageRoots == null || packageRoots.roots == null) {
                return;
            }
            int n = packageRoots.roots.length;
            int n2 = 0;
            while (n2 < n) {
                this.addRoot(packageRoots.roots[n2]);
                ++n2;
            }
        }

        public ArrayList isConsistentClassSpace(ResolverBundle resolverBundle, ArrayList arrayList, ArrayList arrayList2) {
            if (this.roots == null) {
                return arrayList2;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<PackageRoots>(1);
            }
            if (arrayList.contains(this)) {
                return arrayList2;
            }
            arrayList.add(this);
            int n = this.roots.length;
            int n2 = 0;
            while (n2 < n) {
                ResolverExport resolverExport = this.roots[n2];
                String[] stringArray = resolverExport.getUsesDirective();
                if (stringArray != null) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        PackageRoots packageRoots;
                        PackageRoots packageRoots2;
                        if (!stringArray[n3].equals(resolverExport.getName()) && (packageRoots2 = GroupingChecker.this.getPackageRoots(resolverExport.getExporter(), stringArray[n3], null)) != (packageRoots = GroupingChecker.this.getPackageRoots(resolverBundle, stringArray[n3], null))) {
                            if (packageRoots2 != GroupingChecker.this.nullPackageRoots && packageRoots != GroupingChecker.this.nullPackageRoots && !this.subSet(packageRoots2.roots, packageRoots.roots) && !this.subSet(packageRoots.roots, packageRoots2.roots)) {
                                if (arrayList2 == null) {
                                    arrayList2 = new ArrayList<PackageRoots[]>(1);
                                }
                                arrayList2.add(new PackageRoots[]{this, packageRoots});
                            }
                            arrayList2 = packageRoots2.isConsistentClassSpace(resolverBundle, arrayList, (ArrayList)arrayList2);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            return arrayList2;
        }

        public ArrayList isConsistentClassSpace(PackageRoots packageRoots, ArrayList arrayList, ArrayList arrayList2) {
            if (this.roots == null) {
                return arrayList2;
            }
            int n = this.roots.length;
            int n2 = 0;
            while (n2 < n) {
                ResolverExport resolverExport = this.roots[n2];
                String[] stringArray = resolverExport.getUsesDirective();
                if (stringArray != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<PackageRoots>(1);
                    }
                    if (arrayList.contains(this)) {
                        return arrayList2;
                    }
                    arrayList.add(this);
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (!stringArray[n3].equals(resolverExport.getName()) && stringArray[n3].equals(packageRoots.name)) {
                            PackageRoots packageRoots2 = GroupingChecker.this.getPackageRoots(resolverExport.getExporter(), stringArray[n3], null);
                            PackageRoots packageRoots3 = GroupingChecker.this.getPackageRoots(packageRoots.bundle, stringArray[n3], null);
                            if (packageRoots2 == packageRoots) {
                                return arrayList2;
                            }
                            if (packageRoots2 != GroupingChecker.this.nullPackageRoots && packageRoots3 != GroupingChecker.this.nullPackageRoots && !this.subSet(packageRoots2.roots, packageRoots3.roots) && !this.subSet(packageRoots3.roots, packageRoots2.roots)) {
                                if (arrayList2 == null) {
                                    arrayList2 = new ArrayList<PackageRoots[]>(1);
                                }
                                arrayList2.add(new PackageRoots[]{this, packageRoots3});
                            }
                            arrayList2 = packageRoots2.isConsistentClassSpace(packageRoots, arrayList, (ArrayList)arrayList2);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            return arrayList2;
        }

        private boolean subSet(ResolverExport[] resolverExportArray, ResolverExport[] resolverExportArray2) {
            int n = 0;
            while (n < resolverExportArray2.length) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < resolverExportArray.length) {
                    if (resolverExportArray2[n].getExporter() == resolverExportArray[n2].getExporter()) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public boolean superSet(PackageRoots packageRoots) {
            return this.subSet(this.roots, packageRoots.roots);
        }

        public String getName() {
            return this.name;
        }

        public ResolverExport[] getRoots() {
            return this.roots;
        }
    }
}

