/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.AnyThreadAppLauncher;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.DefaultApplicationListener;
import org.eclipse.equinox.internal.app.EclipseAppDescriptor;
import org.eclipse.equinox.internal.app.EclipseAppHandle;
import org.eclipse.equinox.internal.app.IBranding;
import org.eclipse.equinox.internal.app.MainApplicationLauncher;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.equinox.internal.app.ProductExtensionBranding;
import org.eclipse.equinox.internal.app.ProviderExtensionBranding;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.runnable.ApplicationLauncher;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EclipseAppContainer
implements IRegistryEventListener,
SynchronousBundleListener,
ServiceTrackerCustomizer {
    private static final String PI_RUNTIME = "org.eclipse.core.runtime";
    private static final String PT_APPLICATIONS = "applications";
    private static final String PT_APP_VISIBLE = "visible";
    private static final String PT_APP_THREAD = "thread";
    private static final String PT_APP_THREAD_ANY = "any";
    private static final String PT_APP_CARDINALITY = "cardinality";
    private static final String PT_APP_CARDINALITY_SINGLETON_GLOBAL = "singleton-global";
    private static final String PT_APP_CARDINALITY_SINGLETON_SCOPED = "singleton-scoped";
    private static final String PT_APP_CARDINALITY_UNLIMITED = "*";
    private static final String PT_APP_ICON = "icon";
    private static final String PT_PRODUCTS = "products";
    private static final String EXT_ERROR_APP = "org.eclipse.equinox.app.error";
    static final String PROP_PRODUCT = "eclipse.product";
    static final String PROP_ECLIPSE_APPLICATION = "eclipse.application";
    private static final String PROP_ECLIPSE_APPLICATION_LAUNCH_DEFAULT = "eclipse.application.launchDefault";
    static final int NOT_LOCKED = 0;
    static final int LOCKED_SINGLETON_GLOBAL_RUNNING = 1;
    static final int LOCKED_SINGLETON_GLOBAL_APPS_RUNNING = 2;
    static final int LOCKED_SINGLETON_SCOPED_RUNNING = 3;
    static final int LOCKED_SINGLETON_LIMITED_RUNNING = 4;
    static final int LOCKED_MAIN_THREAD_RUNNING = 5;
    final BundleContext context;
    private final HashMap apps = new HashMap();
    private final IExtensionRegistry extensionRegistry;
    private final ServiceTracker launcherTracker;
    private IBranding branding;
    private boolean missingProductReported;
    private final Collection activeHandles = new ArrayList();
    private EclipseAppHandle activeMain;
    private EclipseAppHandle activeGlobalSingleton;
    private EclipseAppHandle activeScopedSingleton;
    private HashMap activeLimited;
    private String defaultAppId;
    private DefaultApplicationListener defaultAppListener;
    private ParameterizedRunnable defaultMainThreadAppHandle;
    private volatile boolean missingApp = false;
    private MainApplicationLauncher missingAppLauncher;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public EclipseAppContainer(BundleContext bundleContext, IExtensionRegistry iExtensionRegistry) {
        this.context = bundleContext;
        this.extensionRegistry = iExtensionRegistry;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.runnable.ApplicationLauncher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.launcherTracker = new ServiceTracker(bundleContext, clazz.getName(), (ServiceTrackerCustomizer)this);
    }

    void start() {
        this.launcherTracker.open();
        this.extensionRegistry.addListener((IRegistryEventListener)this, "org.eclipse.core.runtime.applications");
        this.context.addBundleListener((BundleListener)this);
        this.registerAppDescriptors();
        String string = this.context.getProperty(PROP_ECLIPSE_APPLICATION_LAUNCH_DEFAULT);
        if (string == null || "true".equalsIgnoreCase(string)) {
            try {
                this.startDefaultApp(true);
            }
            catch (ApplicationException applicationException) {
                Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 4, 0, Messages.application_errorStartDefault, 0, (Throwable)applicationException, null));
            }
        }
    }

    void stop() {
        this.stopAllApps();
        this.context.removeBundleListener((BundleListener)this);
        this.extensionRegistry.removeListener((IRegistryEventListener)this);
        this.apps.clear();
        this.branding = null;
        this.missingProductReported = false;
        this.launcherTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EclipseAppDescriptor getAppDescriptor(String string) {
        EclipseAppDescriptor eclipseAppDescriptor = null;
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            eclipseAppDescriptor = (EclipseAppDescriptor)this.apps.get(string);
        }
        if (eclipseAppDescriptor == null) {
            this.registerAppDescriptor(string);
            hashMap = this.apps;
            synchronized (hashMap) {
                eclipseAppDescriptor = (EclipseAppDescriptor)this.apps.get(string);
            }
        }
        return eclipseAppDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EclipseAppDescriptor createAppDescriptor(IExtension iExtension) {
        if (Activator.DEBUG) {
            System.out.println("Creating application descriptor: " + iExtension.getUniqueIdentifier());
        }
        String string = null;
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            String string2;
            EclipseAppDescriptor eclipseAppDescriptor = (EclipseAppDescriptor)this.apps.get(iExtension.getUniqueIdentifier());
            if (eclipseAppDescriptor != null) {
                return eclipseAppDescriptor;
            }
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = 35;
            int n2 = 0;
            if (iConfigurationElementArray.length > 0) {
                String string3;
                String string4;
                String string5;
                string2 = iConfigurationElementArray[0].getAttribute(PT_APP_VISIBLE);
                if (string2 != null && !Boolean.valueOf(string2).booleanValue()) {
                    n &= 0xFFFFFFFE;
                }
                if (PT_APP_THREAD_ANY.equals(string5 = iConfigurationElementArray[0].getAttribute(PT_APP_THREAD))) {
                    n |= 0x40;
                    n &= 0xFFFFFFDF;
                }
                if ((string4 = iConfigurationElementArray[0].getAttribute(PT_APP_CARDINALITY)) != null) {
                    n &= 0xFFFFFFFD;
                    if (PT_APP_CARDINALITY_SINGLETON_SCOPED.equals(string4)) {
                        n |= 4;
                    } else if (PT_APP_CARDINALITY_UNLIMITED.equals(string4)) {
                        n |= 8;
                    } else if (PT_APP_CARDINALITY_SINGLETON_GLOBAL.equals(string4)) {
                        n |= 2;
                    } else {
                        try {
                            n2 = Integer.parseInt(string4);
                            n |= 0x10;
                        }
                        catch (NumberFormatException numberFormatException) {
                            n |= 2;
                        }
                    }
                }
                if ((string3 = this.getDefaultAppId()) != null && string3.equals(iExtension.getUniqueIdentifier())) {
                    n |= 0x80;
                }
                string = iConfigurationElementArray[0].getAttribute(PT_APP_ICON);
            }
            eclipseAppDescriptor = new EclipseAppDescriptor(Activator.getBundle(iExtension.getContributor()), iExtension.getUniqueIdentifier(), iExtension.getLabel(), string, n, n2, this);
            String[] stringArray = new String[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.osgi.service.application.ApplicationDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            stringArray[0] = clazz.getName();
            string2 = (ServiceRegistration)AccessController.doPrivileged(new RegisterService(stringArray, eclipseAppDescriptor, eclipseAppDescriptor.getServiceProperties()));
            eclipseAppDescriptor.setServiceRegistration((ServiceRegistration)string2);
            this.apps.put(iExtension.getUniqueIdentifier(), eclipseAppDescriptor);
            return eclipseAppDescriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EclipseAppDescriptor removeAppDescriptor(String string) {
        if (Activator.DEBUG) {
            System.out.println("Removing application descriptor: " + string);
        }
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            EclipseAppDescriptor eclipseAppDescriptor;
            block5: {
                eclipseAppDescriptor = (EclipseAppDescriptor)this.apps.remove(string);
                if (eclipseAppDescriptor != null) break block5;
                return null;
            }
            eclipseAppDescriptor.unregister();
            return eclipseAppDescriptor;
        }
    }

    PrivilegedAction getRegServiceAction(String[] stringArray, Object object, Dictionary dictionary) {
        return new RegisterService(stringArray, object, dictionary);
    }

    void startDefaultApp(boolean bl) throws ApplicationException {
        String string = this.getDefaultAppId();
        EclipseAppDescriptor eclipseAppDescriptor = null;
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>(2);
        hashMap.put("eclipse.application.default", Boolean.TRUE);
        if (string == null && !bl) {
            hashMap.put("error.exception", new RuntimeException(Messages.application_noIdFound));
            eclipseAppDescriptor = this.getAppDescriptor(EXT_ERROR_APP);
        } else {
            eclipseAppDescriptor = this.getAppDescriptor(string);
            if (eclipseAppDescriptor == null && !bl) {
                hashMap.put("error.exception", new RuntimeException(NLS.bind((String)Messages.application_notFound, (Object)string, (Object)this.getAvailableAppsMsg())));
                eclipseAppDescriptor = this.getAppDescriptor(EXT_ERROR_APP);
            }
        }
        if (bl && eclipseAppDescriptor == null) {
            this.missingApp = true;
            return;
        }
        if (eclipseAppDescriptor == null) {
            throw new ApplicationException(3, Messages.application_noIdFound);
        }
        eclipseAppDescriptor.launch(hashMap);
    }

    private void registerAppDescriptors() {
        IExtension[] iExtensionArray = this.getAvailableAppExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            this.createAppDescriptor(iExtensionArray[n]);
            ++n;
        }
    }

    private void registerAppDescriptor(String string) {
        IExtension iExtension = this.getAppExtension(string);
        if (iExtension != null) {
            this.createAppDescriptor(iExtension);
        }
    }

    private IExtension[] getAvailableAppExtensions() {
        IExtensionPoint iExtensionPoint = this.extensionRegistry.getExtensionPoint("org.eclipse.core.runtime.applications");
        if (iExtensionPoint == null) {
            return new IExtension[0];
        }
        return iExtensionPoint.getExtensions();
    }

    String getAvailableAppsMsg() {
        IExtension[] iExtensionArray = this.getAvailableAppExtensions();
        String string = "<NONE>";
        if (iExtensionArray.length != 0) {
            string = iExtensionArray[0].getUniqueIdentifier();
            int n = 1;
            while (n < iExtensionArray.length) {
                string = String.valueOf(string) + ", " + iExtensionArray[n].getUniqueIdentifier();
                ++n;
            }
        }
        return string;
    }

    IExtension getAppExtension(String string) {
        return this.extensionRegistry.getExtension(PI_RUNTIME, PT_APPLICATIONS, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void launch(EclipseAppHandle eclipseAppHandle) throws Exception {
        boolean bl = eclipseAppHandle.isDefault();
        if (((EclipseAppDescriptor)eclipseAppHandle.getApplicationDescriptor()).getThreadType() == 32) {
            DefaultApplicationListener defaultApplicationListener = null;
            MainApplicationLauncher mainApplicationLauncher = null;
            ApplicationLauncher applicationLauncher = null;
            EclipseAppContainer eclipseAppContainer = this;
            synchronized (eclipseAppContainer) {
                applicationLauncher = (ApplicationLauncher)this.launcherTracker.getService();
                if (applicationLauncher == null) {
                    if (bl) {
                        this.defaultMainThreadAppHandle = eclipseAppHandle;
                        return;
                    }
                    throw new ApplicationException(3);
                }
                defaultApplicationListener = this.defaultAppListener;
                mainApplicationLauncher = this.missingAppLauncher;
            }
            if (defaultApplicationListener != null) {
                defaultApplicationListener.launch(eclipseAppHandle);
            } else if (mainApplicationLauncher != null) {
                mainApplicationLauncher.launch(eclipseAppHandle);
            } else {
                applicationLauncher.launch((ParameterizedRunnable)eclipseAppHandle, eclipseAppHandle.getArguments().get("application.args"));
            }
        } else {
            AnyThreadAppLauncher.launchEclipseApplication(eclipseAppHandle);
            DefaultApplicationListener defaultApplicationListener = null;
            MainApplicationLauncher mainApplicationLauncher = null;
            if (bl) {
                ApplicationLauncher applicationLauncher = null;
                EclipseAppContainer eclipseAppContainer = this;
                synchronized (eclipseAppContainer) {
                    applicationLauncher = (ApplicationLauncher)this.launcherTracker.getService();
                    if (this.defaultAppListener == null) {
                        this.defaultAppListener = new DefaultApplicationListener(eclipseAppHandle);
                    }
                    defaultApplicationListener = this.defaultAppListener;
                    if (applicationLauncher == null) {
                        this.defaultMainThreadAppHandle = defaultApplicationListener;
                        return;
                    }
                    mainApplicationLauncher = this.missingAppLauncher;
                }
                if (mainApplicationLauncher != null) {
                    mainApplicationLauncher.launch(defaultApplicationListener);
                } else {
                    applicationLauncher.launch((ParameterizedRunnable)defaultApplicationListener, null);
                }
            }
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if ((0x100 & bundleEvent.getType()) == 0 || bundleEvent.getBundle().getBundleId() != 0L) {
            return;
        }
        this.stopAllApps();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopAllApps() {
        try {
            ServiceReference[] serviceReferenceArray;
            Class<?> clazz = class$2;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.osgi.service.application.ApplicationHandle");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$2 = clazz2;
            }
            if ((serviceReferenceArray = this.context.getServiceReferences(clazz.getName(), "(!(application.state=STOPPING))")) == null) return;
            int n = 0;
            while (true) {
                block13: {
                    Object var6_6;
                    if (n >= serviceReferenceArray.length) {
                        return;
                    }
                    ApplicationHandle applicationHandle = (ApplicationHandle)this.context.getService(serviceReferenceArray[n]);
                    try {
                        try {
                            if (applicationHandle != null) {
                                applicationHandle.destroy();
                            }
                        }
                        catch (Throwable throwable) {
                            String string = NLS.bind((String)Messages.application_error_stopping, (Object)applicationHandle.getInstanceId());
                            Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 2, 0, string, 0, throwable, null));
                        }
                    }
                    catch (Throwable throwable) {
                        var6_6 = null;
                        if (applicationHandle == null) throw throwable;
                        this.context.ungetService(serviceReferenceArray[n]);
                        throw throwable;
                    }
                    {
                        var6_6 = null;
                        if (applicationHandle == null) break block13;
                    }
                    this.context.ungetService(serviceReferenceArray[n]);
                }
                ++n;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    private String getDefaultAppId() {
        if (this.defaultAppId != null) {
            return this.defaultAppId;
        }
        this.defaultAppId = CommandLineArgs.getApplication();
        if (this.defaultAppId != null) {
            return this.defaultAppId;
        }
        this.defaultAppId = this.context.getProperty(PROP_ECLIPSE_APPLICATION);
        if (this.defaultAppId != null) {
            return this.defaultAppId;
        }
        this.defaultAppId = this.getBranding() == null ? null : this.getBranding().getApplication();
        return this.defaultAppId;
    }

    public IBranding getBranding() {
        IConfigurationElement[] iConfigurationElementArray;
        if (this.branding != null) {
            return this.branding;
        }
        String string = CommandLineArgs.getProduct();
        if (string == null) {
            if (this.context == null) {
                return null;
            }
            string = this.context.getProperty(PROP_PRODUCT);
            if (string == null) {
                return null;
            }
        }
        if ((iConfigurationElementArray = this.extensionRegistry.getConfigurationElementsFor(PI_RUNTIME, PT_PRODUCTS, string)).length > 0) {
            this.branding = new ProductExtensionBranding(string, iConfigurationElementArray[0]);
            return this.branding;
        }
        IConfigurationElement[] iConfigurationElementArray2 = this.extensionRegistry.getConfigurationElementsFor(PI_RUNTIME, PT_PRODUCTS);
        ArrayList<FrameworkLogEntry> arrayList = null;
        int n = 0;
        while (n < iConfigurationElementArray2.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n];
            if (iConfigurationElement.getName().equalsIgnoreCase("provider")) {
                try {
                    Object object = iConfigurationElement.createExecutableExtension("run");
                    Object[] objectArray = (Object[])EclipseAppContainer.callMethod(object, "getProducts", null, null);
                    if (objectArray != null) {
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            if (string.equalsIgnoreCase((String)EclipseAppContainer.callMethod(objectArray[n2], "getId", null, null))) {
                                this.branding = new ProviderExtensionBranding(objectArray[n2]);
                                return this.branding;
                            }
                            ++n2;
                        }
                    }
                }
                catch (CoreException coreException) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<FrameworkLogEntry>(3);
                    }
                    arrayList.add(new FrameworkLogEntry("org.eclipse.equinox.app", NLS.bind((String)Messages.provider_invalid, (Object)iConfigurationElement.getParent().toString()), 0, (Throwable)coreException, null));
                }
            }
            ++n;
        }
        if (arrayList != null) {
            Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", Messages.provider_invalid_general, 0, null, arrayList.toArray(new FrameworkLogEntry[arrayList.size()])));
        }
        if (!this.missingProductReported) {
            Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", NLS.bind((String)Messages.product_notFound, (Object)string), 0, null, null));
            this.missingProductReported = true;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAppDescriptors() {
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            Iterator iterator = this.apps.values().iterator();
            while (iterator.hasNext()) {
                ((EclipseAppDescriptor)iterator.next()).refreshProperties();
            }
        }
    }

    synchronized void lock(EclipseAppHandle eclipseAppHandle) throws ApplicationException {
        EclipseAppDescriptor eclipseAppDescriptor = (EclipseAppDescriptor)eclipseAppHandle.getApplicationDescriptor();
        switch (this.isLocked(eclipseAppDescriptor)) {
            case 0: {
                break;
            }
            case 1: {
                throw new ApplicationException(2, NLS.bind((String)Messages.singleton_running, (Object)this.activeGlobalSingleton.getInstanceId()));
            }
            case 2: {
                throw new ApplicationException(2, Messages.apps_running);
            }
            case 3: {
                throw new ApplicationException(2, NLS.bind((String)Messages.singleton_running, (Object)this.activeScopedSingleton.getInstanceId()));
            }
            case 4: {
                throw new ApplicationException(2, NLS.bind((String)Messages.max_running, (Object)eclipseAppDescriptor.getApplicationId()));
            }
            case 5: {
                throw new ApplicationException(2, NLS.bind((String)Messages.main_running, (Object)this.activeMain.getInstanceId()));
            }
        }
        switch (eclipseAppDescriptor.getCardinalityType()) {
            case 2: {
                this.activeGlobalSingleton = eclipseAppHandle;
                break;
            }
            case 4: {
                this.activeScopedSingleton = eclipseAppHandle;
                break;
            }
            case 16: {
                ArrayList<EclipseAppHandle> arrayList;
                if (this.activeLimited == null) {
                    this.activeLimited = new HashMap(3);
                }
                if ((arrayList = (ArrayList<EclipseAppHandle>)this.activeLimited.get(eclipseAppDescriptor.getApplicationId())) == null) {
                    arrayList = new ArrayList<EclipseAppHandle>(eclipseAppDescriptor.getCardinality());
                    this.activeLimited.put(eclipseAppDescriptor.getApplicationId(), arrayList);
                }
                arrayList.add(eclipseAppHandle);
                break;
            }
            case 8: {
                break;
            }
        }
        if (eclipseAppDescriptor.getThreadType() == 32) {
            this.activeMain = eclipseAppHandle;
        }
        this.activeHandles.add(eclipseAppHandle);
        this.refreshAppDescriptors();
    }

    synchronized void unlock(EclipseAppHandle eclipseAppHandle) {
        ArrayList arrayList;
        if (this.activeGlobalSingleton == eclipseAppHandle) {
            this.activeGlobalSingleton = null;
        } else if (this.activeScopedSingleton == eclipseAppHandle) {
            this.activeScopedSingleton = null;
        } else if (((EclipseAppDescriptor)eclipseAppHandle.getApplicationDescriptor()).getCardinalityType() == 16 && this.activeLimited != null && (arrayList = (ArrayList)this.activeLimited.get(((EclipseAppDescriptor)eclipseAppHandle.getApplicationDescriptor()).getApplicationId())) != null) {
            arrayList.remove(eclipseAppHandle);
        }
        if (this.activeMain == eclipseAppHandle) {
            this.activeMain = null;
        }
        if (this.activeHandles.remove(eclipseAppHandle)) {
            this.refreshAppDescriptors();
        }
    }

    synchronized int isLocked(EclipseAppDescriptor eclipseAppDescriptor) {
        if (this.activeGlobalSingleton != null) {
            return 1;
        }
        switch (eclipseAppDescriptor.getCardinalityType()) {
            case 2: {
                if (this.activeHandles.size() <= 0) break;
                return 2;
            }
            case 4: {
                if (this.activeScopedSingleton == null) break;
                return 3;
            }
            case 16: {
                ArrayList arrayList;
                if (this.activeLimited == null || (arrayList = (ArrayList)this.activeLimited.get(eclipseAppDescriptor.getApplicationId())) == null || arrayList.size() < eclipseAppDescriptor.getCardinality()) break;
                return 4;
            }
            case 8: {
                break;
            }
        }
        if (eclipseAppDescriptor.getThreadType() == 32 && this.activeMain != null) {
            return 5;
        }
        return 0;
    }

    static Object callMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        try {
            return EclipseAppContainer.callMethodWithException(object, string, classArray, objectArray);
        }
        catch (Throwable throwable) {
            Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 4, 0, "Error in invoking method.", 0, throwable, null));
            return null;
        }
    }

    static Object callMethodWithException(Object object, String string, Class[] classArray, Object[] objectArray) throws Exception {
        try {
            Method method = object.getClass().getMethod(string, classArray);
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof Exception) {
                throw (Exception)invocationTargetException.getTargetException();
            }
            throw invocationTargetException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference serviceReference) {
        Object object;
        ApplicationLauncher applicationLauncher;
        EclipseAppContainer eclipseAppContainer = this;
        synchronized (eclipseAppContainer) {
            applicationLauncher = (ApplicationLauncher)this.context.getService(serviceReference);
            object = this.defaultMainThreadAppHandle;
            this.defaultMainThreadAppHandle = null;
            if (object == null && this.missingApp) {
                this.missingAppLauncher = new MainApplicationLauncher(this);
                object = this.missingAppLauncher;
                this.missingApp = false;
            }
        }
        if (object != null) {
            applicationLauncher.launch(object, object instanceof EclipseAppHandle ? ((EclipseAppHandle)object).getArguments().get("application.args") : null);
        }
        return applicationLauncher;
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
    }

    public void removedService(ServiceReference serviceReference, Object object) {
    }

    public void added(IExtension[] iExtensionArray) {
        int n = 0;
        while (n < iExtensionArray.length) {
            this.createAppDescriptor(iExtensionArray[n]);
            ++n;
        }
    }

    public void added(IExtensionPoint[] iExtensionPointArray) {
    }

    public void removed(IExtension[] iExtensionArray) {
        int n = 0;
        while (n < iExtensionArray.length) {
            this.removeAppDescriptor(iExtensionArray[n].getUniqueIdentifier());
            ++n;
        }
    }

    public void removed(IExtensionPoint[] iExtensionPointArray) {
    }

    private class RegisterService
    implements PrivilegedAction {
        String[] serviceClasses;
        Object serviceObject;
        Dictionary serviceProps;

        RegisterService(String[] stringArray, Object object, Dictionary dictionary) {
            this.serviceClasses = stringArray;
            this.serviceObject = object;
            this.serviceProps = dictionary;
        }

        public Object run() {
            return EclipseAppContainer.this.context.registerService(this.serviceClasses, this.serviceObject, this.serviceProps);
        }
    }
}

