/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.core.runtime.IProgressMonitor;

public class UpdateMonitor
implements IProgressMonitor {
    private boolean isCanceldNow = false;
    private boolean allDone = false;
    private String name;
    private String taskName;
    private String subTaskName;
    private int totalWork;
    double doneWork = 0.0;
    private boolean enableDebug = false;

    public void beginTask(String name, int totalWork) {
        this.name = name;
        this.totalWork = totalWork;
        this.doneWork = 0.0;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Task begins.(name=\"" + name + "\", total work=" + totalWork + ")");
        }
    }

    public void done() {
        this.allDone = true;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Done!");
        }
    }

    public void internalWorked(double work) {
        this.doneWork += work;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Progress now is " + this.doneWork + " / " + this.totalWork);
        }
    }

    public boolean isCanceled() {
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Cancel status(" + this.isCanceldNow + ") is checked.");
        }
        return this.isCanceldNow;
    }

    public void setCanceled(boolean value) {
        this.isCanceldNow = value;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Cancel value is set as " + this.isCanceldNow);
        }
    }

    public void setTaskName(String name) {
        this.taskName = name;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Task Name: " + name);
        }
    }

    public void subTask(String name) {
        this.subTaskName = name;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Sub Task : (" + name + ")");
        }
    }

    public void worked(int work) {
        this.doneWork += (double)work;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Progress now is " + this.doneWork + " / " + this.totalWork);
        }
    }

    public boolean isDone() {
        return this.allDone;
    }

    public String getName() {
        return this.name;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getSubTaskName() {
        return this.subTaskName;
    }

    public int getTotalWorksCount() {
        return this.totalWork;
    }

    public double getDoneWorksCount() {
        return this.doneWork;
    }

    public void setDebug(boolean enabled) {
        this.enableDebug = enabled;
    }
}

