/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Composite;

import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.ConstrainedText;
import org.eclipse.ercp.swt.mobile.MobileShell;
import org.eclipse.ercp.swt.samples.eswtdemo.Composite.CompositeShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CompositeShowCaseComplexLayout
extends ShowCase
implements SelectionListener,
ControlListener {
    MobileShell mobileShell;
    Canvas coordinatedCanvas;
    ScrollBar vSrollBarCoordinatedCanvas;
    int lastScrollBarSelection = 0;
    FormData coordinatedCanvasFormdata;
    int coordinatedCanvasAttachementLeft = 5;
    int coordinatedCanvasAttachementTop = 5;
    CaptionedControl lastNameCptCtrl;
    Text textLastName;
    CaptionedControl firstNameCptCtrl;
    Text textFirstName;
    CaptionedControl telephoneCptCtrl;
    ConstrainedText textTelephone;
    CaptionedControl mobileCptCtrl;
    ConstrainedText textMobile;
    Canvas pictureCanvas;
    Command commandSelectedPicture;
    Command commandRemoveSelectedPicture;
    Label separatorLabel;
    Label skillsLabel;
    Text skillsText;
    Command commandGrow;
    Command commandShrink;
    Command commandExit;
    static int MOBILESHELL_STATE_SMALL = 0;
    static int MOBILESHELL_STATE_NORMAL = 1;
    static int MOBILESHELL_STATE_FULLSCREEN = 2;
    int mobileshellstate = MOBILESHELL_STATE_SMALL;
    Image defaultPicture;
    Image selectedPicture;
    FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            if (e.widget == CompositeShowCaseComplexLayout.this.textLastName || e.widget == CompositeShowCaseComplexLayout.this.textFirstName) {
                CompositeShowCaseComplexLayout.this.vSrollBarCoordinatedCanvas.setSelection(CompositeShowCaseComplexLayout.this.vSrollBarCoordinatedCanvas.getMinimum());
                CompositeShowCaseComplexLayout.this.updateCanvasWithScrolBar();
            } else if (e.widget == CompositeShowCaseComplexLayout.this.textTelephone || e.widget == CompositeShowCaseComplexLayout.this.textMobile) {
                CompositeShowCaseComplexLayout.this.vSrollBarCoordinatedCanvas.setSelection(CompositeShowCaseComplexLayout.this.vSrollBarCoordinatedCanvas.getMaximum());
                CompositeShowCaseComplexLayout.this.updateCanvasWithScrolBar();
            }
        }

        public void focusLost(FocusEvent e) {
        }
    };
    SelectionListener scrollBarListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == CompositeShowCaseComplexLayout.this.vSrollBarCoordinatedCanvas) {
                CompositeShowCaseComplexLayout.this.updateCanvasWithScrolBar();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    PaintListener paintPicture = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Image image = CompositeShowCaseComplexLayout.this.selectedPicture != null ? CompositeShowCaseComplexLayout.this.selectedPicture : CompositeShowCaseComplexLayout.this.defaultPicture;
            Rectangle imageBnds = image.getBounds();
            Rectangle canvasBnds = ((Canvas)e.widget).getBounds();
            float ratio = (float)imageBnds.width / (float)imageBnds.height;
            int w = (int)((float)canvasBnds.height * ratio);
            int h = canvasBnds.height;
            int dx = (canvasBnds.width - w) / 2;
            int dy = 0;
            if (w > canvasBnds.width) {
                w = canvasBnds.width;
                h = (int)((float)canvasBnds.width * ratio);
                dx = 0;
                dy = (canvasBnds.height - h) / 2;
            }
            e.gc.drawImage(image, 0, 0, imageBnds.width, imageBnds.height, dx, dy, w, h);
            e.gc.setForeground(CompositeShowCaseComplexLayout.this.getComposite().getDisplay().getSystemColor(23));
            if (((Canvas)e.widget).isFocusControl()) {
                e.gc.drawRectangle(0, 0, canvasBnds.width - 1, canvasBnds.height - 1);
            }
        }
    };

    CompositeShowCaseComplexLayout(MobileShell mobileShell) {
        this.mobileShell = mobileShell;
    }

    public String getName() {
        return Messages.getString("CompositeShowCaseComplexLayout.0");
    }

    private void createControls() {
        this.coordinatedCanvas = new Canvas(this.getComposite(), 526848);
        this.coordinatedCanvas.addControlListener((ControlListener)this);
        this.lastNameCptCtrl = new CaptionedControl((Composite)this.coordinatedCanvas, 0x2000000);
        this.lastNameCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.1"));
        this.textLastName = new Text((Composite)this.lastNameCptCtrl, 4);
        this.textLastName.setText(Messages.getString("CompositeShowCaseComplexLayout.2"));
        this.textLastName.setSize(200, 20);
        this.firstNameCptCtrl = new CaptionedControl((Composite)this.coordinatedCanvas, 0x2000000);
        this.firstNameCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.3"));
        this.textFirstName = new Text((Composite)this.firstNameCptCtrl, 4);
        this.textFirstName.setText(Messages.getString("CompositeShowCaseComplexLayout.4"));
        this.textFirstName.setSize(200, 20);
        this.telephoneCptCtrl = new CaptionedControl((Composite)this.coordinatedCanvas, 0x2000000);
        this.telephoneCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.5"));
        this.textTelephone = new ConstrainedText((Composite)this.telephoneCptCtrl, 4, 4);
        this.textTelephone.setText(Messages.getString("CompositeShowCaseComplexLayout.6"));
        this.textTelephone.setSize(200, 20);
        this.mobileCptCtrl = new CaptionedControl((Composite)this.coordinatedCanvas, 0x2000000);
        this.mobileCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.7"));
        this.textMobile = new ConstrainedText((Composite)this.mobileCptCtrl, 4, 4);
        this.textMobile.setSize(200, 20);
        this.defaultPicture = new Image((Device)this.getComposite().getDisplay(), this.getClass().getResourceAsStream("/res/smith.png"));
        this.selectedPicture = null;
        this.pictureCanvas = new Canvas(this.getComposite(), 524288);
        this.pictureCanvas.setSize(this.defaultPicture.getBounds().width, this.defaultPicture.getBounds().height);
        this.pictureCanvas.addPaintListener(this.paintPicture);
        this.pictureCanvas.addControlListener((ControlListener)this);
        this.separatorLabel = new Label(this.getComposite(), 258);
        this.separatorLabel.setSize(-1, 1);
        this.skillsLabel = new Label(this.getComposite(), 0);
        this.skillsLabel.setText(Messages.getString("CompositeShowCaseComplexLayout.9"));
        this.skillsLabel.setSize(200, 10);
        this.skillsText = new Text(this.getComposite(), 2562);
        this.skillsText.setText(Messages.getString("CompositeShowCaseComplexLayout.10"));
    }

    private void applyLayoutOnControls() {
        FormLayout formLayoutshell = new FormLayout();
        this.getComposite().setLayout((Layout)formLayoutshell);
        FormLayout formLayoutCoordinatedCanvas = new FormLayout();
        this.coordinatedCanvasFormdata = new FormData();
        this.coordinatedCanvasFormdata.left = new FormAttachment(0, this.coordinatedCanvasAttachementLeft);
        this.coordinatedCanvasFormdata.top = new FormAttachment(0, this.coordinatedCanvasAttachementTop);
        this.coordinatedCanvasFormdata.bottom = new FormAttachment((Control)this.separatorLabel, -5);
        this.coordinatedCanvas.setLayout((Layout)formLayoutCoordinatedCanvas);
        this.coordinatedCanvas.setLayoutData((Object)this.coordinatedCanvasFormdata);
        int space = 5;
        FormData lastnameformdata = new FormData();
        lastnameformdata.left = new FormAttachment(0, 0);
        lastnameformdata.top = new FormAttachment(0, 0);
        this.lastNameCptCtrl.setLayoutData((Object)lastnameformdata);
        FormData firstnameformdata = new FormData();
        firstnameformdata.left = new FormAttachment(0, space);
        firstnameformdata.top = new FormAttachment((Control)this.lastNameCptCtrl, space);
        this.firstNameCptCtrl.setLayoutData((Object)firstnameformdata);
        FormData telephoneformdata = new FormData();
        telephoneformdata.left = new FormAttachment(0, space);
        telephoneformdata.top = new FormAttachment((Control)this.firstNameCptCtrl, space);
        this.telephoneCptCtrl.setLayoutData((Object)telephoneformdata);
        FormData mobileFormData = new FormData();
        mobileFormData.left = new FormAttachment(0, space);
        mobileFormData.top = new FormAttachment((Control)this.telephoneCptCtrl, space);
        this.mobileCptCtrl.setLayoutData((Object)mobileFormData);
        FormData canvasFormData = new FormData();
        canvasFormData.right = new FormAttachment(100, -5);
        canvasFormData.top = new FormAttachment(0, 5);
        canvasFormData.bottom = new FormAttachment((Control)this.separatorLabel, -5);
        canvasFormData.left = new FormAttachment((Control)this.coordinatedCanvas, 5);
        this.pictureCanvas.setLayoutData((Object)canvasFormData);
        FormData separatorFormdata = new FormData();
        separatorFormdata.top = new FormAttachment(50, 0);
        separatorFormdata.left = new FormAttachment(0, 5);
        separatorFormdata.right = new FormAttachment(100, -5);
        this.separatorLabel.setLayoutData((Object)separatorFormdata);
        FormData labelskillFormdata = new FormData();
        labelskillFormdata.left = new FormAttachment(0, space);
        labelskillFormdata.top = new FormAttachment((Control)this.separatorLabel, space);
        this.skillsLabel.setLayoutData((Object)labelskillFormdata);
        FormData skillTextFormData = new FormData();
        skillTextFormData.left = new FormAttachment(0, 5);
        skillTextFormData.right = new FormAttachment(100, -5);
        skillTextFormData.top = new FormAttachment((Control)this.skillsLabel, 5);
        skillTextFormData.bottom = new FormAttachment(100, -5);
        this.skillsText.setLayoutData((Object)skillTextFormData);
        this.getComposite().layout();
        this.getComposite().setFocus();
    }

    public void show() {
        this.mobileShell.setText(Messages.getString("CompositeShowCaseComplexLayout.11"));
        this.createControls();
        this.applyLayoutOnControls();
        this.createCommands();
        this.vSrollBarCoordinatedCanvas = this.coordinatedCanvas.getVerticalBar();
        this.vSrollBarCoordinatedCanvas.addSelectionListener(this.scrollBarListener);
        this.updateScrollBarSize();
        this.textLastName.addFocusListener(this.focusListener);
        this.textFirstName.addFocusListener(this.focusListener);
        this.textTelephone.addFocusListener(this.focusListener);
        this.textMobile.addFocusListener(this.focusListener);
        this.changeMobileShellSize();
        this.getComposite().setFocus();
    }

    private void createCommands() {
        this.commandGrow = new Command((Control)this.getComposite(), 1, 3);
        this.commandGrow.setText(Messages.getString("CompositeShowCaseComplexLayout.12"));
        this.commandGrow.addSelectionListener((SelectionListener)this);
        this.commandShrink = new Command((Control)this.getComposite(), 1, 1);
        this.commandShrink.setText(Messages.getString("CompositeShowCaseComplexLayout.13"));
        this.commandShrink.addSelectionListener((SelectionListener)this);
        this.commandExit = new Command((Control)this.getComposite(), 7, 0);
        this.commandExit.setText(Messages.getString("CompositeShowCaseComplexLayout.14"));
        this.commandExit.setLongLabel(Messages.getString("CompositeShowCaseComplexLayout.15"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        CompositeShowCase.getInstance().enableExit(false);
        this.commandSelectedPicture = new Command((Control)this.pictureCanvas, 1, 3);
        this.commandSelectedPicture.setText(Messages.getString("CompositeShowCaseComplexLayout.16"));
        this.commandSelectedPicture.setLongLabel(Messages.getString("CompositeShowCaseComplexLayout.17"));
        this.commandSelectedPicture.addSelectionListener((SelectionListener)this);
        this.commandRemoveSelectedPicture = new Command((Control)this.pictureCanvas, 1, 1);
        this.commandRemoveSelectedPicture.setText(Messages.getString("CompositeShowCaseComplexLayout.18"));
        this.commandRemoveSelectedPicture.setLongLabel(Messages.getString("CompositeShowCaseComplexLayout.19"));
        this.commandRemoveSelectedPicture.addSelectionListener((SelectionListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.commandGrow) {
            this.grow();
        } else if (e.widget == this.commandShrink) {
            this.shrink();
        } else if (e.widget == this.commandExit) {
            this.quit();
        } else if (e.widget == this.commandSelectedPicture) {
            this.chooseAPicture();
        } else if (e.widget == this.commandRemoveSelectedPicture && this.selectedPicture != null) {
            this.selectedPicture.dispose();
            this.selectedPicture = null;
            this.pictureCanvas.redraw();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void quit() {
        this.vSrollBarCoordinatedCanvas.removeSelectionListener(this.scrollBarListener);
        this.vSrollBarCoordinatedCanvas = null;
        this.commandSelectedPicture.dispose();
        this.commandRemoveSelectedPicture.dispose();
        this.commandGrow.dispose();
        this.commandShrink.dispose();
        this.commandExit.dispose();
        CompositeShowCase.getInstance().enableExit(true);
        if (this.selectedPicture != null) {
            this.selectedPicture.dispose();
        }
        if (this.defaultPicture != null) {
            this.defaultPicture.dispose();
        }
        this.mobileShell.setFullScreenMode(false);
        this.mobileShell.changeTrim(32, 2);
        this.dispose();
    }

    private void grow() {
        if (this.mobileshellstate == MOBILESHELL_STATE_FULLSCREEN) {
            return;
        }
        ++this.mobileshellstate;
        this.commandShrink.setEnabled(true);
        this.changeMobileShellSize();
    }

    private void shrink() {
        if (this.mobileshellstate == MOBILESHELL_STATE_SMALL) {
            return;
        }
        --this.mobileshellstate;
        this.commandGrow.setEnabled(true);
        this.changeMobileShellSize();
    }

    private void changeMobileShellSize() {
        this.vSrollBarCoordinatedCanvas.setSelection(this.vSrollBarCoordinatedCanvas.getMinimum());
        this.updateCanvasWithScrolBar();
        this.updateScrollBarSize();
        if (this.mobileshellstate == MOBILESHELL_STATE_SMALL) {
            this.mobileShell.setFullScreenMode(false);
            this.mobileShell.changeTrim(32, 3);
            this.commandShrink.setEnabled(false);
        }
        if (this.mobileshellstate == MOBILESHELL_STATE_NORMAL) {
            this.mobileShell.setFullScreenMode(false);
            this.mobileShell.changeTrim(32, 2);
        }
        if (this.mobileshellstate == MOBILESHELL_STATE_FULLSCREEN) {
            this.mobileShell.setFullScreenMode(true);
            this.mobileShell.changeTrim(8, 1);
            this.commandGrow.setEnabled(false);
            Display.getCurrent().timerExec(10000, new Runnable(){

                public void run() {
                    CompositeShowCaseComplexLayout.this.shrink();
                }
            });
        }
    }

    private void chooseAPicture() {
        if (this.selectedPicture != null) {
            this.selectedPicture.dispose();
            this.selectedPicture = null;
        }
        try {
            FileDialog fileDialog = new FileDialog((Shell)this.mobileShell, 4096);
            fileDialog.setFilterExtensions(new String[]{"*.gif", "*.png", "*.jpg"});
            fileDialog.open();
            String pathImage = fileDialog.getFileName();
            String filterPath = fileDialog.getFilterPath();
            String fullPath = String.valueOf(filterPath) + pathImage;
            fullPath = fullPath.replace('\\', '/');
            this.selectedPicture = new Image((Device)this.getComposite().getDisplay(), fullPath);
        }
        catch (Exception exception) {
            this.selectedPicture = new Image((Device)this.getComposite().getDisplay(), this.getClass().getResourceAsStream("/res/smith.jpg"));
        }
        this.pictureCanvas.redraw();
    }

    private Rectangle getChildrenBounds(Composite parent) {
        Rectangle containerArea = null;
        Control[] childrenControls = this.coordinatedCanvas.getChildren();
        int i = 0;
        while (i < childrenControls.length) {
            if (containerArea == null) {
                containerArea = new Rectangle(childrenControls[i].getBounds().x, childrenControls[i].getBounds().y, childrenControls[i].getBounds().width, childrenControls[i].getBounds().height);
            } else {
                containerArea.add(childrenControls[i].getBounds());
            }
            ++i;
        }
        return containerArea;
    }

    private void updateScrollBarSize() {
        if (this.vSrollBarCoordinatedCanvas != null) {
            int selection = this.vSrollBarCoordinatedCanvas.getSelection();
            Rectangle containerArea = this.getChildrenBounds((Composite)this.coordinatedCanvas);
            Rectangle clientArea = this.coordinatedCanvas.getClientArea();
            this.vSrollBarCoordinatedCanvas.setMaximum(containerArea.height);
            this.vSrollBarCoordinatedCanvas.setMinimum(0);
            this.vSrollBarCoordinatedCanvas.setThumb(clientArea.height);
            this.vSrollBarCoordinatedCanvas.setPageIncrement(clientArea.height);
            this.vSrollBarCoordinatedCanvas.setIncrement(clientArea.height / 10);
            this.vSrollBarCoordinatedCanvas.setSelection(selection);
        }
    }

    private void updateCanvasWithScrolBar() {
        int selection = this.vSrollBarCoordinatedCanvas.getSelection();
        Rectangle containerArea = this.getChildrenBounds((Composite)this.coordinatedCanvas);
        this.coordinatedCanvas.scroll(containerArea.x, containerArea.y + (this.lastScrollBarSelection - selection), containerArea.x, containerArea.y, containerArea.width, containerArea.height, true);
        this.lastScrollBarSelection = selection;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (e.widget == this.coordinatedCanvas) {
            this.updateScrollBarSize();
        } else {
            Widget cfr_ignored_0 = e.widget;
        }
    }

    protected void setFocus() {
        this.mobileShell.forceActive();
    }
}

