/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.presentations.NativeStackPresentation;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public abstract class PartStack
extends LayoutPart
implements ILayoutContainer {
    private List children = new ArrayList(3);
    protected int appearance = 2;
    private LayoutPart requestedCurrent;
    private LayoutPart current;
    private LayoutPart presentationCurrent;
    private boolean ignoreSelectionChanges = false;
    protected IMemento savedPresentationState = null;
    private DefaultStackPresentationSite presentationSite = new DefaultStackPresentationSite(){

        public void close(IPresentablePart part) {
            PartStack.this.close(part);
        }

        public void close(IPresentablePart[] parts) {
            PartStack.this.close(parts);
        }

        public void dragStart(IPresentablePart beingDragged, Point initialLocation, boolean keyboard) {
        }

        public void dragStart(Point initialLocation, boolean keyboard) {
        }

        public boolean isPartMoveable(IPresentablePart part) {
            return false;
        }

        public void selectPart(IPresentablePart toSelect) {
            PartStack.this.presentationSelectionChanged(toSelect);
        }

        public boolean supportsState(int state) {
            return PartStack.this.supportsState(state);
        }

        public void setState(int newState) {
            PartStack.this.setState(newState);
        }

        public IPresentablePart getSelectedPart() {
            return PartStack.this.getSelectedPart();
        }

        public boolean isStackMoveable() {
            return PartStack.this.canMoveFolder();
        }

        public void flushLayout() {
            PartStack.this.flushLayout();
        }

        public IPresentablePart[] getPartList() {
            List parts = PartStack.this.getPresentableParts();
            return parts.toArray(new IPresentablePart[parts.size()]);
        }
    };
    private boolean isMinimized;

    protected abstract boolean supportsState(int var1);

    protected abstract boolean canMoveFolder();

    protected abstract void derefPart(LayoutPart var1);

    public PartStack(int appearance) {
        super("PartStack");
        this.appearance = appearance;
    }

    protected final boolean isStandalone() {
        return false;
    }

    protected IPresentablePart getSelectedPart() {
        if (this.presentationCurrent == null) {
            return null;
        }
        return this.presentationCurrent.getPresentablePart();
    }

    protected IStackPresentationSite getPresentationSite() {
        return this.presentationSite;
    }

    public void describeLayout(StringBuffer buf) {
        int activeState = this.getActive();
        if (activeState == 1) {
            buf.append("active ");
        } else if (activeState == 2) {
            buf.append("active_nofocus ");
        }
        buf.append("(");
        LayoutPart[] children = this.getChildren();
        int visibleChildren = 0;
        int idx = 0;
        while (idx < children.length) {
            LayoutPart next = children[idx];
            if (!(next instanceof PartPlaceholder)) {
                if (idx > 0) {
                    buf.append(", ");
                }
                if (next == this.requestedCurrent) {
                    buf.append("*");
                }
                next.describeLayout(buf);
                ++visibleChildren;
            }
            ++idx;
        }
        buf.append(")");
    }

    public void add(LayoutPart child) {
        this.children.add(child);
        this.showPart(child, null);
    }

    protected void add(LayoutPart newChild, Object cookie) {
        this.children.add(newChild);
        this.showPart(newChild, cookie);
    }

    public boolean allowsAdd(LayoutPart toAdd) {
        return !this.isStandalone();
    }

    public boolean allowsAutoFocus() {
        if (this.presentationSite.getState() == 0) {
            return false;
        }
        ILayoutContainer parent = this.getContainer();
        return parent == null || parent.allowsAutoFocus();
    }

    protected void close(IPresentablePart[] parts) {
        int idx = 0;
        while (idx < parts.length) {
            IPresentablePart part = parts[idx];
            this.close(part);
            ++idx;
        }
    }

    protected void close(IPresentablePart part) {
        if (!this.presentationSite.isCloseable(part)) {
            return;
        }
        LayoutPart layoutPart = this.getPaneFor(part);
        if (layoutPart != null && layoutPart instanceof PartPane) {
            PartPane viewPane = (PartPane)layoutPart;
            viewPane.doHide();
        }
    }

    public boolean isDisposed() {
        return this.getPresentation() == null;
    }

    public void createControl(Composite parent) {
        if (!this.isDisposed()) {
            return;
        }
        NativeStackPresentation presentation = new NativeStackPresentation(parent, this.presentationSite);
        this.createControl(parent, presentation);
    }

    public void createControl(Composite parent, StackPresentation presentation) {
        Assert.isTrue((boolean)this.isDisposed());
        if (this.presentationSite.getPresentation() != null) {
            return;
        }
        this.presentationSite.setPresentation(presentation);
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart part = (LayoutPart)iter.next();
            this.showPart(part, null);
        }
        Control ctrl = this.getPresentation().getControl();
        ctrl.setData((Object)this);
        this.updateActions(this.presentationCurrent);
        if (this.requestedCurrent instanceof PartPlaceholder) {
            this.requestedCurrent = null;
            this.updateContainerVisibleTab();
        }
        this.refreshPresentationSelection();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.presentationSite.dispose();
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            next.setContainer(null);
        }
        this.presentationCurrent = null;
        this.current = null;
    }

    public Rectangle getBounds() {
        System.out.println("PartStack:getBounds: returning hardcoded bounds");
        if (this.getPresentation() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.getPresentation().getControl().getBounds();
    }

    public LayoutPart[] getChildren() {
        return this.children.toArray(new LayoutPart[this.children.size()]);
    }

    public Control getControl() {
        StackPresentation presentation = this.getPresentation();
        if (presentation == null) {
            return null;
        }
        return presentation.getControl();
    }

    public int getItemCount() {
        if (this.isDisposed()) {
            return this.children.size();
        }
        return this.getPresentableParts().size();
    }

    protected LayoutPart getPaneFor(IPresentablePart part) {
        if (part == null) {
            return null;
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            if (next.getPresentablePart() != part) continue;
            return next;
        }
        return null;
    }

    public Composite getParent() {
        return this.getControl().getParent();
    }

    public List getPresentableParts() {
        ArrayList<IPresentablePart> result = new ArrayList<IPresentablePart>(this.children.size());
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart part = (LayoutPart)iter.next();
            IPresentablePart presentablePart = part.getPresentablePart();
            if (presentablePart == null) continue;
            result.add(presentablePart);
        }
        return result;
    }

    protected StackPresentation getPresentation() {
        return this.presentationSite.getPresentation();
    }

    public PartPane getVisiblePart() {
        if (this.current instanceof PartPane) {
            return (PartPane)this.current;
        }
        return null;
    }

    private void presentationSelectionChanged(IPresentablePart newSelection) {
        if (this.ignoreSelectionChanges) {
            return;
        }
        LayoutPart newPart = this.getPaneFor(newSelection);
        Assert.isNotNull((Object)newPart);
        if (newPart == this.requestedCurrent) {
            return;
        }
        this.setSelection(newPart);
        if (newPart != null) {
            newPart.setFocus();
        }
    }

    public void remove(LayoutPart child) {
        IPresentablePart presentablePart = child.getPresentablePart();
        this.children.remove(child);
        StackPresentation presentation = this.getPresentation();
        if (presentablePart != null && presentation != null) {
            this.ignoreSelectionChanges = true;
            presentation.removePart(presentablePart);
            this.ignoreSelectionChanges = false;
        }
        if (!this.isDisposed()) {
            child.setContainer(null);
        }
        if (child == this.requestedCurrent) {
            this.updateContainerVisibleTab();
        }
    }

    public void reparent(Composite newParent) {
        if (!newParent.isReparentable()) {
            return;
        }
        Control control = this.getControl();
        if (control == null || control.getParent() == newParent) {
            return;
        }
        super.reparent(newParent);
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            next.reparent(newParent);
        }
    }

    public void replace(LayoutPart oldChild, LayoutPart newChild) {
        int idx = this.children.indexOf(oldChild);
        int numPlaceholders = 0;
        int i = 0;
        while (i < idx) {
            if (this.children.get(i) instanceof PartPlaceholder) {
                ++numPlaceholders;
            }
            ++i;
        }
        Integer cookie = new Integer(idx - numPlaceholders);
        this.children.add(idx, newChild);
        this.showPart(newChild, cookie);
        if (oldChild == this.requestedCurrent && !(newChild instanceof PartPlaceholder)) {
            this.setSelection(newChild);
        }
        this.remove(oldChild);
    }

    public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredParallel) {
        return this.getPresentation().computePreferredSize(width, availableParallel, availablePerpendicular, preferredParallel);
    }

    public int getSizeFlags(boolean horizontal) {
        StackPresentation presentation = this.getPresentation();
        if (presentation != null) {
            return presentation.getSizeFlags(horizontal);
        }
        return 0;
    }

    public IStatus restoreState(IMemento memento) {
        Integer expanded;
        String activeTabID = memento.getString("activePageID");
        IMemento[] children = memento.getChildren("page");
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IMemento childMem = children[i];
                String partID = childMem.getString("content");
                PartPlaceholder part = new PartPlaceholder(partID);
                part.setContainer(this);
                this.add(part);
                if (partID.equals(activeTabID)) {
                    this.setSelection(part);
                }
                ++i;
            }
        }
        this.setState((expanded = memento.getInteger("expanded")) == null || expanded != 0 ? 2 : 0);
        Integer appearance = memento.getInteger("appearance");
        if (appearance != null) {
            this.appearance = appearance;
        }
        this.savedPresentationState = null;
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public void setVisible(boolean makeVisible) {
        super.setVisible(makeVisible);
        StackPresentation presentation = this.getPresentation();
        if (presentation != null) {
            presentation.setVisible(makeVisible);
        }
    }

    public IStatus saveState(IMemento memento) {
        if (this.requestedCurrent != null) {
            memento.putString("activePageID", this.requestedCurrent.getCompoundId());
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            IMemento childMem = memento.createChild("page");
            IPresentablePart part = next.getPresentablePart();
            String tabText = "LabelNotFound";
            if (part != null) {
                tabText = part.getName();
            }
            childMem.putString("label", tabText);
            childMem.putString("content", next.getCompoundId());
        }
        memento.putInteger("expanded", this.presentationSite.getState() == 0 ? 0 : 2);
        memento.putInteger("appearance", this.appearance);
        if (this.savedPresentationState != null) {
            IMemento presentationState = memento.createChild("presentation");
            presentationState.putMemento(this.savedPresentationState);
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    protected WorkbenchPage getPage() {
        WorkbenchWindow window = (WorkbenchWindow)this.getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return (WorkbenchPage)window.getActivePage();
    }

    public void setActive(int activeState) {
        if (activeState == 1) {
            this.setMinimized(false);
        }
        this.presentationSite.setActive(activeState);
    }

    public int getActive() {
        return this.presentationSite.getActive();
    }

    public void setBounds(Rectangle r) {
        if (this.getPresentation() != null) {
            this.getPresentation().setBounds(r);
        }
    }

    public void setSelection(LayoutPart part) {
        if (part == this.requestedCurrent) {
            return;
        }
        this.requestedCurrent = part;
        this.refreshPresentationSelection();
    }

    protected abstract void updateActions(LayoutPart var1);

    protected void handleDeferredEvents() {
        super.handleDeferredEvents();
        this.refreshPresentationSelection();
    }

    private void refreshPresentationSelection() {
        if (this.isDeferred()) {
            return;
        }
        if (this.current == this.requestedCurrent) {
            return;
        }
        StackPresentation presentation = this.getPresentation();
        if (presentation != null) {
            IPresentablePart presentablePart;
            this.presentationCurrent = this.requestedCurrent;
            if (!this.isDisposed()) {
                this.updateActions(this.presentationCurrent);
            }
            if (this.presentationCurrent != null && (presentablePart = this.requestedCurrent.getPresentablePart()) != null && presentation != null) {
                this.requestedCurrent.createControl(this.getParent());
                if (this.requestedCurrent.getControl().getParent() != this.getControl().getParent()) {
                    this.requestedCurrent.reparent(this.getControl().getParent());
                }
                this.requestedCurrent.moveAbove(this.getPresentation().getControl());
                presentation.selectPart(this.presentationCurrent.getPresentablePart());
            }
            this.current = this.requestedCurrent;
        }
    }

    public int getState() {
        return this.presentationSite.getState();
    }

    public void setMinimized(boolean minimized) {
        if (minimized != this.isMinimized) {
            this.isMinimized = minimized;
            this.refreshPresentationState();
        }
    }

    public boolean childObscuredByZoom(LayoutPart toTest) {
        return this.isObscuredByZoom();
    }

    public void childRequestZoomIn(LayoutPart toZoom) {
        super.childRequestZoomIn(toZoom);
        this.requestZoomIn();
    }

    public void childRequestZoomOut() {
        super.childRequestZoomOut();
        this.requestZoomOut();
    }

    public boolean childIsZoomed(LayoutPart toTest) {
        return this.isZoomed();
    }

    protected void setState(int newState) {
        int oldState = this.presentationSite.getState();
        if (!this.supportsState(newState) || newState == oldState) {
            return;
        }
        boolean minimized = newState == 0;
        this.setMinimized(minimized);
        if (newState == 1) {
            this.requestZoomIn();
        } else if (oldState == 1) {
            this.requestZoomOut();
        }
    }

    public void setZoomed(boolean isZoomed) {
        super.setZoomed(isZoomed);
        LayoutPart[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            LayoutPart next = children[i];
            next.setZoomed(isZoomed);
            ++i;
        }
        this.refreshPresentationState();
    }

    public boolean isZoomed() {
        ILayoutContainer container = this.getContainer();
        if (container != null) {
            return container.childIsZoomed(this);
        }
        return false;
    }

    private void refreshPresentationState() {
        if (this.isZoomed()) {
            this.presentationSite.setPresentationState(1);
        } else {
            boolean wasMinimized;
            boolean bl = wasMinimized = this.presentationSite.getState() == 0;
            if (this.isMinimized) {
                this.presentationSite.setPresentationState(0);
            } else {
                this.presentationSite.setPresentationState(2);
            }
            if (this.isMinimized != wasMinimized) {
                WorkbenchPage page;
                this.flushLayout();
                if (this.isMinimized && (page = this.getPage()) != null) {
                    page.refreshActiveView();
                }
            }
        }
    }

    private void showPart(LayoutPart part, Object cookie) {
        if (this.isDisposed()) {
            return;
        }
        part.setContainer(this);
        IPresentablePart presentablePart = part.getPresentablePart();
        if (presentablePart == null) {
            return;
        }
        this.presentationSite.getPresentation().addPart(presentablePart, cookie);
        if (this.requestedCurrent == null) {
            this.setSelection(part);
        }
    }

    private void updateContainerVisibleTab() {
        List presentableParts;
        LayoutPart[] parts = this.getChildren();
        if (parts.length < 1) {
            this.setSelection(null);
            return;
        }
        PartPane selPart = null;
        int topIndex = 0;
        WorkbenchPage page = this.getPage();
        if (page != null) {
            IWorkbenchPartReference[] sortedPartsArray = page.getSortedParts();
            List<IWorkbenchPartReference> sortedParts = Arrays.asList(sortedPartsArray);
            int i = 0;
            while (i < parts.length) {
                IWorkbenchPartReference part;
                int index;
                if (parts[i] instanceof PartPane && (index = sortedParts.indexOf(part = ((PartPane)parts[i]).getPartReference())) >= topIndex) {
                    topIndex = index;
                    selPart = (PartPane)parts[i];
                }
                ++i;
            }
        }
        if (selPart == null && (presentableParts = this.getPresentableParts()).size() != 0) {
            IPresentablePart part = (IPresentablePart)this.getPresentableParts().get(0);
            selPart = (PartPane)this.getPaneFor(part);
        }
        this.setSelection(selPart);
    }

    public void showSystemMenu() {
        this.getPresentation().showSystemMenu();
    }

    public void showPaneMenu() {
        this.getPresentation().showPaneMenu();
    }

    public void showPartList() {
        this.getPresentation().showPartList();
    }

    public Control[] getTabList(LayoutPart part) {
        if (part != null) {
            IPresentablePart presentablePart = part.getPresentablePart();
            StackPresentation presentation = this.getPresentation();
            if (presentablePart != null && presentation != null) {
                return presentation.getTabList(presentablePart);
            }
        }
        return new Control[0];
    }

    public IMemento getSavedPresentationState() {
        return this.savedPresentationState;
    }
}

