/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.OptionalFeatureOperation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IConfigFeatureOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class ConfigOperation
extends OptionalFeatureOperation
implements IConfigFeatureOperation {
    boolean bBatchConfigOperation = false;

    public ConfigOperation(IConfiguredSite site, IFeature feature) {
        this(site, feature, null, null);
    }

    public ConfigOperation(IConfiguredSite site, IFeature feature, IFeatureReference[] optionalFeatures, IFeature[] unconfiguredOptionalElements) {
        super(site, feature);
        IFeature[] installed = UpdateUtils.getInstalledFeatures(feature);
        if (installed.length > 0) {
            this.oldFeature = installed[0];
        }
        this.unconfiguredOptionalFeatures = unconfiguredOptionalElements;
        this.optionalFeatures = optionalFeatures;
    }

    public boolean execute(IProgressMonitor pm, IOperationListener listener) throws CoreException {
        IStatus status;
        if (!this.bBatchConfigOperation && (status = OperationsManager.getValidator().validatePendingConfig(this.feature)) != null && status.getCode() == 4) {
            throw new CoreException(status);
        }
        if (this.isManagedOnly()) {
            this.setOptionalFeatures();
        }
        if (this.oldFeature != null && this.isManagedOnly()) {
            IInstallConfiguration config;
            this.preserveOptionalState();
            boolean oldSuccess = ConfigOperation.unconfigure(this.oldFeature, null);
            if (!oldSuccess && !UpdateUtils.isNestedChild(config = SiteManager.getLocalSite().getCurrentConfiguration(), this.oldFeature)) {
                String message = NLS.bind((String)Messages.OperationsManager_error_old, (Object[])new String[]{this.oldFeature.getLabel()});
                Status status2 = new Status(4, UpdateUtils.getPluginId(), 0, message, null);
                throw new CoreException((IStatus)status2);
            }
        }
        this.targetSite.configure(this.feature, this.optionalFeatures, pm);
        try {
            boolean restartNeeded = false;
            IFeatureOperation pendingOperation = OperationsManager.findPendingOperation(this.feature);
            if (pendingOperation instanceof IUnconfigFeatureOperation) {
                OperationsManager.removePendingOperation(pendingOperation);
            } else {
                OperationsManager.addPendingOperation(this);
            }
            this.markProcessed();
            if (listener != null) {
                listener.afterExecute(this, null);
            }
            if (!this.bBatchConfigOperation) {
                restartNeeded = SiteManager.getLocalSite().save() && restartNeeded;
            }
            OperationsManager.fireObjectChanged(this.feature, null);
            return restartNeeded;
        }
        catch (CoreException e) {
            this.undo();
            UpdateUtils.logException(e);
            throw e;
        }
    }

    void setBatchConfigOperation() {
        this.bBatchConfigOperation = true;
    }

    public void undo() throws CoreException {
        this.targetSite.unconfigure(this.feature);
    }
}

