/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.jaxp.implForCore;

import java.io.IOException;
import org.eclipse.ercp.xml.parser.AbstractSAXParserImpl;
import org.eclipse.ercp.xml.parser.AttributesImpl;
import org.eclipse.ercp.xml.parser.NSDeclaration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXParserImpl
extends AbstractSAXParserImpl
implements XMLReader {
    private ContentHandler contentHandler = NullContentHandler;
    private ErrorHandler errorHandler = null;
    private LexicalHandler lexicalHandler;
    private static final ContentHandler NullContentHandler = new ContentHandler(){

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }
    };

    protected void fatalError(String string, String string2) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(SAXParserImpl.errorMsg(string, string2), this);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    protected void warning(String string, String string2) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(new SAXParseException(SAXParserImpl.errorMsg(string, string2), this));
        }
    }

    protected boolean canDoStringInterning() {
        return false;
    }

    protected void endPrefixMapping(NSDeclaration nSDeclaration) throws SAXException {
        String[][] stringArray = nSDeclaration.getDeclarations();
        if (stringArray == null) {
            return;
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.contentHandler.endPrefixMapping(stringArray[n2][0]);
            ++n2;
        }
    }

    protected void startPrefixMapping(String string, String string2) throws SAXException {
        this.currentNSDecl.addDeclaration(string, string2);
        this.contentHandler.startPrefixMapping(this.fStringInterning ? string.intern() : string, string2);
    }

    protected void characters(char[] cArray, int n, int n2) throws SAXException {
        this.contentHandler.characters(cArray, n, n2);
    }

    protected void startElement(String string, String string2, String string3, AttributesImpl attributesImpl) throws SAXException {
        this.contentHandler.startElement(this.currentNSDecl.getUriFor(string2), this.fStringInterning ? string3.intern() : string3, this.fStringInterning ? string.intern() : string, attributesImpl);
    }

    protected void endElement(String string, String string2, String string3) throws SAXException {
        this.contentHandler.endElement(this.currentNSDecl.getUriFor(string2), this.fStringInterning ? string3.intern() : string3, this.fStringInterning ? string.intern() : string);
    }

    protected void processingInstruction(String string, String string2) throws SAXException {
        this.contentHandler.processingInstruction(string, string2);
    }

    protected void startDocument() throws SAXException {
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
    }

    protected void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    public void parse(InputSource inputSource, DefaultHandler defaultHandler) throws SAXException, IOException {
        this.setFeature("http://xml.org/sax/features/namespaces", this.isNamespaceAware());
        this.setContentHandler(defaultHandler);
        this.setErrorHandler(defaultHandler);
        this.setDTDHandler(defaultHandler);
        this.setEntityResolver(defaultHandler);
        this.parse(inputSource);
    }

    public XMLReader getXMLReader() throws SAXException {
        return this;
    }

    public Parser getParser() throws SAXException {
        throw new SAXNotSupportedException("org.xml.sax.Parser");
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler != null ? contentHandler : NullContentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler == NullContentHandler ? null : this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    protected void setLexicalHandler(Object object) {
        this.lexicalHandler = (LexicalHandler)object;
    }

    protected Object getRecognizedXmlOrgProperty(String string) throws SAXNotSupportedException {
        if ("lexical-handler".equals(string)) {
            return this.lexicalHandler;
        }
        return super.getRecognizedXmlOrgProperty(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setRecognizedXmlOrgProperty(String string, Object object) throws SAXNotSupportedException {
        if ("lexical-handler".equals(string)) {
            if (!(object instanceof LexicalHandler)) throw new SAXNotSupportedException(string);
            this.lexicalHandler = (LexicalHandler)object;
            return;
        } else {
            super.setRecognizedXmlOrgProperty(string, object);
        }
    }

    protected Object getLexicalHandler() {
        return this.lexicalHandler;
    }

    protected void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    protected void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }
}

