/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

final class DerivedImageDescriptor
extends ImageDescriptor {
    private ImageDescriptor original;
    private int flags;

    public DerivedImageDescriptor(ImageDescriptor imageDescriptor, int n) {
        this.original = imageDescriptor;
        this.flags = n;
    }

    public Object createResource(Device device) throws DeviceResourceException {
        try {
            return this.internalCreateImage(device);
        }
        catch (SWTException sWTException) {
            throw new DeviceResourceException(this, (Throwable)sWTException);
        }
    }

    public Image createImage(Device device) {
        return this.internalCreateImage(device);
    }

    public int hashCode() {
        return this.original.hashCode() + this.flags;
    }

    public boolean equals(Object object) {
        if (object instanceof DerivedImageDescriptor) {
            DerivedImageDescriptor derivedImageDescriptor = (DerivedImageDescriptor)object;
            return derivedImageDescriptor.original == this.original && this.flags == derivedImageDescriptor.flags;
        }
        return false;
    }

    private final Image internalCreateImage(Device device) {
        Image image = this.original.createImage(device);
        Image image2 = new Image(device, image.getImageData());
        this.original.destroyResource(image);
        return image2;
    }

    public ImageData getImageData() {
        Image image = this.internalCreateImage((Device)Display.getCurrent());
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }
}

