/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.util.BookmarkSite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BookmarkUtil {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public static void load(String string, Vector vector) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (vector == null) {
            vector = new Vector();
        } else {
            vector.removeAllElements();
        }
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            BookmarkUtil.processRoot(element, vector);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            UpdateCore.log((Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            UpdateCore.log((Throwable)sAXException);
        }
        catch (IOException iOException) {
            UpdateCore.log((Throwable)iOException);
        }
    }

    private static void processRoot(Node node, Vector vector) {
        if ("bookmarks".equals(node.getNodeName())) {
            NodeList nodeList = node.getChildNodes();
            BookmarkUtil.processChildren(nodeList, null, vector);
        }
    }

    private static void processChildren(NodeList nodeList, Object object, Vector vector) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            BookmarkSite bookmarkSite = null;
            if (node.getNodeType() == 1) {
                if ("site".equals(node.getNodeName())) {
                    bookmarkSite = new BookmarkSite(BookmarkUtil.getAttribute(node, "name"), BookmarkUtil.getAttribute(node, "url"), "true".equals(BookmarkUtil.getAttribute(node, "web")), "true".equals(BookmarkUtil.getAttribute(node, "selected")), "true".equals(BookmarkUtil.getAttribute(node, "local")), BookmarkUtil.readDescription(node));
                } else if ("folder".equals(node.getNodeName())) {
                    System.out.println("!!! Warning. Got a folder node." + node.getLocalName());
                }
            }
            if (bookmarkSite != null && object == null) {
                vector.add(bookmarkSite);
            }
            ++n;
        }
    }

    private static String readDescription(Node node) {
        String string = "";
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() == 1 && "description".equals(node2.getNodeName())) {
                NodeList nodeList2 = node2.getChildNodes();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Node node3 = nodeList2.item(n2);
                    if (node3.getNodeType() == 3) {
                        string = String.valueOf(string) + node3.getNodeValue();
                    }
                    ++n2;
                }
                break;
            }
            ++n;
        }
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void store(String string, Vector vector) {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        PrintWriter printWriter = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(string);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
                printWriter = new PrintWriter(outputStreamWriter);
                printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                printWriter.println("<bookmarks>");
                int n = 0;
                while (true) {
                    if (n >= vector.size()) {
                        printWriter.println("</bookmarks>");
                        printWriter.flush();
                        printWriter.close();
                    }
                    Object e = vector.get(n);
                    BookmarkUtil.writeObject("   ", e, printWriter);
                    ++n;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (outputStreamWriter != null) {
            outputStreamWriter.close();
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (fileOutputStream == null) return;
        fileOutputStream.close();
    }

    private static void writeObject(String string, Object object, PrintWriter printWriter) {
        if (object instanceof BookmarkSite) {
            BookmarkSite bookmarkSite = (BookmarkSite)object;
            String string2 = bookmarkSite.getName();
            String string3 = bookmarkSite.getURL().toString();
            String string4 = bookmarkSite.getWeb() ? "true" : "false";
            String string5 = bookmarkSite.getSelected() ? "true" : "false";
            String string6 = bookmarkSite.getLocal() ? "true" : "false";
            printWriter.print(String.valueOf(string) + "<site name=\"" + UpdateManagerUtils.getWritableXMLString((String)string2) + "\" url=\"" + string3 + "\" web=\"" + string4 + "\" selected=\"" + string5 + "\" local=\"" + string6 + "\"");
            if (bookmarkSite.getDescription() != null) {
                printWriter.println(">");
                if (bookmarkSite.getDescription() != null) {
                    printWriter.print(String.valueOf(string) + "  <description>");
                    printWriter.print(UpdateManagerUtils.getWritableXMLString((String)bookmarkSite.getDescription()));
                    printWriter.println("</description>");
                }
                printWriter.println(String.valueOf(string) + "</site>");
            } else {
                printWriter.println("/>");
            }
        }
    }

    private static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return "";
    }

    public static int searchByName(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            BookmarkSite bookmarkSite = (BookmarkSite)vector.elementAt(n);
            if (string.equals(bookmarkSite.getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

