/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.DefaultSiteParser;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.SiteURLFactory;
import org.eclipse.update.internal.model.ConfiguredSiteModel;

public class SiteModel
extends ModelObject {
    private String type;
    private URLEntryModel description;
    private List featureReferences;
    private List archiveReferences;
    private Set categories;
    private List mirrors;
    private String locationURLString;
    private URL locationURL;
    private String mirrorsURLString;
    private ConfiguredSiteModel configuredSiteModel;

    public String getType() {
        return this.type;
    }

    public URLEntryModel getDescriptionModel() {
        return this.description;
    }

    public SiteFeatureReferenceModel[] getFeatureReferenceModels() {
        if (this.featureReferences == null || this.featureReferences.size() == 0) {
            return new SiteFeatureReferenceModel[0];
        }
        return (SiteFeatureReferenceModel[])this.featureReferences.toArray(this.arrayTypeFor(this.featureReferences));
    }

    public ArchiveReferenceModel[] getArchiveReferenceModels() {
        if (this.archiveReferences == null || this.archiveReferences.size() == 0) {
            return new ArchiveReferenceModel[0];
        }
        return (ArchiveReferenceModel[])this.archiveReferences.toArray(this.arrayTypeFor(this.archiveReferences));
    }

    public CategoryModel[] getCategoryModels() {
        if (this.categories == null || this.categories.size() == 0) {
            return new CategoryModel[0];
        }
        return (CategoryModel[])this.categories.toArray(this.arrayTypeFor(this.categories));
    }

    public String getLocationURLString() {
        return this.locationURLString;
    }

    public URL getLocationURL() {
        return this.locationURL;
    }

    public void setType(String string) {
        this.assertIsWriteable();
        this.type = string;
    }

    public void setDescriptionModel(URLEntryModel uRLEntryModel) {
        this.assertIsWriteable();
        this.description = uRLEntryModel;
    }

    public void setFeatureReferenceModels(FeatureReferenceModel[] featureReferenceModelArray) {
        this.assertIsWriteable();
        this.featureReferences = featureReferenceModelArray == null ? null : new ArrayList<FeatureReferenceModel>(Arrays.asList(featureReferenceModelArray));
    }

    public void setArchiveReferenceModels(ArchiveReferenceModel[] archiveReferenceModelArray) {
        this.assertIsWriteable();
        this.archiveReferences = archiveReferenceModelArray == null ? null : new ArrayList<ArchiveReferenceModel>(Arrays.asList(archiveReferenceModelArray));
    }

    public void setCategoryModels(CategoryModel[] categoryModelArray) {
        this.assertIsWriteable();
        if (categoryModelArray == null) {
            this.categories = null;
        } else {
            this.categories = new TreeSet(CategoryModel.getComparator());
            this.categories.addAll(Arrays.asList(categoryModelArray));
        }
    }

    public void setLocationURLString(String string) {
        this.assertIsWriteable();
        this.locationURLString = string;
    }

    public void addFeatureReferenceModel(SiteFeatureReferenceModel siteFeatureReferenceModel) {
        this.assertIsWriteable();
        if (this.featureReferences == null) {
            this.featureReferences = new ArrayList();
        }
        this.featureReferences.add(siteFeatureReferenceModel);
    }

    public void addArchiveReferenceModel(ArchiveReferenceModel archiveReferenceModel) {
        this.assertIsWriteable();
        if (this.archiveReferences == null) {
            this.archiveReferences = new ArrayList();
        }
        if (!this.archiveReferences.contains((Object)archiveReferenceModel)) {
            this.archiveReferences.add(archiveReferenceModel);
        }
    }

    public void addCategoryModel(CategoryModel categoryModel) {
        this.assertIsWriteable();
        if (this.categories == null) {
            this.categories = new TreeSet(CategoryModel.getComparator());
        }
        if (!this.categories.contains((Object)categoryModel)) {
            this.categories.add(categoryModel);
        }
    }

    public void addMirrorModel(URLEntryModel uRLEntryModel) {
        this.assertIsWriteable();
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        if (!this.mirrors.contains((Object)uRLEntryModel)) {
            this.mirrors.add(uRLEntryModel);
        }
    }

    public void removeFeatureReferenceModel(FeatureReferenceModel featureReferenceModel) {
        this.assertIsWriteable();
        if (this.featureReferences != null) {
            this.featureReferences.remove((Object)featureReferenceModel);
        }
    }

    public void removeArchiveReferenceModel(ArchiveReferenceModel archiveReferenceModel) {
        this.assertIsWriteable();
        if (this.archiveReferences != null) {
            this.archiveReferences.remove((Object)archiveReferenceModel);
        }
    }

    public void removeCategoryModel(CategoryModel categoryModel) {
        this.assertIsWriteable();
        if (this.categories != null) {
            this.categories.remove((Object)categoryModel);
        }
    }

    public void removeMirror(URLEntryModel uRLEntryModel) {
        this.assertIsWriteable();
        if (this.mirrors != null) {
            this.mirrors.remove((Object)uRLEntryModel);
        }
    }

    public void markReadOnly() {
        super.markReadOnly();
        this.markReferenceReadOnly(this.getDescriptionModel());
        this.markListReferenceReadOnly(this.getFeatureReferenceModels());
        this.markListReferenceReadOnly(this.getArchiveReferenceModels());
        this.markListReferenceReadOnly(this.getCategoryModels());
    }

    public void resolve(URL uRL, URL uRL2) throws MalformedURLException {
        this.locationURL = this.resolveURL(uRL, uRL2, this.getLocationURLString());
        if (this.locationURL == null) {
            this.locationURL = uRL;
        }
        this.resolveListReference(this.getFeatureReferenceModels(), this.locationURL, uRL2);
        this.resolveListReference(this.getArchiveReferenceModels(), this.locationURL, uRL2);
        this.resolveReference(this.getDescriptionModel(), uRL, uRL2);
        this.resolveListReference(this.getCategoryModels(), uRL, uRL2);
        URL uRL3 = this.resolveURL(uRL, uRL2, this.mirrorsURLString);
        if (uRL3 != null) {
            this.mirrorsURLString = uRL3.toString();
        }
    }

    public ConfiguredSiteModel getConfiguredSiteModel() {
        return this.configuredSiteModel;
    }

    public void setConfiguredSiteModel(ConfiguredSiteModel configuredSiteModel) {
        this.configuredSiteModel = configuredSiteModel;
    }

    protected String getPropertyName() {
        return "site";
    }

    public URLEntryModel[] getMirrorSiteEntryModels() {
        if ((this.mirrors == null || this.mirrors.size() == 0) && this.mirrorsURLString != null) {
            this.doSetMirrorSiteEntryModels(DefaultSiteParser.getMirrors(this.mirrorsURLString, new SiteURLFactory()));
        }
        if (this.mirrors == null || this.mirrors.size() == 0) {
            return new URLEntryModel[0];
        }
        return (URLEntryModel[])this.mirrors.toArray(this.arrayTypeFor(this.mirrors));
    }

    public void setMirrorSiteEntryModels(URLEntryModel[] uRLEntryModelArray) {
        this.assertIsWriteable();
        this.doSetMirrorSiteEntryModels(uRLEntryModelArray);
    }

    private void doSetMirrorSiteEntryModels(URLEntryModel[] uRLEntryModelArray) {
        this.mirrors = uRLEntryModelArray == null || uRLEntryModelArray.length == 0 ? null : new ArrayList<URLEntryModel>(Arrays.asList(uRLEntryModelArray));
    }

    public void setMirrorsURLString(String string) {
        this.assertIsWriteable();
        this.mirrorsURLString = string;
    }
}

