/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

class RGBColorDescriptor
extends ColorDescriptor {
    private RGB color;
    private Color originalColor = null;
    private Device originalDevice = null;

    public RGBColorDescriptor(RGB rGB) {
        this.color = rGB;
    }

    public RGBColorDescriptor(Color color, Device device) {
        this(color.getRGB());
        this.originalColor = color;
        this.originalDevice = device;
    }

    public RGBColorDescriptor(Color color) {
        this(color.getRGB());
        this.originalColor = color;
    }

    public boolean equals(Object object) {
        if (object instanceof RGBColorDescriptor) {
            RGBColorDescriptor rGBColorDescriptor = (RGBColorDescriptor)object;
            return rGBColorDescriptor.color.equals((Object)this.color) && rGBColorDescriptor.originalColor == this.originalColor;
        }
        return false;
    }

    public int hashCode() {
        return this.color.hashCode();
    }

    public Color createColor(Device device) {
        if (this.originalColor != null) {
            if (this.originalDevice == null) {
                Color color = new Color(device, this.color);
                if (color.equals((Object)this.originalColor)) {
                    color.dispose();
                    this.originalDevice = device;
                    return this.originalColor;
                }
                return color;
            }
            if (this.originalDevice == device) {
                return this.originalColor;
            }
        }
        return new Color(device, this.color);
    }

    public void destroyColor(Color color) {
        if (color == this.originalColor) {
            return;
        }
        color.dispose();
    }
}

