/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class HandlerActivation
implements IHandlerActivation {
    private final String commandId;
    private EvaluationResult evaluationResult = null;
    private final Expression expression;
    private final IHandler handler;
    private final IHandlerService handlerService;
    private final int sourcePriority;

    public HandlerActivation(String string, IHandler iHandler, Expression expression, int n, IHandlerService iHandlerService) {
        if (string == null) {
            throw new NullPointerException("The command identifier for a handler activation cannot be null");
        }
        if (iHandlerService == null) {
            throw new NullPointerException("The handler service for an activation cannot be null");
        }
        this.commandId = string;
        this.handler = iHandler;
        this.expression = expression;
        this.sourcePriority = n;
        this.handlerService = iHandlerService;
    }

    public final void clearActive() {
        this.evaluationResult = null;
    }

    public final String getCommandId() {
        return this.commandId;
    }

    public final IHandler getHandler() {
        return this.handler;
    }

    public final IHandlerService getHandlerService() {
        return this.handlerService;
    }

    public final int getSourcePriority() {
        return this.sourcePriority;
    }

    public final boolean isActive(IEvaluationContext iEvaluationContext) {
        if (this.expression == null) {
            return true;
        }
        if (this.evaluationResult == null) {
            try {
                this.evaluationResult = this.expression.evaluate(iEvaluationContext);
            }
            catch (CoreException coreException) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, coreException.getMessage(), (Throwable)coreException);
                WorkbenchPlugin.log("Could not evaluate an expression", (IStatus)status);
                return false;
            }
        }
        return this.evaluationResult == EvaluationResult.TRUE;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HandlerActivation(commandId=");
        stringBuffer.append(this.commandId);
        stringBuffer.append(",handler=");
        stringBuffer.append(this.handler);
        stringBuffer.append(",expression=");
        stringBuffer.append(this.expression);
        stringBuffer.append(",sourcePriority=");
        stringBuffer.append(this.sourcePriority);
        stringBuffer.append(",evaluationResult=");
        stringBuffer.append(this.evaluationResult);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

