/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.util.TreeSet;
import org.eclipse.core.internal.preferences.OSGiPreferencesServiceImpl;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class OSGiPreferencesServiceManager
implements ServiceFactory,
BundleListener {
    private static final String ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI = "org.eclipse.core.internal.preferences.osgi";
    private Preferences prefBundles;

    public OSGiPreferencesServiceManager(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
        this.prefBundles = new ConfigurationScope().getNode(ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI);
        try {
            Bundle[] bundleArray = bundleContext.getBundles();
            TreeSet<String> treeSet = new TreeSet<String>();
            int n = 0;
            while (n < bundleArray.length) {
                treeSet.add(this.getQualifier(bundleArray[n]));
                ++n;
            }
            String[] stringArray = this.prefBundles.keys();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!treeSet.contains(stringArray[n2])) {
                    this.removePrefs(stringArray[n2]);
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        String string = this.getQualifier(bundle);
        Preferences preferences = this.getBundlesNode();
        preferences.put(string, "");
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        return new OSGiPreferencesServiceImpl(new ConfigurationScope().getNode(this.getQualifier(bundle)));
    }

    private String getQualifier(Bundle bundle) {
        String string = "org.eclipse.core.runtime.preferences.OSGiPreferences." + bundle.getBundleId();
        return string;
    }

    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object object) {
        try {
            new ConfigurationScope().getNode(this.getQualifier(bundle)).flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() == 16) {
            try {
                this.removePrefs(this.getQualifier(bundleEvent.getBundle()));
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    protected void removePrefs(String string) throws BackingStoreException {
        new ConfigurationScope().getNode(string).removeNode();
        Preferences preferences = this.getBundlesNode();
        preferences.remove(string);
        preferences.flush();
    }

    private Preferences getBundlesNode() {
        try {
            if (this.prefBundles == null || !this.prefBundles.nodeExists("")) {
                this.prefBundles = new ConfigurationScope().getNode(ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI);
            }
            return this.prefBundles;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }
}

