/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.internal.adaptor.ClasspathManifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.internal.baseadaptor.BaseClassLoadingHook;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;

public class EclipseClassLoadingHook
implements ClassLoadingHook,
HookConfigurator {
    private static String[] NL_JAR_VARIANTS = EclipseClassLoadingHook.buildNLJarVariants(EclipseEnvironmentInfo.getDefault().getNL());
    private static boolean DEFINE_PACKAGES;
    private static String[] LIB_VARIANTS;
    private Object pkgLock = new Object();

    static {
        LIB_VARIANTS = EclipseClassLoadingHook.buildLibraryVariants();
        try {
            Class.forName("java.lang.Package");
            DEFINE_PACKAGES = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            DEFINE_PACKAGES = false;
        }
    }

    private static String[] buildLibraryVariants() {
        ArrayList<String> arrayList = new ArrayList<String>();
        EclipseEnvironmentInfo eclipseEnvironmentInfo = EclipseEnvironmentInfo.getDefault();
        arrayList.add("ws/" + eclipseEnvironmentInfo.getWS() + "/");
        arrayList.add("os/" + eclipseEnvironmentInfo.getOS() + "/" + eclipseEnvironmentInfo.getOSArch() + "/");
        arrayList.add("os/" + eclipseEnvironmentInfo.getOS() + "/");
        String string = eclipseEnvironmentInfo.getNL();
        string = string.replace('_', '/');
        while (string.length() > 0) {
            arrayList.add("nl/" + string + "/");
            int n = string.lastIndexOf(47);
            String string2 = string = n < 0 ? "" : string.substring(0, n);
        }
        arrayList.add("");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] processClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        Object object;
        Manifest manifest;
        Object object2;
        if (!DEFINE_PACKAGES) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        Object object3 = this.pkgLock;
        synchronized (object3) {
            object2 = classpathManager.getBaseClassLoader().publicGetPackage(string2);
            if (object2 != null) {
                return null;
            }
        }
        object3 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        ClasspathManifest classpathManifest = (ClasspathManifest)classpathEntry.getUserObject(ClasspathManifest.KEY);
        if (classpathManifest == null) {
            classpathManifest = new ClasspathManifest();
            classpathEntry.addUserObject(classpathManifest);
        }
        if ((manifest = classpathManifest.getManifest(classpathEntry, classpathManager)) != null) {
            object = manifest.getMainAttributes();
            String string8 = String.valueOf(string2.replace('.', '/')) + '/';
            Object object4 = manifest.getAttributes(string8);
            boolean bl = false;
            if (object4 == null) {
                bl = true;
                object4 = object;
            }
            if ((object3 = ((Attributes)object4).getValue(Attributes.Name.SPECIFICATION_TITLE)) == null && !bl) {
                object3 = ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if ((string3 = ((Attributes)object4).getValue(Attributes.Name.SPECIFICATION_VERSION)) == null && !bl) {
                string3 = ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if ((string4 = ((Attributes)object4).getValue(Attributes.Name.SPECIFICATION_VENDOR)) == null && !bl) {
                string4 = ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if ((string5 = ((Attributes)object4).getValue(Attributes.Name.IMPLEMENTATION_TITLE)) == null && !bl) {
                string5 = ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if ((string6 = ((Attributes)object4).getValue(Attributes.Name.IMPLEMENTATION_VERSION)) == null && !bl) {
                string6 = ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if ((string7 = ((Attributes)object4).getValue(Attributes.Name.IMPLEMENTATION_VENDOR)) == null && !bl) {
                string7 = ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
        }
        object = this.pkgLock;
        synchronized (object) {
            object2 = classpathManager.getBaseClassLoader().publicGetPackage(string2);
            if (object2 != null) {
                return null;
            }
            classpathManager.getBaseClassLoader().publicDefinePackage(string2, (String)object3, string3, string4, string5, string6, string7, null);
            return null;
        }
    }

    public boolean addClassPathEntry(ArrayList arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        ClasspathEntry classpathEntry;
        String string2 = EclipseClassLoadingHook.hasPrefix(string);
        if (string2 != null) {
            return this.addInternalClassPath(string2, arrayList, string, classpathManager, baseData, protectionDomain);
        }
        if (string.startsWith("external:") && (classpathEntry = classpathManager.getExternalClassPath(BaseStorageHook.substituteVars(string = string.substring("external:".length())), baseData, protectionDomain)) != null) {
            arrayList.add(classpathEntry);
            return true;
        }
        return false;
    }

    private boolean addInternalClassPath(String string, ArrayList arrayList, String string2, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        if (string.equals("ws")) {
            return ClasspathManager.addClassPathEntry(arrayList, "ws/" + EclipseEnvironmentInfo.getDefault().getWS() + string2.substring(4), classpathManager, baseData, protectionDomain);
        }
        if (string.equals("os")) {
            return ClasspathManager.addClassPathEntry(arrayList, "os/" + EclipseEnvironmentInfo.getDefault().getOS() + string2.substring(4), classpathManager, baseData, protectionDomain);
        }
        if (string.equals("nl")) {
            string2 = string2.substring(4);
            int n = 0;
            while (n < NL_JAR_VARIANTS.length) {
                if (ClasspathManager.addClassPathEntry(arrayList, "nl/" + NL_JAR_VARIANTS[n] + string2, classpathManager, baseData, protectionDomain)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private static String hasPrefix(String string) {
        if (string.startsWith("$ws$")) {
            return "ws";
        }
        if (string.startsWith("$os$")) {
            return "os";
        }
        if (string.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    private static String[] buildNLJarVariants(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.replace('_', '/');
        while (string.length() > 0) {
            arrayList.add("nl/" + string + "/");
            int n = string.lastIndexOf(47);
            String string2 = string = n < 0 ? "" : string.substring(0, n);
        }
        arrayList.add("");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void recordClassDefine(String string, Class clazz, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
    }

    public String findLibrary(BaseData baseData, String string) {
        String string2;
        String string3;
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) == '/' || string.charAt(0) == '\\') {
            string = string.substring(1);
        }
        if ((string3 = this.searchVariants(baseData, string2 = System.mapLibraryName(string))) != null) {
            return string3;
        }
        String[] stringArray = BaseClassLoadingHook.mapLibraryNames(string2);
        int n = 0;
        while (n < stringArray.length && string3 == null) {
            string3 = this.searchVariants(baseData, stringArray[n]);
            ++n;
        }
        return string3;
    }

    private String searchVariants(BaseData baseData, String string) {
        int n = 0;
        while (n < LIB_VARIANTS.length) {
            BundleFile bundleFile = baseData.getBundleFile();
            BundleEntry bundleEntry = bundleFile.getEntry(String.valueOf(LIB_VARIANTS[n]) + string);
            if (bundleEntry != null) {
                File file = bundleFile.getFile(String.valueOf(LIB_VARIANTS[n]) + string, true);
                if (file == null) {
                    return null;
                }
                if ("hpux".equals(EclipseEnvironmentInfo.getDefault().getOS())) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"chmod", "755", file.getAbsolutePath()}).waitFor();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return file.getAbsolutePath();
            }
            ++n;
        }
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoadingHook(this);
    }

    public BaseClassLoader createClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, BaseData baseData, String[] stringArray) {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData baseData) {
    }
}

