/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.provisional.service.security;

import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEvent;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationListener;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AuthorizationEngine {
    private EventManager manager = new EventManager();
    private EventDispatcher dispatcher = new AuthEventDispatcher();
    private final ServiceTracker listenerTracker;
    static /* synthetic */ Class class$0;

    public AuthorizationEngine(BundleContext bundleContext) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.service.security.AuthorizationListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.listenerTracker.open();
    }

    public final void authorize(SignedContent signedContent, Object object) {
        this.fireEvent(this.doAuthorize(signedContent, object));
    }

    private void fireEvent(AuthorizationEvent authorizationEvent) {
        if (authorizationEvent == null) {
            return;
        }
        Object[] objectArray = this.listenerTracker.getServices();
        if (objectArray == null) {
            return;
        }
        EventListeners eventListeners = new EventListeners();
        int n = 0;
        while (n < objectArray.length) {
            eventListeners.addListener(objectArray[n], null);
            ++n;
        }
        ListenerQueue listenerQueue = new ListenerQueue(this.manager);
        listenerQueue.queueListeners(eventListeners, this.dispatcher);
        listenerQueue.dispatchEventSynchronous(0, authorizationEvent);
    }

    protected abstract AuthorizationEvent doAuthorize(SignedContent var1, Object var2);

    public abstract int getStatus();

    class AuthEventDispatcher
    implements EventDispatcher {
        AuthEventDispatcher() {
        }

        public void dispatchEvent(Object object, Object object2, int n, Object object3) {
            ((AuthorizationListener)object).authorizationEvent((AuthorizationEvent)object3);
        }
    }
}

