/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Assert;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public abstract class ModelObject
extends PlatformObject {
    private boolean readOnly = false;
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static Map bundles;

    protected ModelObject() {
    }

    protected final void assertIsWriteable() {
        Assert.isTrue(!this.isReadOnly(), Messages.ModelObject_ModelReadOnly);
    }

    public void markReadOnly() {
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void markReferenceReadOnly(ModelObject modelObject) {
        if (modelObject == null) {
            return;
        }
        modelObject.markReadOnly();
    }

    protected void markListReferenceReadOnly(ModelObject[] modelObjectArray) {
        if (modelObjectArray == null) {
            return;
        }
        int n = 0;
        while (n < modelObjectArray.length) {
            modelObjectArray[n].markReadOnly();
            ++n;
        }
    }

    public void resolve(URL uRL, URL uRL2) throws MalformedURLException {
    }

    protected void resolveReference(ModelObject modelObject, URL uRL, URL uRL2) throws MalformedURLException {
        if (modelObject == null) {
            return;
        }
        modelObject.resolve(uRL, uRL2);
    }

    protected void resolveListReference(ModelObject[] modelObjectArray, URL uRL, URL uRL2) throws MalformedURLException {
        if (modelObjectArray == null) {
            return;
        }
        int n = 0;
        while (n < modelObjectArray.length) {
            modelObjectArray[n].resolve(uRL, uRL2);
            ++n;
        }
    }

    protected URL resolveURL(URL uRL, URL uRL2, String string) throws MalformedURLException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        String string2 = this.resolveNLString(uRL2, string);
        string2 = this.resolvePlatfromConfiguration(string2);
        if (uRL == null) {
            return new URL(string2);
        }
        return new URL(uRL, string2);
    }

    private String resolvePlatfromConfiguration(String string) {
        int n = string.indexOf("$os$");
        if (n != -1) {
            return this.getExtendedString(string);
        }
        int n2 = string.indexOf("$ws$");
        if (n2 != -1) {
            return this.getExtendedString(string);
        }
        int n3 = string.indexOf("$nl$");
        if (n3 != -1) {
            return this.getExtendedString(string);
        }
        int n4 = string.indexOf("$arch$");
        if (n4 != -1) {
            return this.getExtendedString(string);
        }
        return string;
    }

    private String getExtendedString(String string) {
        Path path = new Path(string);
        path = this.getExpandedPath((IPath)path);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
            UpdateCore.warn("Resolved :" + string + " as:" + path.toOSString());
        }
        return path.toOSString();
    }

    private IPath getExpandedPath(IPath iPath) {
        String string = iPath.segment(0);
        if (string != null) {
            IPath iPath2 = this.getExpandedPath(iPath.removeFirstSegments(1));
            if (string.equals("$ws$")) {
                iPath = new Path(SiteManager.getWS()).append(iPath2);
            } else if (string.equals("$os$")) {
                iPath = new Path(SiteManager.getOS()).append(iPath2);
            } else if (string.equals("$nl$")) {
                iPath = new Path(SiteManager.getNL()).append(iPath2);
            } else if (string.equals("$arch$")) {
                iPath = new Path(SiteManager.getOSArch()).append(iPath2);
            }
        }
        return iPath;
    }

    protected String resolveNLString(URL uRL, String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.equals("")) {
            return string;
        }
        if (!string2.startsWith(KEY_PREFIX)) {
            return string;
        }
        if (string2.startsWith(KEY_DOUBLE_PREFIX)) {
            return string2.substring(1);
        }
        int n = string2.indexOf(" ");
        String string3 = n == -1 ? string2 : string2.substring(0, n);
        String string4 = n == -1 ? string2 : string2.substring(n + 1);
        ResourceBundle resourceBundle = this.getResourceBundle(uRL);
        if (resourceBundle == null) {
            return string4;
        }
        try {
            return resourceBundle.getString(string3.substring(1));
        }
        catch (MissingResourceException missingResourceException) {
            return string4;
        }
    }

    protected Object[] arrayTypeFor(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return (Object[])Array.newInstance(list.get(0).getClass(), 0);
    }

    protected Object[] arrayTypeFor(Set set) {
        if (set == null || set.size() == 0) {
            return null;
        }
        Iterator iterator = set.iterator();
        return (Object[])Array.newInstance(iterator.next().getClass(), 0);
    }

    protected ResourceBundle getResourceBundle(URL uRL) {
        ResourceBundle resourceBundle;
        if (uRL == null) {
            return null;
        }
        if (bundles == null) {
            bundles = new HashMap();
        } else {
            resourceBundle = (ResourceBundle)bundles.get(uRL.toExternalForm());
            if (resourceBundle != null) {
                return resourceBundle;
            }
        }
        resourceBundle = null;
        try {
            uRL = UpdateManagerUtils.asDirectoryURL(uRL);
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, null);
            resourceBundle = ResourceBundle.getBundle(this.getPropertyName(), Locale.getDefault(), uRLClassLoader);
            if (bundles.size() <= 25 || "x86".equals(Platform.getOSArch())) {
                bundles.put(uRL.toExternalForm(), resourceBundle);
            }
        }
        catch (MissingResourceException missingResourceException) {
            UpdateCore.warn(String.valueOf(missingResourceException.getLocalizedMessage()) + ":" + uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            UpdateCore.warn(malformedURLException.getLocalizedMessage());
        }
        return resourceBundle;
    }

    protected String getPropertyName() {
        return "feature";
    }
}

