/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.VersionedIdentifiersFilter;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class UpdateCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private UpdateSearchRequest searchRequest;
    private UpdateSearchResultCollector collector;
    private String featureId;
    private IFeature currentFeature;

    public UpdateCommand(String string, String string2) throws Exception {
        this(string, null, string2);
    }

    public UpdateCommand(String string, String string2, String string3) throws Exception {
        super(string3);
        try {
            this.featureId = string;
            if (string != null) {
                this.targetSite = UpdateUtils.getSiteWithFeature(this.getConfiguration(), string);
                if (this.targetSite == null) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noConfigSiteForFeature, (Object[])new String[]{string}));
                }
                IFeature[] iFeatureArray = UpdateUtils.searchSite(string, this.targetSite, true);
                if (iFeatureArray == null || iFeatureArray.length == 0) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noFeatures3, (Object[])new String[]{string}));
                }
                this.currentFeature = iFeatureArray[0];
            } else {
                IConfiguredSite[] iConfiguredSiteArray = this.getConfiguration().getConfiguredSites();
                int n = 0;
                while (n < iConfiguredSiteArray.length) {
                    if (iConfiguredSiteArray[n].isProductSite()) {
                        this.targetSite = iConfiguredSiteArray[n];
                        break;
                    }
                    ++n;
                }
            }
            if (this.currentFeature == null) {
                this.searchRequest = UpdateUtils.createNewUpdatesRequest(null);
            } else {
                this.searchRequest = UpdateUtils.createNewUpdatesRequest(new IFeature[]{this.currentFeature});
                if (string2 != null) {
                    this.searchRequest.addFilter(new VersionedIdentifiersFilter(new VersionedIdentifier[]{new VersionedIdentifier(string, string2)}));
                }
            }
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException malformedURLException) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(malformedURLException);
        }
        catch (CoreException coreException) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(coreException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = OperationsManager.getValidator().validatePlatformConfigValid();
        if (iStatus != null) {
            UpdateCore.log(iStatus);
            return false;
        }
        try {
            block13: {
                try {
                    iProgressMonitor.beginTask(Messages.Standalone_updating, 4);
                    this.searchRequest.performSearch(this.collector, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    IInstallFeatureOperation[] iInstallFeatureOperationArray = this.collector.getOperations();
                    if (iInstallFeatureOperationArray == null || iInstallFeatureOperationArray.length == 0) {
                        StandaloneUpdateApplication.exceptionLogged();
                        UpdateCore.log(Utilities.newCoreException(NLS.bind((String)Messages.Standalone_noUpdate, (Object[])new String[]{this.featureId}), null));
                        break block13;
                    }
                    ArrayList arrayList = DuplicateConflictsValidator.computeDuplicateConflicts(iInstallFeatureOperationArray, this.getConfiguration());
                    if (arrayList != null) {
                        StandaloneUpdateApplication.exceptionLogged();
                        UpdateCore.log(Utilities.newCoreException(Messages.Standalone_duplicate, null));
                        break block13;
                    }
                    if (this.isVerifyOnly()) {
                        iStatus = OperationsManager.getValidator().validatePendingChanges(iInstallFeatureOperationArray);
                        if (iStatus != null && iStatus.getCode() == 4) {
                            throw new CoreException(iStatus);
                        }
                    } else {
                        IBatchOperation iBatchOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(iInstallFeatureOperationArray);
                        iBatchOperation.execute((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3), this);
                        System.out.println(NLS.bind((String)Messages.Standalone_featureIsInstalled, (Object[])new String[]{this.featureId}));
                    }
                    Object var7_6 = null;
                    iProgressMonitor.done();
                    return true;
                    catch (Exception exception) {
                        StandaloneUpdateApplication.exceptionLogged();
                        UpdateCore.log(Utilities.newCoreException(NLS.bind((String)Messages.Standalone_noUpdate, (Object[])new String[]{this.featureId}), exception));
                    }
                }
                catch (CoreException coreException) {
                    iStatus = coreException.getStatus();
                    if (iStatus != null && iStatus.getCode() == 42) {
                        System.out.println(Messages.Standalone_connection);
                    }
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(coreException);
                }
            }
            Object var7_5 = null;
            iProgressMonitor.done();
            return false;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature iFeature) {
            IInstallFeatureOperation iInstallFeatureOperation = OperationsManager.getOperationFactory().createInstallOperation(null, iFeature, null, null, null);
            IConfiguredSite iConfiguredSite = UpdateUtils.getDefaultTargetSite(UpdateCommand.this.getConfiguration(), iInstallFeatureOperation);
            if (iConfiguredSite == null) {
                iConfiguredSite = UpdateUtils.getAffinitySite(UpdateCommand.this.getConfiguration(), iFeature);
            }
            if (iConfiguredSite == null) {
                iConfiguredSite = UpdateCommand.this.targetSite;
            }
            iInstallFeatureOperation.setTargetSite(iConfiguredSite);
            this.operations.add(iInstallFeatureOperation);
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] iInstallFeatureOperationArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(iInstallFeatureOperationArray);
            return iInstallFeatureOperationArray;
        }
    }
}

