/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.registry.ViewRegistry;

public class ViewRegistryReader
extends RegistryReader {
    private ViewRegistry viewRegistry;

    protected void readCategory(IConfigurationElement iConfigurationElement) {
        try {
            this.viewRegistry.add(new Category(iConfigurationElement));
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Unable to create view category.", coreException.getStatus());
        }
    }

    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals("view")) {
            this.readView(iConfigurationElement);
            return true;
        }
        if (iConfigurationElement.getName().equals("category")) {
            this.readCategory(iConfigurationElement);
            this.readElementChildren(iConfigurationElement);
            return true;
        }
        return false;
    }

    protected void readView(IConfigurationElement iConfigurationElement) {
        try {
            this.viewRegistry.add(new ViewDescriptor(iConfigurationElement));
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Unable to create view descriptor.", coreException.getStatus());
        }
    }

    public void readViews(IExtensionRegistry iExtensionRegistry, ViewRegistry viewRegistry) {
        this.viewRegistry = viewRegistry;
        this.readRegistry(iExtensionRegistry, "org.eclipse.ui", "views");
    }
}

