/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.commands.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class Util {
    public static final SortedMap EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    public static final SortedSet EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    public static final String ZERO_LENGTH_STRING = "";

    public static final void assertInstance(Object object, Class clazz, boolean bl) {
        if (object == null && bl) {
            return;
        }
        if (object == null || clazz == null) {
            throw new NullPointerException();
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException();
        }
    }

    public static final int compare(boolean bl, boolean bl2) {
        return !bl ? (bl2 ? -1 : 0) : (bl2 ? 0 : 1);
    }

    public static final int compare(Comparable comparable, Comparable comparable2) {
        if (comparable == null && comparable2 == null) {
            return 0;
        }
        if (comparable == null) {
            return -1;
        }
        if (comparable2 == null) {
            return 1;
        }
        return comparable.compareTo(comparable2);
    }

    public static final int compare(int n, int n2) {
        return n - n2;
    }

    public static final int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return object.toString().compareTo(object2.toString());
    }

    public static final boolean equals(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    public static final boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object2 != null && object.equals(object2);
    }

    public static final boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            boolean bl;
            Object object = objectArray[n];
            Object object2 = objectArray2[n];
            boolean bl2 = object == null ? object2 == null : (bl = object.equals(object2));
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static final int hashCode(int n) {
        return n;
    }

    public static final int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static final Map safeCopy(Map map, Class clazz, Class clazz2, boolean bl, boolean bl2) {
        if (map == null || clazz == null || clazz2 == null) {
            throw new NullPointerException();
        }
        Map map2 = Collections.unmodifiableMap(new HashMap(map));
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Util.assertInstance(entry.getKey(), clazz, bl);
            Util.assertInstance(entry.getValue(), clazz2, bl2);
        }
        return map;
    }

    public static final Set safeCopy(Set set, Class clazz) {
        return Util.safeCopy(set, clazz, false);
    }

    public static final Set safeCopy(Set set, Class clazz, boolean bl) {
        if (set == null || clazz == null) {
            throw new NullPointerException();
        }
        Set set2 = Collections.unmodifiableSet(new HashSet(set));
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), clazz, bl);
        }
        return set;
    }

    private Util() {
    }
}

