/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.net.URL;
import org.eclipse.jface.resource.DerivedImageDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FileImageDescriptor;
import org.eclipse.jface.resource.ImageDataImageDescriptor;
import org.eclipse.jface.resource.MissingImageDescriptor;
import org.eclipse.jface.resource.URLImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class ImageDescriptor
extends DeviceResourceDescriptor {
    protected static final ImageData DEFAULT_IMAGE_DATA = new ImageData(6, 6, 1, new PaletteData(new RGB[]{new RGB(255, 0, 0)}));

    protected ImageDescriptor() {
    }

    public static ImageDescriptor createFromFile(Class clazz, String string) {
        return new FileImageDescriptor(clazz, string);
    }

    public static ImageDescriptor createFromImageData(ImageData imageData) {
        return new ImageDataImageDescriptor(imageData);
    }

    public static ImageDescriptor createFromImage(Image image) {
        return new ImageDataImageDescriptor(image);
    }

    public static ImageDescriptor createWithFlags(ImageDescriptor imageDescriptor, int n) {
        return new DerivedImageDescriptor(imageDescriptor, n);
    }

    public static ImageDescriptor createFromImage(Image image, Device device) {
        return new ImageDataImageDescriptor(image, device);
    }

    public static ImageDescriptor createFromURL(URL uRL) {
        if (uRL == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return new URLImageDescriptor(uRL);
    }

    public Object createResource(Device device) throws DeviceResourceException {
        Image image = this.createImage(false, device);
        if (image == null) {
            throw new DeviceResourceException(this);
        }
        return image;
    }

    public void destroyResource(Object object) {
        ((Image)object).dispose();
    }

    public Image createImage() {
        return this.createImage(true);
    }

    public Image createImage(boolean bl) {
        return this.createImage(bl, (Device)Display.getCurrent());
    }

    public Image createImage(Device device) {
        return this.createImage(true, device);
    }

    public Image createImage(boolean bl, Device device) {
        ImageData imageData = this.getImageData();
        if (imageData == null) {
            if (!bl) {
                return null;
            }
            imageData = DEFAULT_IMAGE_DATA;
        }
        try {
            return new Image(device, imageData);
        }
        catch (SWTException sWTException) {
            if (bl) {
                try {
                    return new Image(device, DEFAULT_IMAGE_DATA);
                }
                catch (SWTException sWTException2) {
                    return null;
                }
            }
            return null;
        }
    }

    public abstract ImageData getImageData();

    public static ImageDescriptor getMissingImageDescriptor() {
        return MissingImageDescriptor.getInstance();
    }
}

