/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.event.BatchBundleListener;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.FilteredServiceListener;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class BundleContextImpl
implements BundleContext,
EventDispatcher {
    public static final String PROP_SCOPE_SERVICE_EVENTS = "osgi.scopeServiceEvents";
    public static final boolean scopeEvents = Boolean.valueOf(FrameworkProperties.getProperty("osgi.scopeServiceEvents", "true"));
    private volatile boolean valid;
    final BundleHost bundle;
    final Framework framework;
    private HashMap servicesInUse;
    protected EventListeners bundleEvent;
    protected EventListeners bundleEventSync;
    protected EventListeners serviceEvent;
    protected EventListeners frameworkEvent;
    protected BundleActivator activator;
    private final Object contextLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleContextImpl(BundleHost bundle) {
        this.bundle = bundle;
        this.valid = true;
        this.framework = bundle.framework;
        this.bundleEvent = null;
        this.bundleEventSync = null;
        this.serviceEvent = null;
        this.frameworkEvent = null;
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
        this.activator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        int usedSize;
        this.valid = false;
        EventListeners eventListeners = this.framework.serviceEvent;
        synchronized (eventListeners) {
            if (this.serviceEvent != null) {
                this.framework.serviceEvent.removeListener(this);
                this.serviceEvent = null;
            }
        }
        eventListeners = this.framework.frameworkEvent;
        synchronized (eventListeners) {
            if (this.frameworkEvent != null) {
                this.framework.frameworkEvent.removeListener(this);
                this.frameworkEvent = null;
            }
        }
        eventListeners = this.framework.bundleEvent;
        synchronized (eventListeners) {
            if (this.bundleEvent != null) {
                this.framework.bundleEvent.removeListener(this);
                this.bundleEvent = null;
            }
        }
        eventListeners = this.framework.bundleEventSync;
        synchronized (eventListeners) {
            if (this.bundleEventSync != null) {
                this.framework.bundleEventSync.removeListener(this);
                this.bundleEventSync = null;
            }
        }
        ServiceReference[] publishedReferences = null;
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            publishedReferences = this.framework.serviceRegistry.lookupServiceReferences(this);
        }
        if (publishedReferences != null) {
            int i = 0;
            while (i < publishedReferences.length) {
                try {
                    ((ServiceReferenceImpl)publishedReferences[i]).registration.unregister();
                }
                catch (IllegalStateException illegalStateException) {}
                ++i;
            }
        }
        ServiceRegistrationImpl[] usedServices = null;
        Object object = this.contextLock;
        synchronized (object) {
            if (this.servicesInUse == null) {
                return;
            }
            HashMap hashMap = this.servicesInUse;
            synchronized (hashMap) {
                usedSize = this.servicesInUse.size();
                if (usedSize > 0) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println("Releasing services");
                    }
                    usedServices = new ServiceRegistrationImpl[usedSize];
                    Iterator regsIter = this.servicesInUse.keySet().iterator();
                    int i = 0;
                    while (i < usedSize) {
                        usedServices[i] = (ServiceRegistrationImpl)regsIter.next();
                        ++i;
                    }
                }
            }
        }
        int i = 0;
        while (i < usedSize) {
            usedServices[i].releaseService(this);
            ++i;
        }
        Object object2 = this.contextLock;
        synchronized (object2) {
            this.servicesInUse = null;
        }
    }

    public String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return this.framework.getProperty(key);
    }

    public Bundle getBundle() {
        this.checkValid();
        return this.bundle;
    }

    public Bundle installBundle(String location) throws BundleException {
        this.checkValid();
        return this.framework.installBundle(location);
    }

    public Bundle installBundle(String location, InputStream in) throws BundleException {
        this.checkValid();
        return this.framework.installBundle(location, in);
    }

    public Bundle getBundle(long id) {
        return this.framework.getBundle(id);
    }

    public AbstractBundle getBundleByLocation(String location) {
        return this.framework.getBundleByLocation(location);
    }

    public Bundle[] getBundles() {
        return this.framework.getAllBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addServiceListener[" + this.bundle + "](" + listenerName + ", \"" + filter + "\")");
        }
        FilteredServiceListener filteredListener = new FilteredServiceListener(filter, listener, this);
        EventListeners eventListeners = this.framework.serviceEvent;
        synchronized (eventListeners) {
            this.checkValid();
            if (this.serviceEvent == null) {
                this.serviceEvent = new EventListeners();
                this.framework.serviceEvent.addListener(this, this);
            }
            this.serviceEvent.addListener(listener, filteredListener);
        }
    }

    public void addServiceListener(ServiceListener listener) {
        block2: {
            try {
                this.addServiceListener(listener, null);
            }
            catch (InvalidSyntaxException e) {
                if (!Debug.DEBUG_GENERAL) break block2;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener listener) {
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeServiceListener[" + this.bundle + "](" + listenerName + ")");
        }
        EventListeners eventListeners = this.framework.serviceEvent;
        synchronized (eventListeners) {
            if (this.serviceEvent != null) {
                this.serviceEvent.removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleListener(BundleListener listener) {
        EventListeners eventListeners;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (listener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            eventListeners = this.framework.bundleEventSync;
            synchronized (eventListeners) {
                this.checkValid();
                if (this.bundleEventSync == null) {
                    this.bundleEventSync = new EventListeners();
                    this.framework.bundleEventSync.addListener(this, this);
                }
                this.bundleEventSync.addListener(listener, listener);
            }
        }
        eventListeners = this.framework.bundleEvent;
        synchronized (eventListeners) {
            this.checkValid();
            if (this.bundleEvent == null) {
                this.bundleEvent = new EventListeners();
                this.framework.bundleEvent.addListener(this, this);
            }
            this.bundleEvent.addListener(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleListener(BundleListener listener) {
        EventListeners eventListeners;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (listener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            eventListeners = this.framework.bundleEventSync;
            synchronized (eventListeners) {
                if (this.bundleEventSync != null) {
                    this.bundleEventSync.removeListener(listener);
                }
            }
        }
        eventListeners = this.framework.bundleEvent;
        synchronized (eventListeners) {
            if (this.bundleEvent != null) {
                this.bundleEvent.removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        EventListeners eventListeners = this.framework.frameworkEvent;
        synchronized (eventListeners) {
            this.checkValid();
            if (this.frameworkEvent == null) {
                this.frameworkEvent = new EventListeners();
                this.framework.frameworkEvent.addListener(this, this);
            }
            this.frameworkEvent.addListener(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        EventListeners eventListeners = this.framework.frameworkEvent;
        synchronized (eventListeners) {
            if (this.frameworkEvent != null) {
                this.frameworkEvent.removeListener(listener);
            }
        }
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        String invalidService;
        this.checkValid();
        if (service == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is null");
            }
            throw new IllegalArgumentException(Msg.SERVICE_ARGUMENT_NULL_EXCEPTION);
        }
        int size = clazzes.length;
        if (size == 0) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Classes array is empty");
            }
            throw new IllegalArgumentException(Msg.SERVICE_EMPTY_CLASS_LIST_EXCEPTION);
        }
        String[] copy = new String[clazzes.length];
        int i = clazzes.length - 1;
        while (i >= 0) {
            copy[i] = clazzes[i].intern();
            --i;
        }
        clazzes = copy;
        this.framework.checkRegisterServicePermission(clazzes);
        if (!(service instanceof ServiceFactory) && (invalidService = BundleContextImpl.checkServiceClass(clazzes, service)) != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is not an instanceof " + invalidService);
            }
            throw new IllegalArgumentException(NLS.bind(Msg.SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION, invalidService));
        }
        return this.createServiceRegistration(clazzes, service, properties);
    }

    static String checkServiceClass(String[] clazzes, final Object serviceObject) {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return serviceObject.getClass().getClassLoader();
            }
        });
        int i = 0;
        while (i < clazzes.length) {
            block4: {
                try {
                    Class<?> serviceClazz;
                    Class<?> clazz = serviceClazz = cl == null ? Class.forName(clazzes[i]) : cl.loadClass(clazzes[i]);
                    if (!serviceClazz.isInstance(serviceObject)) {
                        return clazzes[i];
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!BundleContextImpl.extensiveCheckServiceClass(clazzes[i], serviceObject.getClass())) break block4;
                    return clazzes[i];
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean extensiveCheckServiceClass(String clazz, Class serviceClazz) {
        if (clazz.equals(serviceClazz.getName())) {
            return false;
        }
        Class<?>[] interfaces = serviceClazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!BundleContextImpl.extensiveCheckServiceClass(clazz, interfaces[i])) {
                return false;
            }
            ++i;
        }
        Class superClazz = serviceClazz.getSuperclass();
        return superClazz == null || BundleContextImpl.extensiveCheckServiceClass(clazz, superClazz);
    }

    protected ServiceRegistrationImpl createServiceRegistration(String[] clazzes, Object service, Dictionary properties) {
        ServiceRegistrationImpl registration = new ServiceRegistrationImpl(this, clazzes, service);
        registration.register(properties);
        return registration;
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        String[] clazzes = new String[]{clazz};
        return this.registerService(clazzes, service, properties);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getServiceReferences(" + clazz + ", \"" + filter + "\")");
        }
        return this.framework.getServiceReferences(clazz, filter, this, false);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getAllServiceReferences(" + clazz + ", \"" + filter + "\")");
        }
        return this.framework.getServiceReferences(clazz, filter, this, true);
    }

    public ServiceReference getServiceReference(String clazz) {
        block12: {
            this.checkValid();
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getServiceReference(" + clazz + ")");
            }
            try {
                ServiceReference[] references = this.framework.getServiceReferences(clazz, null, this, false);
                if (references != null) {
                    int index = 0;
                    int length = references.length;
                    if (length > 1) {
                        int[] rankings = new int[length];
                        int count = 0;
                        int maxRanking = Integer.MIN_VALUE;
                        int i = 0;
                        while (i < length) {
                            int ranking;
                            rankings[i] = ranking = ((ServiceReferenceImpl)references[i]).getRanking();
                            if (ranking > maxRanking) {
                                index = i;
                                maxRanking = ranking;
                                count = 1;
                            } else if (ranking == maxRanking) {
                                ++count;
                            }
                            ++i;
                        }
                        if (count > 1) {
                            long minId = Long.MAX_VALUE;
                            int i2 = 0;
                            while (i2 < length) {
                                long id;
                                if (rankings[i2] == maxRanking && (id = ((ServiceReferenceImpl)references[i2]).getId()) < minId) {
                                    index = i2;
                                    minId = id;
                                }
                                ++i2;
                            }
                        }
                    }
                    return references[index];
                }
            }
            catch (InvalidSyntaxException e) {
                if (!Debug.DEBUG_GENERAL) break block12;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference reference) {
        this.checkValid();
        Object object = this.contextLock;
        synchronized (object) {
            if (this.servicesInUse == null) {
                this.servicesInUse = new HashMap(10);
            }
        }
        ServiceRegistrationImpl registration = ((ServiceReferenceImpl)reference).registration;
        this.framework.checkGetServicePermission(registration.clazzes);
        return registration.getService(this);
    }

    public boolean ungetService(ServiceReference reference) {
        this.checkValid();
        ServiceRegistrationImpl registration = ((ServiceReferenceImpl)reference).registration;
        return registration.ungetService(this);
    }

    public File getDataFile(String filename) {
        this.checkValid();
        return this.framework.getDataFile(this.bundle, filename);
    }

    protected void start() throws BundleException {
        this.activator = this.bundle.loadBundleActivator();
        if (this.activator != null) {
            try {
                this.startActivator(this.activator);
            }
            catch (BundleException be) {
                this.activator = null;
                throw be;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void startActivator(BundleActivator bundleActivator) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 161->165)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stop() throws BundleException {
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (BundleContextImpl.this.activator != null) {
                            BundleContextImpl.this.activator.stop(BundleContextImpl.this);
                        }
                        return null;
                    }
                });
            }
            catch (Throwable t2) {
                Exception t2;
                if (t2 instanceof PrivilegedActionException) {
                    t2 = ((PrivilegedActionException)t2).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(t2);
                }
                String clazz = this.activator == null ? "" : this.activator.getClass().getName();
                throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{clazz, "stop", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()}), t2);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.activator = null;
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.activator = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceReference[] getRegisteredServices() {
        ServiceReference[] services = null;
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            block11: {
                services = this.framework.serviceRegistry.lookupServiceReferences(this);
                if (services != null) break block11;
                return null;
            }
            int removed = 0;
            int i = services.length - 1;
            while (i >= 0) {
                ServiceReferenceImpl ref = (ServiceReferenceImpl)services[i];
                String[] classes = ref.getClasses();
                try {
                    this.framework.checkGetServicePermission(classes);
                }
                catch (SecurityException securityException) {
                    services[i] = null;
                    ++removed;
                }
                --i;
            }
            if (removed > 0) {
                ServiceReference[] temp = services;
                services = new ServiceReference[temp.length - removed];
                int i2 = temp.length - 1;
                while (i2 >= 0) {
                    if (temp[i2] == null) {
                        --removed;
                    } else {
                        services[i2 - removed] = temp[i2];
                    }
                    --i2;
                }
            }
        }
        return services;
    }

    /*
     * Exception decompiling
     */
    protected ServiceReferenceImpl[] getServicesInUse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getServicesInUseMap() {
        Object object = this.contextLock;
        synchronized (object) {
            return this.servicesInUse;
        }
    }

    public void dispatchEvent(Object originalListener, Object l, int action, Object object) {
        block17: {
            BundleHost tmpBundle = this.bundle;
            try {
                if (!this.isValid()) break block17;
                switch (action) {
                    case 1: 
                    case 2: {
                        BundleListener listener = (BundleListener)l;
                        if (Debug.DEBUG_EVENTS) {
                            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
                            Debug.println("dispatchBundleEvent[" + tmpBundle + "](" + listenerName + ")");
                        }
                        BundleEvent event = (BundleEvent)object;
                        switch (event.getType()) {
                            case -2147483647: {
                                if (listener instanceof BatchBundleListener) {
                                    ((BatchBundleListener)listener).batchBegin();
                                    break;
                                }
                                break block17;
                            }
                            case -2147483648: {
                                if (listener instanceof BatchBundleListener) {
                                    ((BatchBundleListener)listener).batchEnd();
                                    break;
                                }
                                break block17;
                            }
                            default: {
                                listener.bundleChanged((BundleEvent)object);
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        ServiceEvent event = (ServiceEvent)object;
                        ServiceListener listener = (ServiceListener)l;
                        if (Debug.DEBUG_EVENTS) {
                            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
                            Debug.println("dispatchServiceEvent[" + tmpBundle + "](" + listenerName + ")");
                        }
                        listener.serviceChanged(event);
                        break;
                    }
                    case 4: {
                        FrameworkListener listener = (FrameworkListener)l;
                        if (Debug.DEBUG_EVENTS) {
                            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
                            Debug.println("dispatchFrameworkEvent[" + tmpBundle + "](" + listenerName + ")");
                        }
                        listener.frameworkEvent((FrameworkEvent)object);
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Throwable t) {
                FrameworkEvent event;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in bottom level event dispatcher: " + t.getMessage());
                    Debug.printStackTrace(t);
                }
                this.framework.adaptor.handleRuntimeError(t);
                if (action == 4 && (event = (FrameworkEvent)object).getType() == 2) break block17;
                this.framework.publishFrameworkEvent(2, tmpBundle, t);
            }
        }
    }

    protected boolean hasListenServicePermission(ServiceEvent event) {
        BundleProtectionDomain domain = this.bundle.getProtectionDomain();
        if (domain != null) {
            ServiceReferenceImpl reference = (ServiceReferenceImpl)event.getServiceReference();
            String[] names = reference.getClasses();
            int len = names.length;
            int i = 0;
            while (i < len) {
                if (domain.implies(new ServicePermission(names[i], "get"))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValid();
        return new FilterImpl(filter);
    }

    protected void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException(Msg.BUNDLE_CONTEXT_INVALID_EXCEPTION);
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    boolean isAssignableTo(ServiceReferenceImpl reference) {
        if (!scopeEvents) {
            return true;
        }
        String[] clazzes = reference.getClasses();
        int i = 0;
        while (i < clazzes.length) {
            if (!reference.isAssignableTo(this.bundle, clazzes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

