/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.ServiceUse;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration {
    private ServiceReferenceImpl reference;
    final Framework framework;
    final BundleContextImpl context;
    final AbstractBundle bundle;
    private ArrayList contextsUsing;
    final String[] clazzes;
    final Object service;
    private Properties properties;
    private long serviceid;
    private int serviceranking;
    private final Object registrationLock = new Object();
    private int state = 0;
    private static final int REGISTERED = 0;
    private static final int UNREGISTERING = 1;
    private static final int UNREGISTERED = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRegistrationImpl(BundleContextImpl context, String[] clazzes, Object service) {
        this.context = context;
        this.bundle = context.bundle;
        this.framework = context.framework;
        this.clazzes = clazzes;
        this.service = service;
        Object object = this.registrationLock;
        synchronized (object) {
            this.contextsUsing = null;
            this.reference = new ServiceReferenceImpl(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Dictionary props) {
        ServiceReferenceImpl ref;
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            this.context.checkValid();
            Object object = this.registrationLock;
            synchronized (object) {
                ref = this.reference;
                this.serviceid = this.framework.getNextServiceId();
                this.properties = this.createProperties(props);
            }
            if (Debug.DEBUG_SERVICES) {
                Debug.println("registerService[" + this.bundle + "](" + this + ")");
            }
            this.framework.serviceRegistry.publishService(this.context, this);
        }
        this.framework.publishServiceEvent(1, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        ServiceReferenceImpl ref;
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            Object object = this.registrationLock;
            synchronized (object) {
                if (this.state != 0) {
                    throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
                }
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("unregisterService[" + this.bundle + "](" + this + ")");
                }
                this.framework.serviceRegistry.unpublishService(this.context, this);
                this.state = 1;
                ref = this.reference;
            }
        }
        this.framework.publishServiceEvent(4, ref);
        int size = 0;
        BundleContextImpl[] users = null;
        Object object = this.registrationLock;
        synchronized (object) {
            this.state = 2;
            if (this.contextsUsing != null && (size = this.contextsUsing.size()) > 0) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("unregisterService: releasing users");
                }
                users = this.contextsUsing.toArray(new BundleContextImpl[size]);
            }
        }
        int i = 0;
        while (i < size) {
            this.releaseService(users[i]);
            ++i;
        }
        Object object2 = this.registrationLock;
        synchronized (object2) {
            this.contextsUsing = null;
            this.reference = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference getReference() {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.reference == null) {
                throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
            }
            return this.reference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary props) {
        ServiceReferenceImpl ref;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
            }
            ref = this.reference;
            this.properties = this.createProperties(props);
        }
        this.framework.publishServiceEvent(2, ref);
    }

    private Properties createProperties(Dictionary props) {
        Properties properties = new Properties(props);
        properties.set("objectClass", this.clazzes, true);
        properties.set("service.id", new Long(this.serviceid), true);
        properties.setReadOnly();
        Object ranking = properties.getProperty("service.ranking");
        this.serviceranking = ranking instanceof Integer ? (Integer)ranking : 0;
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getProperties() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getProperty(String key) {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getPropertyKeys() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getPropertyKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getId() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.serviceid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRanking() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.serviceranking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle getBundle() {
        Object object = this.registrationLock;
        synchronized (object) {
            block4: {
                if (this.reference != null) break block4;
                return null;
            }
            return this.bundle;
        }
    }

    /*
     * Exception decompiling
     */
    protected Object getService(BundleContextImpl user) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean ungetService(BundleContextImpl user) {
        ServiceUse use;
        Map servicesInUse;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state == 2) {
                return false;
            }
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("ungetService[" + user.bundle + "](" + this + ")");
        }
        if ((servicesInUse = user.getServicesInUseMap()) == null) {
            return false;
        }
        Object object2 = servicesInUse;
        synchronized (object2) {
            use = (ServiceUse)servicesInUse.get(this);
            if (use == null) {
                return false;
            }
        }
        object2 = use;
        synchronized (object2) {
            if (!use.ungetService()) return true;
            Map map = servicesInUse;
            synchronized (map) {
                Object object3 = this.registrationLock;
                synchronized (object3) {
                    servicesInUse.remove(this);
                    this.contextsUsing.remove(user);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseService(BundleContextImpl user) {
        ServiceUse use;
        Map servicesInUse;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.reference == null) {
                return;
            }
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("releaseService[" + user.bundle + "](" + this + ")");
        }
        if ((servicesInUse = user.getServicesInUseMap()) == null) {
            return;
        }
        Object object2 = servicesInUse;
        synchronized (object2) {
            Object object3 = this.registrationLock;
            synchronized (object3) {
                use = (ServiceUse)servicesInUse.remove(this);
                if (use == null) {
                    return;
                }
                if (this.contextsUsing != null) {
                    this.contextsUsing.remove(user);
                }
            }
        }
        object2 = use;
        synchronized (object2) {
            use.releaseService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getUsingBundles() {
        Object object = this.registrationLock;
        synchronized (object) {
            int size;
            block9: {
                block8: {
                    block7: {
                        if (this.state != 2) break block7;
                        return null;
                    }
                    if (this.contextsUsing != null) break block8;
                    return null;
                }
                size = this.contextsUsing.size();
                if (size != 0) break block9;
                return null;
            }
            AbstractBundle[] bundles = new AbstractBundle[size];
            int i = 0;
            while (i < size) {
                bundles[i] = ((BundleContextImpl)this.contextsUsing.get((int)i)).bundle;
                ++i;
            }
            return bundles;
        }
    }

    public String toString() {
        String[] clazzes = this.clazzes;
        int size = clazzes.length;
        StringBuffer sb = new StringBuffer(50 * size);
        sb.append('{');
        int i = 0;
        while (i < size) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(clazzes[i]);
            ++i;
        }
        sb.append("}=");
        sb.append(this.getProperties().toString());
        return ((Object)sb).toString();
    }

    static class Properties
    extends Headers {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties(int size, Dictionary props) {
            super(size);
            if (props != null) {
                Dictionary dictionary = props;
                synchronized (dictionary) {
                    Enumeration keysEnum = props.keys();
                    while (keysEnum.hasMoreElements()) {
                        Object key = keysEnum.nextElement();
                        if (!(key instanceof String)) continue;
                        String header = (String)key;
                        this.setProperty(header, props.get(header));
                    }
                }
            }
        }

        protected Properties(Dictionary props) {
            this(props == null ? 2 : props.size() + 2, props);
        }

        protected Object getProperty(String key) {
            return Properties.cloneValue(this.get(key));
        }

        protected synchronized String[] getPropertyKeys() {
            int size = this.size();
            String[] keynames = new String[size];
            Enumeration keysEnum = this.keys();
            int i = 0;
            while (i < size) {
                keynames[i] = (String)keysEnum.nextElement();
                ++i;
            }
            return keynames;
        }

        protected synchronized Object setProperty(String key, Object value) {
            return this.set(key, Properties.cloneValue(value));
        }

        protected static Object cloneValue(Object value) {
            block10: {
                if (value == null) {
                    return null;
                }
                if (value instanceof String) {
                    return value;
                }
                if (value instanceof Number) {
                    return value;
                }
                if (value instanceof Character) {
                    return value;
                }
                if (value instanceof Boolean) {
                    return value;
                }
                Class<?> clazz = value.getClass();
                if (clazz.isArray()) {
                    Class<?> type = clazz.getComponentType();
                    int len = Array.getLength(value);
                    Object clonedArray = Array.newInstance(type, len);
                    System.arraycopy(value, 0, clonedArray, 0, len);
                    return clonedArray;
                }
                try {
                    return clazz.getMethod("clone", null).invoke(value, null);
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    if (value instanceof Vector) {
                        return ((Vector)value).clone();
                    }
                    if (!(value instanceof Hashtable)) break block10;
                    return ((Hashtable)value).clone();
                }
            }
            return value;
        }

        public synchronized String toString() {
            String[] keys = this.getPropertyKeys();
            int size = keys.length;
            StringBuffer sb = new StringBuffer(20 * size);
            sb.append('{');
            int n = 0;
            int i = 0;
            while (i < size) {
                String key = keys[i];
                if (!key.equals("objectClass")) {
                    if (n > 0) {
                        sb.append(", ");
                    }
                    sb.append(key);
                    sb.append('=');
                    Object value = this.get(key);
                    if (value.getClass().isArray()) {
                        sb.append('[');
                        int length = Array.getLength(value);
                        int j = 0;
                        while (j < length) {
                            if (j > 0) {
                                sb.append(',');
                            }
                            sb.append(Array.get(value, j));
                            ++j;
                        }
                        sb.append(']');
                    } else {
                        sb.append(value);
                    }
                    ++n;
                }
                ++i;
            }
            sb.append('}');
            return ((Object)sb).toString();
        }
    }
}

