/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.parser;

import java.util.Hashtable;

public class CharDecoder {
    private Hashtable chars = new Hashtable();

    public String getCharValue(String name) {
        Object value = this.chars.get(name);
        if (value != null) {
            return (String)value;
        }
        try {
            if (name.charAt(0) == '#') {
                if (name.charAt(1) == 'x') {
                    int cValue = Integer.parseInt(name.substring(2), 16);
                    char[] character = new char[]{(char)cValue};
                    return new String(character, 0, 1);
                }
                int cValue = Integer.parseInt(name.substring(1), 10);
                char[] character = new char[]{(char)cValue};
                return new String(character, 0, 1);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public Hashtable getTable() {
        return this.chars;
    }

    public static CharDecoder forXml() {
        CharDecoder decoder = new CharDecoder();
        decoder.setCharValue("amp", "&");
        decoder.setCharValue("lt", "<");
        decoder.setCharValue("gt", ">");
        decoder.setCharValue("apos", "'");
        decoder.setCharValue("quot", "\"");
        return decoder;
    }

    public static CharDecoder htmlCharacters() {
        CharDecoder decoder = new CharDecoder();
        decoder.setCharValue("amp", "&");
        decoder.setCharValue("lt", "<");
        decoder.setCharValue("gt", ">");
        decoder.setCharValue("apos", "'");
        decoder.setCharValue("quot", "\"");
        decoder.setCharValue("nbsp", "\u00a0");
        return decoder;
    }

    public void setCharValue(String name, String value) {
        this.chars.put(name, value);
    }
}

