/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    int minimum;
    int maximum;
    int selection;

    public ProgressBar(Composite parent, int style) {
        super(parent, style);
    }

    protected void internal_createHandle(int index) {
        this.internal_handle = OS.ProgressBar_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        nativeStyle = (this.internal_style & 0x200) == 512 ? (nativeStyle |= 8) : (nativeStyle |= 0x10);
        if ((this.internal_style & 0x10000) == 65536) {
            nativeStyle |= 0x10000;
        }
        if ((this.internal_style & 2) == 2) {
            nativeStyle |= 2;
        }
        return nativeStyle;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value <= this.minimum) {
            return;
        }
        if (this.selection > value) {
            OS.ProgressBar_SetSelection(this.internal_handle, value);
            this.selection = value;
        }
        OS.ProgressBar_SetMaximum(this.internal_handle, value);
        this.maximum = value;
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        if (value >= this.maximum) {
            return;
        }
        if (this.selection < value) {
            OS.ProgressBar_SetSelection(this.internal_handle, value);
            this.selection = value;
        }
        OS.ProgressBar_SetMinimum(this.internal_handle, value);
        this.minimum = value;
    }

    public void setSelection(int value) {
        this.checkWidget();
        if (value < this.minimum) {
            value = this.minimum;
        }
        if (value > this.maximum) {
            value = this.maximum;
        }
        OS.ProgressBar_SetSelection(this.internal_handle, value);
        this.selection = value;
    }
}

