/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.application;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.application.CompatibilityWorkbenchWindowAdvisor;

public abstract class WorkbenchAdvisor {
    private IWorkbenchConfigurer workbenchConfigurer;
    private boolean introOpened;

    protected WorkbenchAdvisor() {
    }

    public final void internalBasicInitialize(IWorkbenchConfigurer configurer) {
        if (this.workbenchConfigurer != null) {
            throw new IllegalStateException();
        }
        this.workbenchConfigurer = configurer;
        this.initialize(configurer);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
    }

    protected IWorkbenchConfigurer getWorkbenchConfigurer() {
        return this.workbenchConfigurer;
    }

    public void preStartup() {
    }

    public void postStartup() {
    }

    public boolean preShutdown() {
        return true;
    }

    public void postShutdown() {
    }

    public void eventLoopException(Throwable exception) {
        if (exception == null) {
            return;
        }
        try {
            String msg = exception.getMessage();
            if (msg == null) {
                msg = exception.toString();
            }
            WorkbenchPlugin.log("Unhandled event loop exception", (IStatus)new Status(4, "org.eclipse.ui", 0, msg, exception));
            if (WorkbenchPlugin.DEBUG) {
                exception.printStackTrace();
            }
        }
        catch (Throwable e) {
            System.err.println("Error while logging event loop exception:");
            exception.printStackTrace();
            System.err.println("Logging exception:");
            e.printStackTrace();
        }
    }

    public void eventLoopIdle(Display display) {
        display.sleep();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new CompatibilityWorkbenchWindowAdvisor(this, configurer);
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
    }

    public void postWindowRestore(IWorkbenchWindowConfigurer configurer) throws WorkbenchException {
    }

    public void openIntro(IWorkbenchWindowConfigurer configurer) {
    }

    public void postWindowCreate(IWorkbenchWindowConfigurer configurer) {
    }

    public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
    }

    public boolean preWindowShellClose(IWorkbenchWindowConfigurer configurer) {
        return true;
    }

    public void postWindowClose(IWorkbenchWindowConfigurer configurer) {
    }

    public boolean isApplicationMenu(IWorkbenchWindowConfigurer configurer, String menuId) {
        return false;
    }

    public IAdaptable getDefaultPageInput() {
        return null;
    }

    public abstract String getInitialWindowPerspectiveId();

    public String getMainPreferencePageId() {
        return null;
    }

    public void createWindowContents(IWorkbenchWindowConfigurer configurer, Shell shell) {
        ((WorkbenchWindowConfigurer)configurer).createDefaultContents(shell);
    }

    public boolean openWindows() {
        IStatus status = this.getWorkbenchConfigurer().restoreState();
        if (!status.isOK()) {
            if (status.getCode() == 2) {
                return false;
            }
            if (status.getCode() == 1) {
                this.getWorkbenchConfigurer().openFirstTimeWindow();
            }
        }
        return true;
    }

    public Control createEmptyWindowContents(IWorkbenchWindowConfigurer configurer, Composite parent) {
        return null;
    }
}

