/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.IObjectContributor;

public abstract class ObjectContributorManager
implements IExtensionChangeHandler {
    protected Map contributors = new Hashtable(5);
    protected Map objectLookup = null;
    protected Map resourceAdapterLookup = null;
    protected Map adaptableLookup = null;
    protected Set contributorRecordSet = new HashSet(5);
    static /* synthetic */ Class class$0;

    public ObjectContributorManager() {
        PlatformUI.getWorkbench().getExtensionTracker();
    }

    private void addContributorsFor(List types, List result) {
        Iterator classes = types.iterator();
        while (classes.hasNext()) {
            Class clazz = (Class)classes.next();
            List contributorList = (List)this.contributors.get(clazz.getName());
            if (contributorList == null) continue;
            result.addAll(contributorList);
        }
    }

    protected final List computeClassOrder(Class extensibleClass) {
        ArrayList result = new ArrayList(4);
        Class clazz = extensibleClass;
        while (clazz != null) {
            result.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    protected final List computeInterfaceOrder(List classList) {
        ArrayList result = new ArrayList(4);
        HashMap seen = new HashMap(4);
        Iterator list = classList.iterator();
        while (list.hasNext()) {
            Class[] interfaces = ((Class)list.next()).getInterfaces();
            this.internalComputeInterfaceOrder(interfaces, result, seen);
        }
        return result;
    }

    public void flushLookup() {
        this.objectLookup = null;
        this.resourceAdapterLookup = null;
        this.adaptableLookup = null;
    }

    private void cacheResourceAdapterLookup(Class adapterClass, List results) {
        if (this.resourceAdapterLookup == null) {
            this.resourceAdapterLookup = new HashMap();
        }
        this.resourceAdapterLookup.put(adapterClass, results);
    }

    private void cacheAdaptableLookup(String adapterClass, List results) {
        if (this.adaptableLookup == null) {
            this.adaptableLookup = new HashMap();
        }
        this.adaptableLookup.put(adapterClass, results);
    }

    private void cacheObjectLookup(Class objectClass, List results) {
        if (this.objectLookup == null) {
            this.objectLookup = new HashMap();
        }
        this.objectLookup.put(objectClass, results);
    }

    public Collection getContributors() {
        return Collections.unmodifiableCollection(this.contributors.values());
    }

    protected List addContributorsFor(Class objectClass) {
        List classList = this.computeClassOrder(objectClass);
        ArrayList result = new ArrayList();
        this.addContributorsFor(classList, result);
        classList = this.computeInterfaceOrder(classList);
        this.addContributorsFor(classList, result);
        return result;
    }

    public boolean hasContributorsFor(Object object) {
        List contributors = this.getContributors(object);
        return contributors.size() > 0;
    }

    private void internalComputeInterfaceOrder(Class[] interfaces, List result, Map seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(seen.size());
        int i = 0;
        while (i < interfaces.length) {
            Class interfac = interfaces[i];
            if (seen.get(interfac) == null) {
                result.add(interfac);
                seen.put(interfac, interfac);
                newInterfaces.add(interfac);
            }
            ++i;
        }
        Iterator newList = newInterfaces.iterator();
        while (newList.hasNext()) {
            this.internalComputeInterfaceOrder(((Class)newList.next()).getInterfaces(), result, seen);
        }
    }

    public boolean isApplicableTo(IStructuredSelection selection, IObjectContributor contributor) {
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            if (contributor.isApplicableTo(elements.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isApplicableTo(List list, IObjectContributor contributor) {
        Iterator elements = list.iterator();
        while (elements.hasNext()) {
            if (contributor.isApplicableTo(elements.next())) continue;
            return false;
        }
        return true;
    }

    public void registerContributor(IObjectContributor contributor, String targetType) {
        ArrayList<IObjectContributor> contributorList = (ArrayList<IObjectContributor>)this.contributors.get(targetType);
        if (contributorList == null) {
            contributorList = new ArrayList<IObjectContributor>(5);
            this.contributors.put(targetType, contributorList);
        }
        contributorList.add(contributor);
        this.flushLookup();
        if (contributor instanceof IAdaptable) {
            IConfigurationElement element;
            IAdaptable iAdaptable = (IAdaptable)contributor;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.IConfigurationElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (IConfigurationElement)iAdaptable.getAdapter((Class)clazz)) == null) {
                return;
            }
            ContributorRecord contributorRecord = new ContributorRecord(contributor, targetType);
            this.contributorRecordSet.add(contributorRecord);
            PlatformUI.getWorkbench().getExtensionTracker().registerObject(element.getDeclaringExtension(), (Object)contributorRecord, 2);
        }
    }

    public void unregisterAllContributors() {
        this.contributors = new Hashtable(5);
        this.flushLookup();
    }

    public void unregisterContributor(IObjectContributor contributor, String targetType) {
        List contributorList = (List)this.contributors.get(targetType);
        if (contributorList == null) {
            return;
        }
        contributorList.remove(contributor);
        if (contributorList.isEmpty()) {
            this.contributors.remove(targetType);
        }
        this.flushLookup();
    }

    public void unregisterContributors(String targetType) {
        this.contributors.remove(targetType);
        this.flushLookup();
    }

    protected List getContributors(Object object) {
        ArrayList<String> adapters = new ArrayList<String>(Arrays.asList(Platform.getAdapterManager().computeAdapterTypes(object.getClass())));
        this.removeCommonAdapters(adapters, Arrays.asList(object.getClass()));
        List contributors = this.getObjectContributors(object.getClass());
        if (adapters != null) {
            Iterator it = adapters.iterator();
            while (it.hasNext()) {
                String adapter = (String)it.next();
                contributors.addAll(this.getAdaptableContributors(adapter));
            }
        }
        return contributors;
    }

    protected List getObjectContributors(Class objectClass) {
        List objectList = null;
        if (this.objectLookup != null) {
            objectList = (List)this.objectLookup.get(objectClass);
        }
        if (objectList == null) {
            objectList = this.addContributorsFor(objectClass);
            if (objectList.size() == 0) {
                objectList = Collections.EMPTY_LIST;
            }
            this.cacheObjectLookup(objectClass, objectList);
        }
        return new ArrayList(objectList);
    }

    protected List getResourceContributors(Class resourceClass) {
        List resourceList = null;
        if (this.resourceAdapterLookup != null) {
            resourceList = (List)this.resourceAdapterLookup.get(resourceClass);
        }
        if (resourceList == null) {
            resourceList = this.addContributorsFor(resourceClass);
            resourceList = resourceList.size() == 0 ? Collections.EMPTY_LIST : this.filterOnlyAdaptableContributors(resourceList);
            this.cacheResourceAdapterLookup(resourceClass, resourceList);
        }
        return new ArrayList(resourceList);
    }

    protected List getAdaptableContributors(String adapterType) {
        List adaptableList = null;
        if (this.adaptableLookup != null) {
            adaptableList = (ArrayList)this.adaptableLookup.get(adapterType);
        }
        if (adaptableList == null) {
            adaptableList = new ArrayList(this.contributors.size());
            adaptableList = (List)this.contributors.get(adapterType);
            adaptableList = adaptableList == null || adaptableList.size() == 0 ? Collections.EMPTY_LIST : this.filterOnlyAdaptableContributors(adaptableList);
            this.cacheAdaptableLookup(adapterType, adaptableList);
        }
        return new ArrayList(adaptableList);
    }

    protected void removeCommonAdapters(List adapters, List results) {
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            List commonTypes = this.computeCombinedOrder(clazz);
            Iterator it2 = commonTypes.iterator();
            while (it2.hasNext()) {
                Class type = (Class)it2.next();
                adapters.remove(type.getName());
            }
        }
    }

    protected List computeCombinedOrder(Class inputClass) {
        ArrayList result = new ArrayList(4);
        Class clazz = inputClass;
        while (clazz != null) {
            result.add(clazz);
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                result.add(interfaces[i]);
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private List filterOnlyAdaptableContributors(List contributors) {
        ArrayList<IObjectContributor> adaptableContributors = null;
        Iterator it = contributors.iterator();
        while (it.hasNext()) {
            IObjectContributor c = (IObjectContributor)it.next();
            if (!c.canAdapt()) continue;
            if (adaptableContributors == null) {
                adaptableContributors = new ArrayList<IObjectContributor>();
            }
            adaptableContributors.add(c);
        }
        return adaptableContributors == null ? Collections.EMPTY_LIST : adaptableContributors;
    }

    public void removeExtension(IExtension source, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ContributorRecord) {
                ContributorRecord contributorRecord = (ContributorRecord)objects[i];
                this.unregisterContributor(contributorRecord.contributor, contributorRecord.objectClassName);
                this.contributorRecordSet.remove(contributorRecord);
            }
            ++i;
        }
    }

    public void dispose() {
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    private class ContributorRecord {
        String objectClassName;
        IObjectContributor contributor;

        public ContributorRecord(IObjectContributor contributor, String targetType) {
            this.contributor = contributor;
            this.objectClassName = targetType;
        }
    }
}

