/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBaseEntry;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarEditEntryDialog;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CalendarDayViewScreen
implements KeyListener,
SelectionListener {
    private static final int column_first = 0;
    private static final int column_second = 1;
    private static final int hour_nb = 16;
    private static final int start_hour = 6;
    private static final int end_hour = 21;
    private static CalendarDayViewScreen singleton = null;
    private Vector entriesoftheday;
    private Vector entriesInTable;
    private Date displayedDate;
    private CalendarShowCase calendarShowCase;
    private CalendarDataBase calendardatabase;
    private Shell shell;
    private GregorianCalendar g;
    private Command commandEditEntry;
    private Command commandNewEntry;
    private Command commandGoToDate;
    private Command commandExit;
    private Command commandChangeView;
    private Shell monthShell = null;
    private Table table;
    private Font fontColumn1;
    private Font fontColumn2;
    private boolean quit = false;

    public static CalendarDayViewScreen createUniqueInstance(CalendarShowCase calendarShowCase, CalendarDataBase calendardatabase) {
        if (singleton == null) {
            singleton = new CalendarDayViewScreen(calendarShowCase, calendardatabase);
        }
        return singleton;
    }

    private CalendarDayViewScreen(CalendarShowCase calendarShowCase, CalendarDataBase calendardatabase) {
        this.calendarShowCase = calendarShowCase;
        this.calendardatabase = calendardatabase;
        this.entriesInTable = new Vector();
        this.quit = false;
    }

    private void buildRessources() {
        this.shell = new Shell(this.calendarShowCase.getComposite().getShell(), 1056);
        Rectangle bgdArea = this.calendarShowCase.getComposite().getShell().getBounds();
        this.shell.setBounds(bgdArea);
        this.g = new GregorianCalendar();
    }

    public void activate(Shell monthShell, Date currentDay) {
        this.monthShell = monthShell;
        this.displayedDate = new Date();
        this.displayedDate.setTime(currentDay.getTime());
        this.entriesoftheday = this.calendardatabase.getEntriesOfTheDay(this.displayedDate);
        this.buildRessources();
        this.build();
    }

    public Date getDisplayedDate() {
        return (Date)this.displayedDate.clone();
    }

    private void build() {
        this.commandExit = new Command((Control)this.shell, 7, 0);
        this.commandExit.setText(Messages.getString("CalendarDayViewScreen.0"));
        this.commandExit.setLongLabel(Messages.getString("CalendarDayViewScreen.1"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        this.commandGoToDate = new Command((Control)this.shell, 1, 2);
        this.commandGoToDate.setText(Messages.getString("CalendarDayViewScreen.2"));
        this.commandGoToDate.addSelectionListener((SelectionListener)this);
        this.commandChangeView = new Command((Control)this.shell, 1, 3);
        this.commandChangeView.setText(Messages.getString("CalendarDayViewScreen.3"));
        this.commandChangeView.addSelectionListener((SelectionListener)this);
        this.buildTable();
        if (this.table != null) {
            this.table.forceFocus();
        }
        this.setInitialSelection();
        this.setEditCommands();
        this.shell.setText(this.HeaderfromDate());
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.open();
        this.shell.layout();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void setInitialSelection() {
        this.table.select(0);
    }

    private void buildTable() {
        if (this.table != null) {
            this.table.dispose();
        }
        this.table = new Table((Composite)this.shell, 2564);
        TableColumn testcolumn1 = new TableColumn(this.table, 2048);
        TableColumn testcolumn2 = new TableColumn(this.table, 2048);
        this.fontColumn1 = this.table.getFont();
        FontData[] fontData = this.fontColumn1.getFontData();
        this.fontColumn2 = new Font((Device)this.shell.getDisplay(), fontData[0]);
        fontData[0].setStyle(fontData[0].getStyle() | 2);
        this.fontColumn1 = new Font((Device)this.shell.getDisplay(), fontData[0]);
        this.fillTable();
        testcolumn1.pack();
        int width = testcolumn1.getWidth();
        Rectangle area = this.shell.getClientArea();
        testcolumn2.setWidth(area.width - width);
        this.table.addKeyListener((KeyListener)this);
        this.table.addSelectionListener((SelectionListener)this);
    }

    public void dispose() {
        this.limitedDispose();
        if (this.shell != null) {
            this.shell.dispose();
        }
    }

    private void limitedDispose() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setVisible(false);
            this.table.removeAll();
            this.table.dispose();
        }
        if (this.fontColumn1 != null && !this.fontColumn1.isDisposed()) {
            this.fontColumn1.dispose();
        }
        if (this.fontColumn2 != null && !this.fontColumn2.isDisposed()) {
            this.fontColumn2.dispose();
        }
        if (this.commandEditEntry != null) {
            this.commandEditEntry = null;
        }
        if (this.commandNewEntry != null) {
            this.commandNewEntry = null;
        }
        if (this.commandGoToDate != null) {
            this.commandGoToDate = null;
        }
        if (this.commandExit != null) {
            this.commandExit = null;
        }
        if (this.commandChangeView != null) {
            this.commandChangeView = null;
        }
        this.g = null;
    }

    private void setEditCommands() {
        int index = this.table.getSelectionIndex();
        if (index == -1) {
            return;
        }
        if (this.entriesInTable.get(index) != null) {
            if (this.commandEditEntry == null) {
                if (this.commandNewEntry != null) {
                    this.commandNewEntry.removeSelectionListener((SelectionListener)this);
                    this.commandNewEntry.dispose();
                    this.commandNewEntry = null;
                }
                this.commandEditEntry = new Command((Control)this.shell, 1, 5);
                this.commandEditEntry.setText(Messages.getString("CalendarDayViewScreen.4"));
                this.commandEditEntry.setLongLabel(Messages.getString("CalendarDayViewScreen.5"));
                this.commandEditEntry.addSelectionListener((SelectionListener)this);
                this.commandEditEntry.setDefaultCommand();
            }
        } else if (this.commandNewEntry == null) {
            if (this.commandEditEntry != null) {
                this.commandEditEntry.removeSelectionListener((SelectionListener)this);
                this.commandEditEntry.dispose();
                this.commandEditEntry = null;
            }
            this.commandNewEntry = new Command((Control)this.shell, 1, 5);
            this.commandNewEntry.setText(Messages.getString("CalendarDayViewScreen.6"));
            this.commandNewEntry.setLongLabel(Messages.getString("CalendarDayViewScreen.7"));
            this.commandNewEntry.addSelectionListener((SelectionListener)this);
            this.commandNewEntry.setDefaultCommand();
        }
    }

    private void resetTable() {
        this.resetVectors();
        this.table.setVisible(false);
        this.table.removeAll();
        this.fillTable();
        this.table.setVisible(true);
    }

    private String HeaderfromDate() {
        this.g.setTime(this.displayedDate);
        String newTitle = "";
        Locale locale = Locale.getDefault();
        DateFormat dateFormat = DateFormat.getDateInstance(0, locale);
        newTitle = String.valueOf(newTitle) + dateFormat.format(this.displayedDate);
        return newTitle;
    }

    private void fillTable() {
        int currentElement = 0;
        int currentRow = 0;
        this.entriesInTable.clear();
        int hour = 6;
        while (hour < 22) {
            TableItem item;
            if (currentElement >= this.entriesoftheday.size()) {
                this.fillRowsInTable(hour, currentRow);
                break;
            }
            this.g.setTime(((CalendarDataBaseEntry)this.entriesoftheday.get(currentElement)).getStartDate());
            Integer entryHour = new Integer(this.g.get(11));
            Integer integerHour = new Integer(hour);
            if (entryHour < 6) {
                entryHour = new Integer(6);
            }
            if (entryHour > 21) {
                entryHour = new Integer(21);
            }
            if (entryHour == hour) {
                item = new TableItem(this.table, 16384, currentRow);
                item.setText(0, this.hourToTableHour(integerHour).toString());
                item.setText(1, ((CalendarDataBaseEntry)this.entriesoftheday.get(currentElement)).toStringLarge());
                this.entriesInTable.add(this.entriesoftheday.get(currentElement));
                ++currentElement;
                ++currentRow;
                while (currentElement < this.entriesoftheday.size()) {
                    this.g.setTime(((CalendarDataBaseEntry)this.entriesoftheday.get(currentElement)).getStartDate());
                    entryHour = new Integer(this.g.get(11));
                    if (entryHour == hour) {
                        TableItem itemNoHour = new TableItem(this.table, 16384, currentRow);
                        itemNoHour.setText(1, ((CalendarDataBaseEntry)this.entriesoftheday.get(currentElement)).toStringLarge());
                        this.entriesInTable.add(this.entriesoftheday.get(currentElement));
                        ++currentElement;
                        ++currentRow;
                        continue;
                    }
                    break;
                }
            } else {
                item = new TableItem(this.table, 16384, currentRow);
                item.setText(0, this.hourToTableHour(integerHour).toString());
                this.entriesInTable.add(null);
                ++currentRow;
            }
            ++hour;
        }
        this.decorateTable();
    }

    private void fillRowsInTable(int hour, int currentRow) {
        int counter = hour;
        while (counter < 22) {
            TableItem item = new TableItem(this.table, 16384, currentRow);
            Integer integerHour = new Integer(counter);
            item.setText(0, this.hourToTableHour(integerHour).toString());
            this.entriesInTable.add(null);
            ++currentRow;
            ++counter;
        }
    }

    private Integer hourToTableHour(Integer actualHour) {
        if (actualHour > 12) {
            return new Integer(actualHour - 12);
        }
        return new Integer(actualHour);
    }

    /*
     * Unable to fully structure code
     */
    private int tableHourtoHour(int selectedRowIndex) {
        currentItem = this.table.getItem(this.table.getSelectionIndex());
        result = Integer.parseInt(currentItem.getText(0));
        if (result != 12) ** GOTO lbl8
        return 12;
lbl-1000:
        // 1 sources

        {
            currentItem = this.table.getItem(selectedRowIndex);
            if (Integer.parseInt(currentItem.getText(0)) != 12) continue;
            return result + 12;
lbl8:
            // 2 sources

            ** while (--selectedRowIndex > 0)
        }
lbl9:
        // 1 sources

        return result;
    }

    private Date CreateDate(int hour) {
        this.g.setTime(this.displayedDate);
        this.g.set(11, hour);
        this.g.set(12, 0);
        this.g.set(13, 0);
        Date startDate = this.g.getTime();
        return startDate;
    }

    private void decorateTable() {
        int row = 0;
        while (row < this.table.getItemCount()) {
            TableItem item = this.table.getItem(row);
            if (item == null) break;
            item.setFont(0, this.fontColumn1);
            item.setFont(1, this.fontColumn2);
            item.setBackground(0, this.shell.getDisplay().getSystemColor(18));
            ++row;
        }
    }

    private void createNewEntry() {
        int indexOfSelected = this.table.getSelectionIndex();
        int hour = this.tableHourtoHour(indexOfSelected);
        Date startDate = this.CreateDate(hour);
        CalendarDataBaseEntry newentry = new CalendarDataBaseEntry(startDate, startDate, Messages.getString("CalendarDayViewScreen.9"), Messages.getString("CalendarDayViewScreen.10"), null);
        this.OpenEditDialogAndManageResult(newentry, indexOfSelected, true);
    }

    private void editEntry() {
        int indexOfSelected = this.table.getSelectionIndex();
        CalendarDataBaseEntry entry = (CalendarDataBaseEntry)this.entriesInTable.get(indexOfSelected);
        this.OpenEditDialogAndManageResult(entry, indexOfSelected, false);
    }

    private void OpenEditDialogAndManageResult(CalendarDataBaseEntry entry, int indexOfSelected, boolean isNewEntry) {
        CalendarEditEntryDialog dialogEditEntry = new CalendarEditEntryDialog(this.shell);
        boolean result = dialogEditEntry.open(entry, isNewEntry);
        if (result) {
            if (isNewEntry) {
                this.calendardatabase.addEntry(entry);
                this.resetTable();
            } else {
                CalendarDataBaseEntry clone = (CalendarDataBaseEntry)entry.clone();
                this.calendardatabase.removeEntry(entry);
                this.calendardatabase.addEntry(clone);
                this.resetTable();
            }
        } else if (!isNewEntry) {
            this.calendardatabase.removeEntry(entry);
            this.entriesInTable.set(indexOfSelected, null);
            this.resetTable();
            if (indexOfSelected == this.entriesInTable.size()) {
                --indexOfSelected;
            }
        }
        this.table.setSelection(indexOfSelected);
        this.table.showItem(this.table.getItem(indexOfSelected));
        this.setEditCommands();
    }

    private void updateView() {
        this.resetTable();
        this.shell.setText(this.HeaderfromDate());
        this.setInitialSelection();
    }

    private void resetVectors() {
        this.entriesoftheday.clear();
        this.entriesInTable.clear();
        this.entriesoftheday = this.calendardatabase.getEntriesOfTheDay(this.displayedDate);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.setEditCommands();
        if (e.widget.equals(this.table)) {
            if (this.commandNewEntry != null) {
                this.createNewEntry();
            } else if (this.commandEditEntry != null) {
                this.editEntry();
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            Date result;
            if (e.widget.equals(this.commandChangeView)) {
                this.dispose();
                if (this.monthShell != null) {
                    this.monthShell.setFocus();
                }
            } else if (e.widget.equals(this.commandExit)) {
                this.setQuit(true);
                this.dispose();
            } else if (e.widget.equals(this.commandNewEntry)) {
                this.createNewEntry();
            } else if (e.widget.equals(this.commandEditEntry)) {
                this.editEntry();
            } else if (e.widget.equals(this.table)) {
                this.setEditCommands();
            } else if (e.widget.equals(this.commandGoToDate) && (result = this.calendarShowCase.goToDate(this.shell)) != null) {
                this.displayedDate = result;
                this.updateView();
            }
        }
        catch (Exception exception) {}
    }

    public void keyPressed(KeyEvent e) {
        this.g.setFirstDayOfWeek(1);
        this.g.setTime(this.displayedDate);
        if (e.keyCode == 0x1000004) {
            if (this.g.get(2) == 11 && this.g.get(5) == 31) {
                return;
            }
            this.g.add(6, 1);
            this.displayedDate = this.g.getTime();
            this.updateView();
        } else if (e.keyCode == 0x1000003) {
            if (this.g.get(2) == 0 && this.g.get(5) == 1) {
                return;
            }
            this.g.add(6, -1);
            this.displayedDate = this.g.getTime();
            this.updateView();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public boolean quitWanted() {
        return this.quit;
    }

    private void setQuit(boolean quitWanted) {
        this.quit = quitWanted;
    }
}

